% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanmvreg-methods.R, R/stanreg-methods.R
\name{nobs.stanmvreg}
\alias{nobs.stanmvreg}
\alias{stanreg-methods}
\alias{VarCorr}
\alias{fixef}
\alias{ranef}
\alias{ngrps}
\alias{sigma}
\alias{nsamples}
\alias{coef.stanreg}
\alias{confint.stanreg}
\alias{fitted.stanreg}
\alias{nobs.stanreg}
\alias{residuals.stanreg}
\alias{se.stanreg}
\alias{update.stanreg}
\alias{vcov.stanreg}
\alias{fixef.stanreg}
\alias{ngrps.stanreg}
\alias{nsamples.stanreg}
\alias{ranef.stanreg}
\alias{sigma.stanreg}
\alias{VarCorr.stanreg}
\title{Methods for stanreg objects}
\usage{
\method{nobs}{stanmvreg}(object, ...)

\method{coef}{stanreg}(object, ...)

\method{confint}{stanreg}(object, parm, level = 0.95, ...)

\method{fitted}{stanreg}(object, ...)

\method{nobs}{stanreg}(object, ...)

\method{residuals}{stanreg}(object, ...)

\method{se}{stanreg}(object, ...)

\method{update}{stanreg}(object, formula., ..., evaluate = TRUE)

\method{vcov}{stanreg}(object, correlation = FALSE, ...)

\method{fixef}{stanreg}(object, ...)

\method{ngrps}{stanreg}(object, ...)

\method{nsamples}{stanreg}(object, ...)

\method{ranef}{stanreg}(object, ...)

\method{sigma}{stanreg}(object, ...)

\method{VarCorr}{stanreg}(x, sigma = 1, ...)
}
\arguments{
\item{object, x}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{...}{Ignored, except by the \code{update} method. See
\code{\link{update}}.}

\item{parm}{For \code{confint}, an optional character vector of parameter
names.}

\item{level}{For \code{confint}, a scalar between \eqn{0} and \eqn{1}
indicating the confidence level to use.}

\item{formula., evaluate}{See \code{\link[stats]{update}}.}

\item{correlation}{For \code{vcov}, if \code{FALSE} (the default) the
covariance matrix is returned. If \code{TRUE}, the correlation matrix is
returned instead.}

\item{sigma}{Ignored (included for compatibility with
\code{\link[nlme]{VarCorr}}).}
}
\description{
The methods documented on this page are actually some of the least important 
methods defined for \link[=stanreg-objects]{stanreg} objects. The most 
important methods are documented separately, each with its own page. Links to
those pages are provided in the \strong{See Also} section, below.
}
\details{
The methods documented on this page are similar to the methods 
  defined for objects of class 'lm', 'glm', 'glmer', etc. However there are a
  few key differences:
  
\describe{
\item{\code{residuals}}{
Residuals are \emph{always} of type \code{"response"} (not \code{"deviance"}
residuals or any other type). However, in the case of \code{\link{stan_polr}}
with more than two response categories, the residuals are the difference 
between the latent utility and its linear predictor.
}
\item{\code{coef}}{
Medians are used for point estimates. See the \emph{Point estimates} section
in \code{\link{print.stanreg}} for more details.
}
\item{\code{se}}{
The \code{se} function returns standard errors based on 
\code{\link{mad}}. See the \emph{Uncertainty estimates} section in
\code{\link{print.stanreg}} for more details.
}
\item{\code{confint}}{
For models fit using optimization, confidence intervals are returned via a 
call to \code{\link[stats]{confint.default}}. If \code{algorithm} is 
\code{"sampling"}, \code{"meanfield"}, or \code{"fullrank"}, the
\code{confint} will throw an error because the
\code{\link{posterior_interval}} function should be used to compute Bayesian 
uncertainty intervals.
}
\item{\code{nsamples}}{
The number of draws from the posterior distribution obtained
}
}
}
\seealso{
\itemize{
 \item The \code{\link[=print.stanreg]{print}},
   \code{\link[=summary.stanreg]{summary}}, and \code{\link{prior_summary}} 
   methods for stanreg objects for information on the fitted model.
 \item \code{\link{launch_shinystan}} to use the ShinyStan GUI to explore a
   fitted \pkg{rstanarm} model.
 \item The \code{\link[=plot.stanreg]{plot}} method to plot estimates and
   diagnostics.
 \item The \code{\link{pp_check}} method for graphical posterior predictive
   checking.
 \item The \code{\link{posterior_predict}} and \code{\link{predictive_error}}
   methods for predictions and predictive errors.
 \item The \code{\link{posterior_interval}} and \code{\link{predictive_interval}}
   methods for uncertainty intervals for model parameters and predictions.
 \item The \code{\link[=loo.stanreg]{loo}}, \code{\link{kfold}}, and
 \code{\link{log_lik}} methods for leave-one-out or K-fold cross-validation, 
   model comparison, and computing the log-likelihood of (possibly new) data.
 \item The \code{\link[=as.matrix.stanreg]{as.matrix}}, \code{as.data.frame}, 
   and \code{as.array} methods to access posterior draws.
}
}
