
#include "Vlib.h"

#if !HAVE_STDLIB_H
#if HAVE_MALLOC_H
#include <malloc.h>
#else
extern char *malloc();

#endif
#endif

#ifdef WIN32
#undef Vmalloc
#endif

char     *
Vmalloc(int size)
{

	char     *p;

	if ((p = malloc(size)) == (char *) NULL) {
		fprintf(stderr, "V package memory allocation error.\n");
		fprintf(stderr, "An error was encountered allocating\
 %d bytes.\n", size);
		exit(1);
	}
	return p;
}

#ifdef WIN32

#include <crtdbg.h>

char     *
Vmalloc_dbg(int size, const char *file, const int line)
{

	char     *p;

	if ((p = _malloc_dbg(size, _NORMAL_BLOCK, file, line)) == (char *) NULL) {
		fprintf(stderr, "V package memory allocation error.\n");
		fprintf(stderr, "An error was encountered allocating\
 %d bytes.\n", size);
		exit(1);
	}
	return p;
}

#endif
