#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(3); 

    symbol x0("x0"), x1("x1"), y0("y0"), y1("y1"), z0("z0"), z1("z1");

    ex p0 = lst(x0,y0,z0);
    ex p1 = lst(x1,y1,z1);

    Line line(p0,p1);

    symbol t("t"); 
    ex l_repr = line.repr(t);
    cout <<"l.repr "<<l_repr<<endl; 


    for (unsigned int i=0; i< l_repr.nops(); i++) {
        cout <<"l_repr.op(" <<i<<"):  "<<l_repr.op(i)<<endl; 
    }

    ex f = x*x + y*y*y + z;
    ex intf = line.integrate(f); 
    cout <<"intf "<<intf<<endl; 

    // regression test
    /*
    
    archive ar; 
    ar.archive_ex(l_repr, "l_repr"); 
    ar.archive_ex(intf, "intf"); 

    ofstream vfile("line_ex2.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("line_ex2.gar.v", "line_ex2.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }
    */

    return 0; 
}

