#ifndef __INPUT_LEGACY_H__
#define __INPUT_LEGACY_H__

#include <vector>
#include <string>
#include <unordered_map>
#include "db/xmDatabase.h"
#include "Input.h"
#include "XMKey.h"

// Maps keycodes from SDL 1.2 to 2.0. Unchanged values are omitted
static const std::unordered_map<int32_t, int32_t> SDL12_KEYTABLE = {
  {  12, 1073741980 },
  {  19, 1073741896 },
  { 256, 1073741922 },
  { 257, 1073741913 },
  { 258, 1073741914 },
  { 259, 1073741915 },
  { 260, 1073741916 },
  { 261, 1073741917 },
  { 262, 1073741918 },
  { 263, 1073741919 },
  { 264, 1073741920 },
  { 265, 1073741921 },
  { 266, 1073741923 },
  { 267, 1073741908 },
  { 268, 1073741909 },
  { 269, 1073741910 },
  { 270, 1073741911 },
  { 271, 1073741912 },
  { 272, 1073741927 },
  { 273, 1073741906 },
  { 274, 1073741905 },
  { 275, 1073741903 },
  { 276, 1073741904 },
  { 277, 1073741897 },
  { 278, 1073741898 },
  { 279, 1073741901 },
  { 280, 1073741899 },
  { 281, 1073741902 },
  { 282, 1073741882 },
  { 283, 1073741883 },
  { 284, 1073741884 },
  { 285, 1073741885 },
  { 286, 1073741886 },
  { 287, 1073741887 },
  { 288, 1073741888 },
  { 289, 1073741889 },
  { 290, 1073741890 },
  { 291, 1073741891 },
  { 292, 1073741892 },
  { 293, 1073741893 },
  { 294, 1073741928 },
  { 295, 1073741929 },
  { 296, 1073741930 },
  { 300, 1073741907 },
  { 301, 1073741881 },
  { 302, 1073741895 },
  { 303, 1073742053 },
  { 304, 1073742049 },
  { 305, 1073742052 },
  { 306, 1073742048 },
  { 307, 1073742054 },
  { 308, 1073742050 },
  { 311, 1073742051 },
  { 312, 1073742055 },
  { 313, 1073742081 },
  { 315, 1073741941 },
  { 316, 1073741894 },
  { 317, 1073741978 },
  { 319, 1073741942 },
  { 320, 1073741926 },
  { 322, 1073741946 },
};

class InputSDL12Compat {
private:
  InputSDL12Compat();
  ~InputSDL12Compat();

public:
  static void remap();
  static void mapKey(XMKey &key);
  static void resolveConflicts(const std::vector<IFullKey *> &keys);
};

#endif
