/* WhySynth DSSI software synthesizer plugin
 *
 * Copyright (C) 2005-2008 Sean Bolton and others.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include <stdlib.h>

#include "whysynth_types.h"
#include "dssp_event.h"
#include "effects.h"

/* Okay, this is really goofy, the result of having changed my mind at least
 * twice while writing it.
 *
 * Basically the idea was to allow y_instantiate() a way to query effects as to
 * their memory needs, then allocate one buffer to be shared between different
 * effects.  As it is now, the effect_*_request_buffers() functions for each
 * effect need to call effects_request_buffer() for each piece of memory they
 * need, but they can't access that memory (beyond the first 4Kb) from within
 * the effect_*_request_buffers() function itself.
 * 
 * -FIX- need to redesign effect buffer allocation and sharing.
 */

/*
 * effects_reset_allocation
 */
void
effects_reset_allocation(y_synth_t *synth)
{
    synth->effect_buffer_allocation = 0;
}

/*
 * effects_request_buffer
 */
void *
effects_request_buffer(y_synth_t *synth, size_t size)
{
    void *p = (void *)((char *)(synth->effect_buffer) + synth->effect_buffer_allocation);

    synth->effect_buffer_allocation += size;
    if (synth->effect_buffer_highwater < synth->effect_buffer_allocation)
        synth->effect_buffer_highwater = synth->effect_buffer_allocation;
    /* printf("allocation = %ld, highwater = %ld\n", synth->effect_buffer_allocation, synth->effect_buffer_highwater); */
    return p;
}

/*
 * effects_setup
 */
int
effects_setup(y_synth_t *synth)
{
    synth->effect_buffer = (void *)malloc(4096);
    if (!synth->effect_buffer)
        return 0;

    synth->effect_buffer_highwater = 0;
    effects_reset_allocation(synth);
    effect_reverb_request_buffers(synth);
    effects_reset_allocation(synth);
    effect_delay_request_buffers(synth);
    if (synth->effect_buffer_highwater > 4096) {
        free(synth->effect_buffer);
        synth->effect_buffer = (void *)calloc(1, synth->effect_buffer_highwater);
        if (!synth->effect_buffer)
            return 0;
    }

    return 1;
}

/*
 * effects_cleanup
 */
void
effects_cleanup(y_synth_t *synth)
{
    if (synth->effect_buffer) free(synth->effect_buffer);
    synth->effect_buffer = NULL;
}

