#!/usr/bin/env python

import glob, os
from distutils.core import setup, Extension

# Pygoom extension ##############################################

# sources
sources = ['src/goom.c', 'src/aclib.c']

# includes
includes = ['./include',
            './plugins/goom/',
            '/usr/include/SDL/',
            '/usr/include/python2.3/pygame/',
           ]

# TODO: extract from the config.mk
CFLAGS = ['-O9','-mmmx','-DUSE_MMX','-DARCH_X86','-Wall']

# libraries
libdir    = ['./plugins/goom/', '/usr/lib/' ]

libraries = ['goom', 'SDL', 'glib']

pympav_1 = Extension('pygoom', 
                     include_dirs       = includes,
                     sources            = sources,
                     library_dirs       = libdir,
                     extra_compile_args = CFLAGS,
                     libraries          = libraries )


# Setup #########################################################
setup ( name = 'pygoom',
        version = '0.1',
        description = 'Goom bindings for Python',
        ext_modules = [pympav_1]
        )

