/***************************************************************************/
/*  Module:      $Id: misc.c,v 1.3 1995/05/24 00:50:10 maf Exp $
/*  Description: misc functions for sendpage
/*  Author:      maf
/*
/* Copyright (c) 1995 Mark Fullmer and The Ohio State University
/***************************************************************************/

/*
$Log: misc.c,v $
 * Revision 1.3  1995/05/24  00:50:10  maf
 * added hpux support
 *
 * Revision 1.2  1995/03/15  04:40:54  maf
 * *** empty log message ***
 *
 * Revision 1.1  1995/01/10  01:43:34  maf
 * Initial revision
 *
*/


#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <syslog.h>
#include <stdlib.h>
#include "report.h"
#include "sendpage.h"

#ifdef NEED_MALLOC_H
#include <malloc.h>
#endif

/*********************************************************************/
/* Function: GetLine
/*
/* Returns: 0 for good (a line ending in 0x0d was received)
/*          1 for good (eof)
/*			others for bad
/*
/*********************************************************************/
GetLine (fd, lbuf)
int fd;
struct linebuf *lbuf;
{

	extern int errno, debug;
	int n, x, match;
	char *tmpp;

	match = 0;

	/* allocate the initial size */
	if (!lbuf->buf) {
		if (!(lbuf->buf = (char*) malloc((unsigned)ADD_LINE_BLOCKSIZE))) 
			return -1; /* bad */
		++lbuf->nblocks;
	}

	/* clean up after the previous invocation */
	if (lbuf->len) {
		bcopy(lbuf->buf+lbuf->len, lbuf->buf, lbuf->bufused - lbuf->len);
		lbuf->bufused -= lbuf->len;
		lbuf->len = 0;
	}

	x = 0;

	while (1) {

		if ((n = read(fd, lbuf->buf+lbuf->bufused, (int)
			(ADD_LINE_BLOCKSIZE*lbuf->nblocks-lbuf->bufused))) == -1)
			return -1; /* bad */

		lbuf->bufused += n;

		for (;lbuf->len < lbuf->bufused; ++lbuf->len) {

			if (lbuf->buf[lbuf->len] == '\n') {
				match = 1;
				++ lbuf->len;
				break;
			} /* if */

		} /* for */

	if (match) {
		if (lbuf->len)
			lbuf->len2 = lbuf->len - 1;
		else
			lbuf->len2 = 0;
		return 0; /* good */
	}

	/* if nothing was read, return what's here */
	if (!n) {
		lbuf->len2 = lbuf->len;
		return 1; /* good/eof */
	}


	/* add more buf space if needed */
	if (lbuf->bufused == (ADD_LINE_BLOCKSIZE*lbuf->nblocks)) {
		tmpp = lbuf->buf;
		if (!(lbuf->buf = (char*)realloc(lbuf->buf, (unsigned)
			(++lbuf->nblocks*ADD_LINE_BLOCKSIZE)))) {
				lbuf->buf = tmpp;
				return -1; /* bad */
			}
		}
		
	} /* while 1 */
} /* GetLine */

/*********************************************************************/
/* Function: AddMessage
/*	Adds a string p of length len to a list m dynamically, and
/*	null terminates it.
/*
/*	Returns:	0	good
/*				!0	bad
/*
/*	The initial call should have msglist bzero()'d.
/*********************************************************************/
AddMessage(m, len, p)
struct msglist *m;
int len;
char *p;
{

	int i;

	i = m->nmessages;

	if ((++m->nmessages) > (m->nblocks * ADD_MSG_BLOCKSIZE)) 
		/* allocate more free message blocks */
		if (!m->nblocks) {
			if (!(m->messages = (char**) malloc (
				(unsigned)(++m->nblocks *  ADD_MSG_BLOCKSIZE * sizeof(char*)))))
					return 1; /* bad */
		} else {
			if (!(m->messages = (char**) realloc (m->messages, 
				(unsigned)(++m->nblocks *  ADD_MSG_BLOCKSIZE * sizeof(char*)))))
					return 1; /* bad */
		}

	if (!(m->messages[i] = (char*)malloc((unsigned)len+1)))
		return 1; /* bad */

	strncpy(m->messages[i], p, len);
	m->messages[i][len] = 0; /* null terminate it */

	return 0; /* good */
} /* AddMessage */

#ifdef DEBUG
#ifdef SYSV_MALLOC
PrintMallinfo(m)
struct mallinfo m;
{

	printf(
		"total space in arena=                                 %d\n", m.arena);
	printf(
		"number of ordinary blocks=                            %d\n", m.ordblks);
	printf(
		"number of small blocks=                               %d\n", m.smblks);
	printf(
		"number of holding blocks=                             %d\n", m.hblks);
	printf(
		"space in holding block headers=                       %d\n", m.hblkhd);
	printf(
		"space in small blocks in use=                         %d\n", m.usmblks);
	printf(
		"space in free small blocks=                           %d\n", m.fsmblks);
	printf(
		"space in ordinary blocks in use=                      %d\n", m.uordblks);
	printf(
		"space in free ordinary blocks=                        %d\n", m.fordblks);
	printf(
		"cost of enabling keep option=                         %d\n", m.keepcost);
#ifndef hpux
	printf(
		"max size of small blocks=                             %d\n", m.mxfast);
	printf(
		"number of small blocks in a holding block=            %d\n", m.nlblks);
	printf(
		"small block rounding factor=                          %d\n", m.grain);
	printf(
		"space (including overhead) allocated in ord. blocks=  %d\n", m.uordbytes);
	printf(
		"number of ordinary blocks allocated=                  %d\n", m.allocated);
	printf(
		"bytes used in maintaining the free tree=              %d\n", m.treeoverhead);
#endif

	printf("\n\n");

};

#endif /* SYSV_MALLOC */
#endif /* DEBUG */
