/*------------------------------------------------------------------
 * roxload.cmd :
 *------------------------------------------------------------------
 * 08-19-93 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

parse arg fileSpecs

if (fileSpecs = "") then
   Usage()

if RxFuncQuery("SysLoadFuncs") then
   do
   rc = RxFuncAdd("SysLoadFuncs","RexxUtil","SysLoadFuncs")
   rc = SysLoadFuncs()
   end

/*------------------------------------------------------------------
 * process each file spec
 *------------------------------------------------------------------*/
class.  = ""
class.0 = 0

do i = 1 to words(fileSpecs)
   rc = processFileSpec(word(fileSpecs,i))
end

do i = 1 to class.0
   class = class.i

   say copies("-",70)
   say "class:" class

   /*---------------------------------------------------------------
    * inherited classes
    *---------------------------------------------------------------*/
   say "   inherits"
   rc = printInherits(class,0)

   /*---------------------------------------------------------------
    * vars
    *---------------------------------------------------------------*/
   say "   vars"
   vars = class.class.!vars
   do j = 1 to words(vars)
      say "        " word(vars,j)
   end

   ivars = inheritedVars(class,vars)
   do j = 1 to words(ivars)
      say "       *" word(ivars,j)
   end

   /*---------------------------------------------------------------
    * methods
    *---------------------------------------------------------------*/
   say "   methods"
   methods = class.class.!methods
   do j = 1 to words(methods)
      say "        " word(methods,j)
   end

   imethods = inheritedMethods(class,methods)
   do j = 1 to words(imethods)
      say "       *" word(imethods,j)
   end

   say
end

exit

/*------------------------------------------------------------------
 * process a file specification
 *------------------------------------------------------------------*/
processFileSpec: procedure expose class.

   rc = SysFileTree(arg(1),"file.","FO")

   if (rc <> 0) then
      file.0 = 0

   do i = 1 to file.0
      rc = processFile(file.i)
   end

   return ""

/*------------------------------------------------------------------
 * process a file
 *------------------------------------------------------------------*/
processFile: procedure expose class.
   fileName = arg(1)

   if ("" = stream(fileName,"C","QUERY EXISTS")) then
      do
      say "File '"fileName"' does not exist."
      return 1
      end

   /*------------------------------------------------------------------
    * read the file
    *------------------------------------------------------------------*/
   line.0 = 0

   do i = 1 by 1 while (lines(fileName) > 0)
      line = linein(fileName)

      line.0 = i
      line.i = line
   end

   rc = stream(fileName,"C","CLOSE")

   /*------------------------------------------------------------------
    * start processing
    *------------------------------------------------------------------*/
   class      = ""

   do lineNo = 1 to line.0
      line = line.lineNo

      if (substr(line,1,2) = ":*") then
         iterate

      /*---------------------------------------------------------------
       * keyword found?
       *---------------------------------------------------------------*/
      if (substr(line,1,1) <> ":") then
         iterate

      /*------------------------------------------------------------
       * handle keyword line
       *------------------------------------------------------------*/
      parse var line ":" key rest
      parse var rest rest1 .

      key = translate(key)
      select
         when (key = "CLASS") then
            do
            class = rest1

            if (class.class = "") then
               do
               o           = class.0 + 1
               class.0     = o
               class.o     = class
               class.class = o
               end
            end

         when (key = "INCLUDE") then
            rc = processFile(rest1)

         when (key = "INHERITS") then
            do i = 1 to words(rest)
               var = word(rest,i)
               class.class.!inherits = class.class.!inherits var
            end

         when (key = "VARS") then
            do i = 1 to words(rest)
               var = word(rest,i)
               class.class.!vars = class.class.!vars var
            end

         when (key = "METHOD") then
            class.class.!methods = class.class.!methods rest1

         otherwise
            nop
      end

   end

   return 0

/*------------------------------------------------------------------
 * printed inherited class 'tree'
 *------------------------------------------------------------------*/
printInherits: procedure expose class.
   class  = arg(1)
   indent = arg(2)

   inherits = class.class.!inherits
   do i = 1 to words(inherits)
      inherit = word(inherits,i)

      say "        " copies(" ",indent) || inherit

      rc = printInherits(inherit,indent+1)
   end

   return ""

/*------------------------------------------------------------------
 * return inherited variables for a class
 *------------------------------------------------------------------*/
inheritedVars: procedure expose class.
   class = arg(1)
   vars  = arg(2)

   inherits = class.class.!inherits

   ivars = ""
   do i = 1 to words(inherits)
      iclass = word(inherits,i)
      newvars = class.iclass.!vars inheritedVars(iclass)

      do j = 1 to words(newvars)
         newvar = word(newvars,j)
         if (0 = wordpos(newvar,vars)) &,
            (0 = wordpos(newvar,ivars)) &,
            ("INIT" <> translate(newvar)) &,
            ("DEINIT" <> translate(newvar)) then
            ivars = ivars newvar
      end

   end

   return space(ivars)

/*------------------------------------------------------------------
 * return inherited methods for a class
 *------------------------------------------------------------------*/
inheritedMethods: procedure expose class.
   class   = arg(1)
   methods = arg(2)

   inherits = class.class.!inherits

   imethods = ""
   do i = 1 to words(inherits)
      iclass = word(inherits,i)
      newmethods  = class.iclass.!methods inheritedMethods(iclass)

      do j = 1 to words(newmethods)
         newmethod = word(newmethods,j)
         if (0 = wordpos(newmethod,methods)) &,
            (0 = wordpos(newmethod,imethods)) &,
            ("INIT" <> translate(newmethod)) &,
            ("DEINIT" <> translate(newmethod)) then
            imethods = imethods newmethod
      end
   end

   return space(imethods)


/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage: procedure
   parse source . . me .
   if (os = "OS/2") then
      parse value filespec("name",me) with me "." .

   say "usage:"
   say "   " me "<fileSpec> <fileSpec> ..."
   say "is used to display Rox class info from the specified files"
   say
   say "where:"
   say "   <fileSpec> - is a file specification"
   say
   say "For each class defined in the .rox files specified, the following"
   say "information is provided:"
   say "   - class name"
   say "   - 'tree' of inherited classes"
   say "   - list of variables (variables with * beside them are inherited)"
   say "   - list of methods (methods with * beside them are inherited)"

   exit
