//
//  XTHtmlTagSmall.m
//  XTads
//
//  Created by Rune Berg on 12/07/16.
//  Copyright © 2016 Rune Berg. All rights reserved.
//

#import "XTHtmlTagSmall.h"


@implementation XTHtmlTagSmall

+ (NSString *)name
{
	return @"small";
}

+ (BOOL)standalone
{
	return NO;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	NSInteger newHtmlSize = formattingSpec.baseHtmlSize - 1;
	if (newHtmlSize < 1) {
		newHtmlSize = 1;
	}
	res.htmlSize = newHtmlSize;
	return res;
}

@end
