#charset "us-ascii"
/* 
 *  Copyright (c) 2006 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Relation Library Extension
 *
 *  element.t
 *
 *--------------------------------------------------------------------
 *  THE TADS 3 ELEMENT FILE
 *--------------------------------------------------------------------
 */

#include "relation.h"

/*
 *  The ElementObject class provides a general
 *  container for both SetObject and RelationSetObject class
 *  elements. 
 */
class ElementObject: PreinitObject
{
    parms       = []

    execAfter = [RelationPreinit]

    execute()
    {
        if (location)
        {
            initInstance();
        }
    }

    initInstance()
    {
        if (location.elmKind)
        {
            location.elmKind.createInstance(location, parms...);
        }
        else
        {
            foreach (local elm in parms)
            {
                location.addElement(elm);
            }
        }
    }

    construct(location, [parms])
    {
        self.location   = location;
        self.parms      = parms;

        initInstance();
    }
}