//
//  XTHtmlTagVerbatim.m
//  XTads
//
//  Created by Rune Berg on 23/01/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTHtmlTagVerbatim.h"


@implementation XTHtmlTagVerbatim

+ (BOOL)standalone
{
	return NO;
}

- (BOOL)blockLevel
{
	return YES;
}

- (BOOL)blockLevelSpacingBefore
{
	return YES;
}

- (BOOL)blockLevelSpacingAfter
{
	return YES;
}

- (BOOL)honorContainedTags
{
	return NO;
}

- (BOOL)honorVerbatimWhitespace
{
	return YES;
}

- (BOOL)honorVerbatimNewlines
{
	return [self honorVerbatimWhitespace];
}

- (void)onParsing:(NSObject<XTOutputTextParserProtocol> *)parser
{
	[super onParsing:parser];
	
	[parser enterVerbatimMode:self];
}

- (void)onClose:(NSObject<XTOutputTextParserProtocol> *)parser
{
	[super onClose:parser];
	
	[parser exitVerbatimMode];
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	
	res.verbatim = YES;
	
	NSInteger newHtmlSize = formattingSpec.baseHtmlSize - 1;
	if (newHtmlSize < 1) {
		newHtmlSize = 1;
	}
	res.htmlSize = newHtmlSize;

	return res;
}

@end
