//
//  XTHtmlTagListContainer.m
//  XTads
//
//  Created by Rune Berg on 19/07/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTHtmlTagListContainer.h"
#import "XTHtmlTag_private.h"


@interface XTHtmlTagListContainer ()

@property NSUInteger listLevel;

@end


@implementation XTHtmlTagListContainer

+ (BOOL)standalone
{
	return NO;
}

- (BOOL)needsBlockLevelSpacingBefore
{
	return [self needsBlockLevelSpacingBeforeAndAfter];
}

- (BOOL)needsBlockLevelSpacingAfter
{
	return [self needsBlockLevelSpacingBeforeAndAfter];
}

- (BOOL)needsBlockLevelSpacingBeforeAndAfter
{
	BOOL res = (self.listLevel == 1);
		//TODO !!! too simplistic when list is nested on other indenting tag (e.g. <blockquote>)? -- try ! .container is a listcontainer
	return res;
}

- (void)onParsing:(NSObject<XTOutputTextParserProtocol> *)parser
{
	[super onParsing:parser];
	self.listLevel = [self.container getListNestingLevel];
	if ([self contributesToListNestingLevel]) {
		self.listLevel += 1;
	}
}

- (BOOL)contributesToListNestingLevel
{
	return YES;
}

- (NSUInteger)getListNestingLevel
{
	return self.listLevel;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	res.listLevel = [self getListNestingLevel];
	res.inListItem = NO;
	res.inListItemAfterFirstParagraph = NO;
	return res;
}

- (void)zeroListLevel
{
	self.listLevel = 0;
}

@end
