//
//  XTHtmlTagContainer.h
//  XTads
//
//  Created by Rune Berg on 10/05/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTHtmlTag.h"
#import "XTOutputTextParserProtocol.h"


@interface XTHtmlTagContainer : XTHtmlTag

@property BOOL closed;

@property (readonly) NSNumber *cachedIsEnclosedByListOrListItem;

@property (readonly) BOOL hasFormattedExit;

- (void)appendToContents:(XTHtmlTag *)tag;

- (void)removeFromContents:(XTHtmlTag *)tag;

- (BOOL)hasContents;

- (void)onClose:(NSObject<XTOutputTextParserProtocol> *)parser;

- (void)preClose:(NSObject<XTOutputTextParserProtocol> *)parser;

- (void)postClose:(NSObject<XTOutputTextParserProtocol> *)parser;

- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter
	   textHandler:(XTBaseTextHandler *)textHandler;

- (void)removeChildren;

- (void)removeChildrenUntilFirstOpenContainer;

@end
