//
//  XTBaseTextHandler.h
//  XTads
//
//  Created by Rune Berg on 11/08/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTGameWindowController.h"
#import "XTOutputFormatter.h"
#import "XTOutputTextParserPlain.h"
#import "XTOutputTextParserHtml.h"
#import "XTPrefs.h"
#import "XTColorationHelper.h"
#import "XTTextStorageBatcher.h"


#define NO_CHILD_INDEX  (-1)


@interface XTBaseTextHandler : NSObject

@property (readonly) NSUInteger bannerIndex;

@property NSScrollView *scrollView; // Needs to be a _strong_ ref, because of our banner relayout code
@property (unsafe_unretained) XTTextView *textView;

@property (weak) XTGameWindowController *gameWindowController;
@property XTOutputTextParserPlain *outputTextParserPlain;
@property XTOutputTextParserHtml *outputTextParserHtml;
@property XTOutputFormatter *outputFormatter;
@property XTColorationHelper *colorationHelper;
@property XTTextStorageBatcher *textStorageBatcher;

@property (nonatomic) BOOL htmlMode;


- (void)setAbortProcessingTags;

- (void)receiveFormattedElements:(NSArray *)formattedElements;

- (void)traceWithIndentLevel:(NSUInteger)indentLevel;

- (id<XTOutputTextParserProtocol>)getOutputTextParser;

- (void)setHiliteMode:(BOOL)hiliteMode;

- (void)setColorsFromPrefsColor;

- (void)setColorsFromPrefAllowGameToSetColors;

- (void)setColorsFromBody;

- (void)updateLinksUnderline;

- (void)resetForNextCommand;

- (void)mainThread_pumpOutputText:(NSMutableArray *)retValHolder;

- (void)flushBatchedtext;

- (void)mainThread_removeHandler;

- (void)moveCursorToEndOfOutputPosition;

- (void)mainThread_noteStartOfPagination;

- (void)noteStartOfLayoutOfViews;

- (void)noteEndOfLayoutOfViews;

- (void)scrollToBottom;

- (BOOL)paginationIsActive;

- (BOOL)awaitingMorePromptForPagination;

- (void)callOnMainThread:(SEL)selector;

- (void)callOnMainThread:(SEL)selector withObject:(id)obj;

@end
