//
//  XTAllocDeallocCounter.h
//  XTads
//
//  Created by Rune Berg on 08/07/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface XTAllocDeallocCounter : NSObject

+ (instancetype)instance;

- (void)countAllocOf:(id)object;

- (void)countDeallocOf:(id)object;

+ (void)showStats;

+ (void)showStatsFiltered;

- (NSUInteger)getStatsForClassName:(NSString *)className;

@end


#define USE_ALLOC_AND_DEALLOC_COUNTER 1

#ifdef USE_ALLOC_AND_DEALLOC_COUNTER

#define OVERRIDE_ALLOC_FOR_COUNTER \
+ (instancetype)alloc \
{ \
	[[XTAllocDeallocCounter instance] countAllocOf:self]; \
	return [super alloc]; \
}

#define OVERRIDE_DEALLOC_FOR_COUNTER \
- (void)dealloc \
{ \
	[[XTAllocDeallocCounter instance] countDeallocOf:self]; \
}

#else

#define OVERRIDE_ALLOC_FOR_COUNTER

#define OVERRIDE_DEALLOC_FOR_COUNTER


#endif

