#charset "us-ascii"

/* 
 *  Copyright (c) 2004 - 2005 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 London Cabs Library Extension
 *
 *  londoncabs.h
 *
 *  The London Cabs header file.
 */

#ifndef LONDON_CABS_H
#define LONDON_CABS_H

/*
 *  Macro for defining DestTravelTopics. All that is needed
 *  is the symbol and the vocabulary in single-quotes. For 
 *  instance:
 *
 *      DefineDestTravelTopic(bakerStreet, 'baker', 'street')
 *      ;
 *
 *  defines the DestTravelTopic for the location matching the
 *  vocabulary of 'baker' 'street'.
 */
#define DefineDestTravelTopic(symbol, vocab...) \
DestTravelTopic \
{ \
    dest = symbol \
    keywordList = [vocab#foreach: vocab :,: ]\
}

#endif /* LONDON_CABS_H */