!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.02.26 ORReverseDirection	[Z, GLULX]
! A simple routine, shared by multiple objects to reverse a direction.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	none
!--------------------------------------------------------------------------------------
! This is a short, simple routine, not at all worthy of its own module but used by 
! multiple library entries and so is placed in its own module for the sake of sharing.
!
! ORReverse direction simply takes a direction property as a parameter (such as nw_to) 
! and returns the reverse direction (in this case, se_to). It is used by several 
! ORLibrary modules, such as ORNPCVerb, ORNPC_movement, and ORDynaMap.
!
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORReverseDirection";					!Constant USE_ORReverseDirection; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORReverseDirection; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.17	Initial Creation
! 2002.02.20	Added support for direction objects as well as direction properties
! 2002.02.26	Fit to new template.
!--------------------------------------------------------------------------------------
#ifdef USE_ORReverseDirection;message "          Processing library extension ORReverseDirection...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORReverseDirection_DONEREPLACE; constant ORReverseDirection_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORReverseDirection_DONEMESSAGE; constant ORReverseDirection_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORReverseDirection requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORReverseDirection_DONECODE;constant ORReverseDirection_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	[ReverseDirection d; 
		switch(d){ 
		!--are we reversing a property?
			in_to: d=out_to; 
			out_to: d=in_to; 
			u_to:d=d_to; 
			d_to:d=u_to; 
			n_to: d=s_to; 
			s_to: d=n_to; 
			e_to: d=w_to; 
			w_to: d=e_to; 
			nw_to: d=se_to; 
			se_to: d=nw_to; 
			ne_to: d=sw_to; 
			sw_to: d=ne_to; 
		!--otherwise reversing an object
			in_obj: d=out_obj; 
			out_obj: d=in_obj; 
			u_obj:d=d_obj; 
			d_obj:d=u_obj; 
			n_obj: d=s_obj; 
			s_obj: d=n_obj; 
			e_obj: d=w_obj; 
			w_obj: d=e_obj; 
			nw_obj: d=se_obj; 
			se_obj: d=nw_obj; 
			ne_obj: d=sw_obj; 
			sw_obj: d=ne_obj; 
		}
		return d;
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORReverseDirection_DONEGRAMMAR; constant ORReverseDirection_DONEGRAMMAR; #ifdef ORReverseDirection_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;
