!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.02.25 ORRandom [Z, (only code-compatibility support added for GLULX)]
! This module is designed to compensate for a bug in the WinFrotz interpreter 
! involving random number generation. See the article "Randomizing Random" in the 
! "Informed Tips" section of An Inform Developer's Guide at www.OnyxRing.com
! for a description of this.  
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep (GLULX-only) :	none
! AutoDep (Z-Code-only):	ORRoutinesList
!							ORKeyboardPrimitive
! AutoDep (both) :			ORObjectInitialise
!--------------------------------------------------------------------------------------
! Additionally, this module exposes the routine 
! ORInitRandom() to house code that would normally be placed in Initialise(), but 
! needs to use an adequately seeded random number generator.  ORInitRandom is called 
! immediately following the first user input.
!
! Note, the Winfrotz bug isn't really useful for GLULX, however this module will
! still call ORInitRandom (immediately) in GLULX mode for support of code originally 
! targeted for the traditional Inform compiler.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORRandom";					!Constant USE_ORRandom; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORRandom; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.10	Initial Creation
! 2002.02.25	Modified to fit new framework template
!--------------------------------------------------------------------------------------
#ifdef USE_ORRandom;
#ifndef TARGET_GLULX;
	message "          Processing library extension ORRandom...";
#ifnot;
	message "          Processing library extension ORRandom...GLULX mode.";
#endif;
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 	
	#ifndef TARGET_GLULX;
		#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 	
		#ifndef USE_ORKeyboardPrimitive; Constant USE_ORKeyboardPrimitive; message "          ****Forcing inclusion of ORKeyboardPrimitive****"; #include "ORKeyboardPrimitive"; #endif; 	
	#endif;
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORRandom_DONEREPLACE; constant ORRandom_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------
	#ifndef TARGET_GLULX;
		global __orrand_seed=0;
	#endif;
!--------------------------------------------------------------------------------------
#endif;#endif; #ifdef MESSAGEPOINT; #ifndef ORRandom_DONEMESSAGE; constant ORRandom_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORRandom requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORRandom_DONECODE;constant ORRandom_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	#ifndef TARGET_GLULX;
		[__ORRandom_Filter t;
			ORKBTimer.remove_routine(__ORRandom_Timer); 
			ORKBFilter.remove_routine(__ORRandom_Filter);
			for(t=0:t<__orrand_seed:t++) random(1); !randomize...
			ORInitRandom();
			return false;
		];
		[__ORRandom_Timer;
			__orrand_seed++;
			rfalse;
		];
		object with object_initialise[;
			ORKBTimer.add_routine(__ORRandom_Timer); 
			ORKBFilter.add_routine(__ORRandom_Filter);
		];
	#ifnot;
		object with object_initialise[; ORInitRandom(); ];
	#endif;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORRandom_DONEGRAMMAR; constant ORRandom_DONEGRAMMAR; #ifdef ORRandom_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------
	stub ORInitRandom 0;	!define this routine to perform all randomization that would 
							!normally be done in the init routine.
!--------------------------------------------------------------------------------------
#endif; #endif; #endif;