!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.06.8 ORAdjective
! Implementation of Adjectives.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! Two options are available to govern this module's behavior:
!
! 1) The DM4 Exercise 75 gives an example of a ParseNoun routine which distinguishes 
! between nouns and adjectives. By default, this module implements a modified version of 
! that routine, but leverages the ORParseNoun object so that other ParseNoun-like 
! routines can co-exist without conflict.  Additionally, this version of ParseNoun will 
! also work with the ORRecogName module.
!
! 2) Alternatively, this module can be made to prefer objects when a noun word is 
! specifically used, but still allow reference by adjectives only. This method uses a 
! technique that is very very similar to Miron Schmidt's calyx_adjectives extension and 
! leverages the ORChooseObjects object to allow other ChooseObject routines to co-exist.
!
! This mode can be turned on by setting the mode variable of the ORAdjective object, 
! usually in Initialise():
!
!	ORAdjective.mode=PREFER_NOUN;
!
! This setting differs from the default value of REQUIRE_NOUN.
!
!--------------------------------------------------------------------------------------
! AutoDep:	ORParseNoun
!			ORRoutinesList
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORAdjective; #include "ORAdjective"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORAdjective; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.05.08	Initial Creation
! 2002.07.07	Added menu documention.
! 2002.07.20	Added Auto Dependancy code for objectinitialise.
! 2002.08.31	Modified to reference the new OREntryPoints module.
! 2002.12.22	Modified the parsenoun algorithm to detect plural nouns.
! 2003.02.19	Added better ifdef for self docs.
! 2003.03.02	Fixed spelling issue in self docs.
! 2003.04.14	Added code to allow objects to be referenced by adjectives only, yet
!				still prefer nouns. 
! 2003.06.08	...And modified the above code slightly.
!--------------------------------------------------------------------------------------
#ifdef USE_ORAdjective;message "          Processing library extension ORAdjective...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_ORAdditiveEntryPoints; Constant USE_ORAdditiveEntryPoints; message "          ****Forcing inclusion of ORAdditiveEntryPoints****"; #include "ORAdditiveEntryPoints"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 
	#ifndef USE_OREntryPoints; Constant USE_OREntryPoints; message "          ****Forcing inclusion of OREntryPoints****"; #include "OREntryPoints"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORAdjective_DONEREPLACE; constant ORAdjective_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORAdjective_DONEMESSAGE; constant ORAdjective_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORAdjective requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORAdjective_DONECODE;constant ORAdjective_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	Constant	REQUIRE_NOUN 0;
	Constant	PREFER_NOUN 1;
	attribute	noun_ref;
	object ORAdjective with mode REQUIRE_NOUN, object_initialise[;ORChooseObjects.add_routine(__chooseobjectadjective); ORParseNoun.add_routine(__parsenounadjective);], adjective;
	[__parsenounadjective obj n m f;
		give obj ~noun_ref;
		while(true){
			f=AdjOrNoun(obj);
			if(f==0) break; !--current word does NOT reference the given object
			if(f==1 or 2) { !--current word is a noun, and not an adjective
				m++;			!--increment the noun count
				give obj noun_ref; !--this object was definately reference by a noun word
			}
			if(f==2) parser_action=##PLURALFOUND;
			if(f==3) n++; !--increment the adjective count
		}
		if(m==0 && ValueOrRun(ORAdjective,mode)==REQUIRE_NOUN) return 0; !--in this mode, we don't allow referencing by adjectives alone
		return n+m;
	];
	[__chooseobjectadjective obj c;
		if(c<2) return 0; !--let the parser decide
		if(obj hasnt noun_ref) return 1; !--objects referred to only by adjectives are not rated as hightly as objects for which...
		return 2; !--a noun word was actually used
	];
	!--used to determine if the CurrentWord is an adjective or a noun (singular or plural).  
	!--returns 1:Noun; 2:PluralNoun; 3: Adj; 0:Neither
	[AdjOrNoun obj wrd;
		wrd=NextWord();
		if(obj provides adjective && WordInProperty(wrd,obj,adjective)==true) return 3; !--adjective
		if(WordInProperty(wrd,obj,name)==true) {
			if(wrd~=0 && ((wrd->#dict_par1) & 4)~=0) 
				return 2; !--plural noun
			else
				return 1; !--singular noun
		}
#ifdef USE_ORRecogName; 
		if(MatchAgainstShortName(obj,wn-1)==true) return 1; !--singular noun
#endif;
		return 0; !--None of the above
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORAdjective_DONEGRAMMAR; constant ORAdjective_DONEGRAMMAR; #ifdef ORAdjective_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------
#ifdef ORMenuCatch;
	!--Commands, document thyself.
	ORMenu ORHelpAdjectives "Adjectives" with text "It should be noted that this game differentiates between nouns and adjectives. That is, it is likely that the brown dog can be referred to as a ~dog,~ or a ~brown dog,~ but not simply a ~brown.~"
		,	object_initialise[;	if(ORMenuCatch~=0) move self to ORMenuCatch; ]
	;
#endif;


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;