#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <errno.h>

/* define USE_ARTS 1 to use aRts sound server instead of esd */
#define USE_ARTS 0


static unsigned char* mem = NULL;
static long length = 0;
static int repeat = 1;
static int volume = 65536;

#define BUFSZ 2048
static unsigned char buffer[BUFSZ];

static pid_t sox_pipe(FILE** fi, FILE** fo ) {
  int pid, stat, i, pi[2], po[2];
  FILE *fchild;

  if (pipe(pi)) {
    fprintf(stderr,"pipe\n");
    exit(-1);
  }
  fcntl(pi[0], F_SETFD, FD_CLOEXEC);
  fcntl(pi[1], F_SETFD, FD_CLOEXEC);

  /*printf("PIPE %d %d\n",pi[0],pi[1]);*/

  if (pipe(po)) {
    fprintf(stderr,"pipe\n");
    exit(-1);
  }
  fcntl(po[0], F_SETFD, FD_CLOEXEC);
  fcntl(po[1], F_SETFD, FD_CLOEXEC);

  /*printf("PIPE %d %d\n",po[0],po[1]);*/

  pid = fork();
  if (pid>0) {
    /* parent */
    /*printf("PID %d\n", pid);*/

    *fi = fdopen(pi[1],"w");
    if (!*fi) {
      fprintf( stderr, "fdopen sox input\n");
      exit(-1);
    }
    *fo = fdopen(po[0],"r");
    if (!*fo) {
      fprintf( stderr, "fdopen sox output\n");
      exit(-1);
    }

    close(pi[0]);
    close(po[1]);
  }
  else if (pid==0) {
    /* child */
    if (dup2(pi[0],0) == -1) {
      fprintf(stderr,"child dup2\n");
      exit(-1);
    }
    if (dup2(po[1],1) == -1) {
      fprintf(stderr,"child dup2\n");
      exit(-1);
    }

    execlp( "sox", "sox", "-t", "aiff", "-", "-t", "raw", "-r", "22050",
	    "-sw", "-c", "2", "-", NULL );

    /* exec failed! */
    fprintf(stderr,"execlp failed\n");
    exit(-1);
  }
  else {
    fprintf(stderr,"fork failed\n");
    exit(-1);
  }
  return pid;
}


static FILE* esd_pipe() {
  int pid, stat, i, pi[2];
  FILE *fchild;

  if (pipe(pi)) {
    fprintf(stderr,"pipe\n");
    exit(-1);
  }
  fcntl(pi[0], F_SETFD, FD_CLOEXEC);
  fcntl(pi[1], F_SETFD, FD_CLOEXEC);

  /*printf("PIPE %d %d\n",pi[0],pi[1]);*/

  pid = fork();
  if (pid>0) {
    FILE* fi;
    /* parent */
    /*printf("PID %d\n", pid);*/

    fi = fdopen(pi[1],"w");
    if (!fi) {
      fprintf(stderr,"fdopen on pipe failed\n");
      exit(-1);
    }
    close(pi[0]);
    return fi;
  }
  else if (pid==0) {
    /* child */
    close(0);
    if (dup(pi[0]) == -1) {
      fprintf(stderr,"child dup\n");
      exit(-1);
    }
#if USE_ARTS
    execlp( "artscat", "artscat", "-r", "22050", NULL );
#else
    execlp( "esdcat", "esdcat", "-r", "22050", NULL );
#endif

    /* exec failed! */
    fprintf(stderr,"execlp failed\n");
    exit(-1);
  }
  else {
    fprintf(stderr,"fork failed\n");
    exit(-1);
  }
}


/*** comaand processing ***/

/* command buffer */

#define CMDSZ 256
static char cmdbuf[CMDSZ];
static int cmdpos = 0;

/*
 * process commands piped from Glk
 */
static void handle_command() {
  int num;
  for(;;) {
    int c = fgetc(stdin);
    if (c<0) {
      if (feof(stdin)) exit(0);
      if (length) return;
      continue;
    }
    if ((c!='\n') && (c!='\0')) {
      cmdbuf[cmdpos++] = c;
      if (cmdpos>=CMDSZ) cmdpos = 0;
      continue;
    }
    cmdbuf[cmdpos] = '\0';
    cmdpos = 0;

    /*fprintf(stderr,"%s\n",cmdbuf);*/

    if (!strncmp(cmdbuf,"READ ",5) && (sscanf(cmdbuf+5,"%d",&num)==1)) {
      if (num>0) {
	length = num;
	return;
      }
    }
    else if (!strncmp(cmdbuf,"VOL ",4) && (sscanf(cmdbuf+4,"%d",&num)==1)) {
      if ((num>=0) && (num<=0x10000)) volume = num;
    }
    else if (!strncmp(cmdbuf,"REP ",4) && (sscanf(cmdbuf+4,"%d",&num)==1)) {
      repeat = num;
    }
  }
}

static void sendbuf(FILE* fout, int len) {
  int i = 0;
  for( i = 0; i<len; i+=2) {
    char x = buffer[i+1];
    int y = x*256+buffer[i];
    y = y*volume/65536;
    buffer[i+1] = y/256;
    buffer[i] = y%256;
  }
  i = fwrite(buffer,len,1,fout);
  fflush(fout);
}

static int bx = 0;
static pid_t soxpid;
static int pos = 0;
static FILE* soxin;
static FILE* soxout;
static FILE* esd;


int main(int argc, char* argv[] ) {

  handle_command();

  /*** load in sound file from stdin ***/
  mem = (unsigned char*)malloc(length);
  if (!mem) {
    fprintf(stderr,"malloc failed\n");
    exit(-1);
  }
  if (!fread(mem,length,1,stdin)) {
    fprintf(stderr,"fread failed\n");
    exit(-1);
  }


  /* Make stdin non-blocking; will be polled for volume and repetition
     commands */
  if (fcntl(fileno(stdin), F_SETFL, O_NONBLOCK)) {
    fprintf(stderr, "fcntl error\n");
    exit(-1);
  }

  soxpid = sox_pipe(&soxin, &soxout);
  esd = esd_pipe();
  while(repeat) {
    fd_set fd_in, fd_out;
    fd_set *rfd = NULL;
    int retval, n;
    int sin, sout;

    /* Watch soxout to see when it has input. */
    sout = fileno(soxout);
    FD_ZERO(&fd_in);
    FD_SET(sout, &fd_in);
    n = sout+1;

    FD_ZERO(&fd_out);
    if (pos<length) {
      sin = fileno(soxin);
      /* Watch soxin to see when it can accept data. */
      FD_SET(sin, &fd_out);
      if (sin>sout) n = sin+1;
      rfd = &fd_out;
    }

    retval = select(n, &fd_in, rfd, NULL, NULL);

    if (retval) {
      if (rfd && FD_ISSET( sin, &fd_out)) {
	int i = 1024, j;
	if (pos+i > length)
	  i = length-pos;
	j = fwrite(mem+pos,i,1,soxin);
	fflush(soxin);

	pos += i;
	if (pos>=length) {
	  /* end of input for sox */
	  fclose(soxin);
	}
      }
      else if (FD_ISSET( sout, &fd_in)) {
	int i;
	i = fread(buffer+bx,1,BUFSZ,soxout);
	bx += i;
	if (bx>=BUFSZ) {
	  handle_command();
	  sendbuf(esd,BUFSZ);
	  bx = 0;
	}
	if (feof(soxout) || (i<0)) {
	  pid_t j;
	  /* end of sox output */
	  sendbuf(esd,bx);
	  bx = 0;
	  fclose(soxout);
	  j = waitpid(soxpid, &i, 0);
	  if (j!=soxpid) {
	    fprintf(stderr,"waitpid error\n");
	    exit(-1);
	  }
	
	  if (repeat>0) repeat--;
	  if (repeat) {
	    soxpid = sox_pipe(&soxin, &soxout);
	    pos = 0;
	  }
	}
      }/*if*/
    }/* if (retval)*/
  }
  fclose(esd);
  printf("FIN\n");
  exit(0);
}

  

