/*
  Infocom
  Main for infocom interpreter
  JBS 15 June 1994
*/

#include "config.h"
#include "console.h"
#include "file.h"
#include "head.h"
#include "init.h"
#include "interp.h"
#include "os.h"
#include "wio.h"








#include <stdio.h>

int main(int argc, char **argv)
{
  char *fname;

  allocate_console();
  pre_init_io(&argc, argv);
  if(argc == 2)
  {
    fname = argv[1];
    if(hd_open(fname))
    {
      init();
      init_io();
      init_script();
      init_interpreter(1);
      execute_opcode();
      exit_io();
      close_script();
      hd_close();
    }
  }
  else
  {
    fprintf(stderr, "Usage: %s gamefile [xoptions]\n", argv[0]);
  }
  return 0;
}



