/* A client to make gdb-4.4 to return to command level on Mach 3.0

   Copyright (C) 1992 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * Author: Jukka Virtanen <jtv@hut.fi>
 *
 * A simple client to make gdb-4.4 on mach 3.0 to return
 * to command level when it is waiting for the inferior
 * to stop.
 *
 * On Mach 3.0 ^C does not work.
 *
 * Actions: Lookup the send right to gdb message port
 *          from the netnameserver.
 *
 *	    Send a asynchronous message with msgh_id
 *	    GDB_MESSAGE_ID_STOP to that port.
 */

#include <stdio.h>

#include "defs.h"

#include <mach.h>
#include <mach/message.h>
#include <mach_error.h>

#include <servers/netname.h>

/* Magically known netnameserver port (in -lmach) */
extern mach_port_t name_server_port;

/* Keep the send right to the gdb message port here */
mach_port_t gdb_port;

typedef struct {
  mach_msg_header_t Head;
} Request;

void
main (int argc, char **argv)
{
  kern_return_t ret;
  char *hostname = "";
  Request Mess;
  Request *InP = &Mess;

  if (argc != 2)
    {
      fprintf (stderr, "Usage : %s stop-gdb netname\n", argv[0]);
      exit (1);
    }

  ret = netname_look_up (name_server_port,
			 hostname,
			 argv[1],
			 &gdb_port);
  if (ret != KERN_SUCCESS)
    {
      fprintf (stderr, "Failed to lookup the gdb netname port:%s\n",
	       mach_error_string(ret));
      exit(1);
    }
  
  /* Code generated by mig stub generator, with minor cleanups :-)
   *
   * simpleroutine stop_inferior(gdb_port : mach_port_t);
   */

  InP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, 0);

  /* msgh_size passed as argument */
  InP->Head.msgh_remote_port = gdb_port;
  InP->Head.msgh_local_port  = MACH_PORT_NULL;
  InP->Head.msgh_seqno       = 0;
  InP->Head.msgh_id          = GDB_MESSAGE_ID_STOP;

  ret = mach_msg (&InP->Head,
		  MACH_SEND_MSG|MACH_MSG_OPTION_NONE,
		  sizeof(Request),
		  0,
		  MACH_PORT_NULL,
		  MACH_MSG_TIMEOUT_NONE,
		  MACH_PORT_NULL);

  if (ret != KERN_SUCCESS)
    fprintf (stderr, "Message not sent, return code %d : %s\n",
	     ret,
	     mach_error_string (ret));
}
