/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.EventSetDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.BeanEvent;
import tcl.lang.Interp;
import tcl.lang.ReflectException;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class EventAdaptor {
    private boolean initialized = false;
    Interp interp;
    Object source;
    Hashtable callbacks;
    Throwable exception;
    EventSetDescriptor eventDesc;

    void init(Interp interp, Object object, EventSetDescriptor eventSetDescriptor) throws TclException {
        this.interp = interp;
        this.callbacks = new Hashtable();
        this.eventDesc = eventSetDescriptor;
        this.source = object;
        Method method = this.eventDesc.getAddListenerMethod();
        if (method != null) {
            Object[] objectArray = new Object[]{this};
            try {
                method.invoke(this.source, objectArray);
            }
            catch (Exception exception) {
                throw new ReflectException(interp, (Throwable)exception);
            }
        }
        this.initialized = true;
    }

    void setCallback(String string, TclObject tclObject) {
        if (!this.initialized) {
            throw new TclRuntimeError("EventAdaptor not initialized");
        }
        TclObject tclObject2 = (TclObject)this.callbacks.get(string);
        if (tclObject2 != null) {
            tclObject2.release();
            this.callbacks.remove(string);
        }
        this.callbacks.put(string, tclObject);
        if (tclObject.internalRep == null) {
            throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
        }
        ++tclObject.refCount;
    }

    int deleteCallback(String string) throws TclException {
        int n;
        if (!this.initialized) {
            throw new TclRuntimeError("EventAdaptor not initialized");
        }
        TclObject tclObject = (TclObject)this.callbacks.get(string);
        if (tclObject != null) {
            tclObject.release();
            this.callbacks.remove(string);
        }
        if ((n = this.callbacks.size()) == 0) {
            try {
                try {
                    Method method = this.eventDesc.getRemoveListenerMethod();
                    if (method != null) {
                        Object[] objectArray = new Object[]{this};
                        method.invoke(this.source, objectArray);
                    }
                }
                catch (Exception exception) {
                    throw new ReflectException(this.interp, (Throwable)exception);
                }
                Object var5_7 = null;
                this.initialized = false;
                this.callbacks = null;
                this.eventDesc = null;
                this.interp = null;
                this.source = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.initialized = false;
                this.callbacks = null;
                this.eventDesc = null;
                this.interp = null;
                this.source = null;
                throw throwable;
            }
        }
        return n;
    }

    TclObject getCallback(String string) {
        if (!this.initialized) {
            throw new TclRuntimeError("EventAdaptor not initialized");
        }
        return (TclObject)this.callbacks.get(string);
    }

    void getHandledEvents(TclObject tclObject) {
        if (!this.initialized) {
            throw new TclRuntimeError("EventAdaptor not initialized");
        }
        try {
            String string = this.eventDesc.getListenerType().getName();
            Enumeration enumeration = this.callbacks.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                TclList.append(null, tclObject, TclString.newInstance(String.valueOf(string) + "." + string2));
            }
            return;
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    public final void _processEvent(Object[] objectArray, String string) throws Throwable {
        if (!this.initialized) {
            throw new TclRuntimeError("EventAdaptor not initialized");
        }
        this.exception = null;
        TclObject tclObject = (TclObject)this.callbacks.get(string);
        if (tclObject != null) {
            Class<?>[] classArray = null;
            Method[] methodArray = this.eventDesc.getListenerType().getMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(string)) {
                    classArray = methodArray[n].getParameterTypes();
                    break;
                }
                ++n;
            }
            BeanEvent beanEvent = new BeanEvent(this.interp, classArray, objectArray, tclObject);
            this.interp.getNotifier().queueEvent(beanEvent, 0);
            beanEvent.sync();
            this.exception = beanEvent.exception;
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    private final void check() {
        if (!this.initialized) {
            throw new TclRuntimeError("EventAdaptor not initialized");
        }
    }

    public final void _wrongException() throws Error, RuntimeException {
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        if (!(this.exception instanceof TclException)) {
            Interp interp = this.interp;
            String string = "unexpected exception: " + this.exception;
            if (string == null) {
                interp.resetResult();
            } else {
                interp.setResult(TclString.newInstance(string));
            }
        }
        this.interp.addErrorInfo("\n    (command bound to event)");
        this.interp.backgroundError();
    }

    public final boolean _return_boolean() {
        if (this.exception != null) {
            return false;
        }
        TclObject tclObject = this.interp.getResult();
        try {
            return TclBoolean.get(this.interp, tclObject);
        }
        catch (TclException tclException) {
            this.interp.addErrorInfo("\n    (attempting to return boolean from binding)");
            this.interp.backgroundError();
            return false;
        }
    }

    public final byte _return_byte() {
        return (byte)this._return_int();
    }

    public final char _return_char() {
        if (this.exception != null) {
            return '\u0000';
        }
        Object object = this.interp.getResult();
        if (((TclObject)object).stringRep == null) {
            ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
        }
        if (((String)(object = ((TclObject)object).stringRep)).length() == 1) {
            return ((String)object).charAt(0);
        }
        Interp interp = this.interp;
        String string = "expecting character but got \"" + (String)object + "\"";
        if (string == null) {
            interp.resetResult();
        } else {
            interp.setResult(TclString.newInstance(string));
        }
        this.interp.addErrorInfo("\n    (attempting to return character from binding)");
        this.interp.backgroundError();
        return '\u0000';
    }

    public final double _return_double() {
        if (this.exception != null) {
            return 0.0;
        }
        TclObject tclObject = this.interp.getResult();
        try {
            return TclDouble.get(this.interp, tclObject);
        }
        catch (TclException tclException) {
            this.interp.addErrorInfo("\n    (attempting to return floating-point number from binding)");
            this.interp.backgroundError();
            return 0.0;
        }
    }

    public final float _return_float() {
        return (float)this._return_double();
    }

    public final int _return_int() {
        if (this.exception != null) {
            return 0;
        }
        TclObject tclObject = this.interp.getResult();
        try {
            return TclInteger.get(this.interp, tclObject);
        }
        catch (TclException tclException) {
            this.interp.addErrorInfo("\n    (attempting to return integer number from binding)");
            this.interp.backgroundError();
            return 0;
        }
    }

    public final long _return_long() {
        return this._return_int();
    }

    public final short _return_short() {
        return (short)this._return_int();
    }

    public final Object _return_Object(String string) {
        if (this.exception != null) {
            return null;
        }
        if (string.equals("java.lang.String")) {
            TclObject tclObject = this.interp.getResult();
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            return tclObject.stringRep;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TclRuntimeError("unexpected exception " + classNotFoundException);
        }
        try {
            TclObject tclObject = this.interp.getResult();
            Object object = ReflectObject.get(this.interp, tclObject);
            if (!clazz.isInstance(object)) {
                StringBuffer stringBuffer = new StringBuffer("cannot cast object ");
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                throw new TclException(this.interp, stringBuffer.append(tclObject.stringRep).append(" (").append(object.toString()).append(") to required type ").append(string).toString());
            }
            return object;
        }
        catch (TclException tclException) {
            this.interp.addErrorInfo("\n    (attempting to return object from binding)");
            this.interp.backgroundError();
            return null;
        }
    }
}

