/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Notifier;

public abstract class TimerHandler {
    Notifier notifier;
    long atTime;
    boolean isCancelled;
    int generation;

    public synchronized void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        Notifier notifier = this.notifier;
        synchronized (notifier) {
            int i = 0;
            while (i < this.notifier.timerList.size()) {
                if (this.notifier.timerList.elementAt(i) == this) {
                    this.notifier.timerList.removeElementAt(i);
                    Object var2_3 = null;
                    return;
                }
                ++i;
            }
        }
    }

    final synchronized int invoke() {
        if (!this.isCancelled) {
            this.processTimerEvent();
            return 1;
        }
        return 0;
    }

    public abstract void processTimerEvent();

    public TimerHandler(Notifier n, int milliseconds) {
        this.atTime = System.currentTimeMillis() + (long)milliseconds;
        this.notifier = n;
        this.isCancelled = false;
        Notifier notifier = this.notifier;
        synchronized (notifier) {
            this.generation = this.notifier.timerGeneration;
            int i = 0;
            while (i < this.notifier.timerList.size()) {
                TimerHandler q = (TimerHandler)this.notifier.timerList.elementAt(i);
                if (this.atTime < q.atTime) break;
                ++i;
            }
            this.notifier.timerList.insertElementAt(this, i);
            if (Thread.currentThread() != this.notifier.primaryThread) {
                this.notifier.notifyAll();
            }
        }
    }
}

