use inc::Module::Install;
name 'AnyEvent-MPRPC';
all_from 'lib/AnyEvent/MPRPC.pm';

requires 'AnyEvent'          => 5.261;
requires 'Data::MessagePack' => 0.34;
requires 'Any::Moose'        => 0.13;

tests 't/*.t';
test_requires 'Test::More'       => 0.94;
test_requires 'Test::TCP'        => 0.11;
author_tests 'xt';

test_with_env( test_pp => PERL_DATA_MESSAGEPACK => 'pp' );

if($Module::Install::AUTHOR) {
    postamble qq{test :: test_pp\n\n};
}

test_requires 'Test::TCP' => 0.11;
test_requires 'Test::More' => 0.98;
WriteAll;

# copied from Makefile.PL in Text::Xslate.
sub test_with_env {
    my($name, %env) = @_;

    my $dir = '.testenv';
    if(not -e $dir) {
        mkdir $dir or die "Cannot mkdir '.testenv': $!";
    }
    clean_files($dir);

    {
        open my $out, '>', "$dir/$name.pl"
            or die "Cannot open '$dir/$name.pl' for writing: $!";
       print $out "# This file sets the env for 'make $name', \n";
       print $out "# generated by $0 at ", scalar(localtime), ".\n";
       print $out "# DO NOT EDIT THIS FILE DIRECTLY.\n";
       print $out "\n";

        while(my($name, $value) = each %env) {
            printf $out '$ENV{q{%s}} = q{%s};'."\n", $name, $value;
        }
    }

    # repeat testing for pure Perl mode
    # see also ExtUtils::MM_Any::test_via_harness()

    my $t =  q{$(FULLPERLRUN) -MExtUtils::Command::MM -e}
            .q{ "do q[%s]; test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')"}
            .q{ $(TEST_FILES)};

    postamble qq{$name :: pure_all\n}
            . qq{\t} . q{$(NOECHO) $(ECHO) TESTING: } . $name . qq{\n}
            . qq{\t} . sprintf($t, "$dir/$name.pl") . qq{\n\n}

            . qq{testall :: $name\n\n};
    return;
}
