use strict;
use warnings;

use Module::Build;

eval { require Alien::IUP };
if ($@) {
  warn "You need to have Alien::IUP installed\n";
  exit 0;
}

my $lflags = Alien::IUP->config('LIBS');
my $cflags = Alien::IUP->config('INC');

unless (Alien::IUP->havelib( qw/iup im cd/ )) {
  warn "Some of the essential libraries - iup, im, cd - is missing!\nGonna quit!\n";
  exit 0;
}

$cflags .= ' -DHAVELIB_IUPCD'       if Alien::IUP->havelib('iupcd');
$cflags .= ' -DHAVELIB_IUPIM'       if Alien::IUP->havelib('iupim');
$cflags .= ' -DHAVELIB_IUPGL'       if Alien::IUP->havelib('iupgl');
$cflags .= ' -DHAVELIB_IUPOLE'      if Alien::IUP->havelib('iupole');
$cflags .= ' -DHAVELIB_IUPCONTROLS' if Alien::IUP->havelib('iupcontrols');
$cflags .= ' -DHAVELIB_IUP_PPLOT'   if Alien::IUP->havelib('iup_pplot');
$cflags .= ' -DHAVELIB_IUPIMGLIB'   if Alien::IUP->havelib('iupimglib');

my $class = 'Module::Build';
if (-d '.git') { #adding some custom actions relevant only for module development
  $class = Module::Build->subclass( class => "Module::Build::Custom", code => <<'SUBCLASS', );

  sub ACTION_xt {
    system(qw[prove -bl xt/*.t]);
  }

  sub ACTION_gen {
    system($^X, qw[_generators/generate.pl -dst lib/IUP/Internal]);
  }

  sub ACTION_doc {
    system($^X, qw[_generators/proc-pod.tt2pod.pl -podtt _generators/pod.tt -pod lib]);
    system($^X, qw[_generators/proc-pod2cpan.html.pl -html doc.html.tmp -pod lib]);
  }

SUBCLASS
}

my $builder = $class->new(
  module_name          => 'IUP',
  license              => 'mit',
  dist_abstract        => 'IUP bindings to Perl',
  dist_author          => 'KMX <kmx@cpan.org>',
  dist_version_from    => 'lib/IUP.pm',
  requires             => {
    'Carp'                 => 0,
    'constant'             => 0,
  },
  build_requires       => { # need to have for running: ./Build (install|test)
    'Module::Build'        => 0,
    'Alien::IUP'           => 0.300,
    'Test::More'           => 0,
    'Carp'                 => 0,
    'constant'             => 0,
  },
  configure_requires   => { # need to have for running: perl Buil.PL
    'Module::Build'        => 0,
    'Alien::IUP'           => 0,
  },
  add_to_cleanup       => [ 'IUP-*' ],
  c_source             => 'src', # ppport.h
  extra_linker_flags   => $lflags,
  extra_compiler_flags => $cflags,  
  meta_merge => {
    keywords => [ qw[IUP portable toolkit graphical user interfaces tecgraf cross-platform GUI Windows GTK Motif X11] ],
    resources => {
      bugtracker => 'https://rt.cpan.org/Public/Dist/Display.html?Status=Active&Name=IUP',
      repository => 'https://github.com/kmx/perl-iup',
    }
  },
);

$builder->create_build_script();
