# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..5\n"; };
END {print "not ok 1\n" unless $loaded;}
use Games::Maze;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

my $last_dir = $Games::Maze::North;

my $correct_make = 
q( __    __    __    __    __    __   
/  \__/  \__/  \__/  \__/  \__/  \     
\     \__    __    __    __    __ f \  
/  \__   \__/  \__/  \__/  \__/  \__/  
\  /  \__    __   \     \     \     \  
/  \     \__   \__   \  /  \  /  \  /  
\  /  \  /  \__   \__/  \  /  \  /  \  
/  \  /  \     \__   \__   \  /  \  /  
\  /  \  /  \  /  \__   \__/  \  /f \  
/  \  /  \  /  \     \__   \__   \__/  
\  /  \  /  \  /  \  /  \__   \__/f \  
/  \  /  \  /  \  /  \     \__   \__/  
\  /  \  /  \  /  \  /  \  /  \__ f \  
/  \  /  \  /  \  /  \  /  \     \__/  
\__   \__   \__   \__   \__   \__ f \  
   \__/  \__/  \__/  \__/  \__/  \__/  
                                       

 __    __    __    __    __    __   
/  \__/  \__/  \__/  \__/  \__/  \__   
\      __    __    __    __      /c \  
/  \__/  \__/  \__/  \__/  \__/f \  /  
\  /  \     \     \     \     \__/  \  
/  \     \  /  \  /  \  /  \  /  \  /  
\  /  \__/  \  /  \  /  \  /  \     \  
/  \  /   __/  \  /  \  /  \  /  \__/  
\  /  \  /  \  /  \  /  \  /  \  /c \  
/  \  /  \     \  /  \  /  \  /  \  /  
\  /  \  /  \__/  \  /  \  /  \  /c \  
/  \  /  \  /   __/  \  /  \  /  \__/  
\  /  \  /  \  /  \  /  \  /  \  /b \  
/  \  /  \  /  \     \  /  \  /  \__/  
\__   \__   \__   \__/   __/   __/b \  
   \__/  \__/  \__/  \__/  \__/  \__/  
                                       

 __    __    __    __    __    __   
/  \__/  \__/  \__/  \__/  \__/  \__   
\      __    __    __    __    __   \  
/  \__/  \__/  \__/  \__/  \__/c \  /  
\  /  \     \     \     \     \  /  \  
/  \     \  /  \  /  \  /  \  /  \  /  
\  /  \__/  \  /  \  /  \  /  \  /  \  
/  \  /   __/  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \     \  /  \  /  \  /  \  /  
\  /  \  /  \__/  \  /  \  /  \  /  \  
/  \  /  \  /   __/  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /c \  
/  \  /  \  /  \     \  /  \  /  \__/  
\__   \__   \__   \__/   __/   __/c \  
   \__/  \__/  \__/  \__/  \__/  \  /  
                                       
);

my $correct_solve = 
q( __    __    __    __    __    __   
/ *\__/  \__/  \__/  \__/  \__/  \     
\    *\__    __    __    __    __ f*\  
/ *\__  *\__/  \__/  \__/  \__/  \__/  
\  / *\__  * __   \     \     \     \  
/ *\    *\__  *\__   \  /  \  /  \  /  
\  / *\  / *\__  *\__/  \  /  \  /  \  
/ *\  / *\    *\__  *\__   \  /  \  /  
\  / *\  / *\  / *\__  *\__/  \  /f \  
/ *\  / *\  / *\    *\__  *\__   \__/  
\  / *\  / *\  / *\  / *\__  *\__/f \  
/ *\  / *\  / *\  / *\    *\__  *\__/  
\  / *\  / *\  / *\  / *\  / *\__ f*\  
/ *\  / *\  / *\  / *\  / *\    *\__/  
\__  *\__  *\__  *\__  *\__  *\__ f*\  
   \__/  \__/  \__/  \__/  \__/  \__/  
                                       

 __    __    __    __    __    __   
/ *\__/ *\__/ *\__/ *\__/ *\__/ *\__   
\    * __  * __  * __  * __  *   /c*\  
/ *\__/ *\__/ *\__/ *\__/ *\__/f*\  /  
\  / *\    *\    *\    *\    *\__/ *\  
/ *\    *\  / *\  / *\  / *\  / *\  /  
\  / *\__/ *\  / *\  / *\  / *\    *\  
/ *\  / * __/ *\  / *\  / *\  / *\__/  
\  / *\  / *\  / *\  / *\  / *\  /c \  
/ *\  / *\    *\  / *\  / *\  / *\  /  
\  / *\  / *\__/ *\  / *\  / *\  /c \  
/ *\  / *\  / * __/ *\  / *\  / *\__/  
\  / *\  / *\  / *\  / *\  / *\  /b*\  
/ *\  / *\  / *\    *\  / *\  / *\__/  
\__  *\__  *\__  *\__/ * __/ * __/b*\  
   \__/  \__/  \__/  \__/  \__/  \__/  
                                       

 __    __    __    __    __    __   
/ *\__/ *\__/ *\__/ *\__/ *\__/ *\__   
\    * __  * __  * __  * __  * __  *\  
/ *\__/ *\__/ *\__/ *\__/ *\__/c*\  /  
\  / *\    *\    *\    *\    *\  / *\  
/ *\    *\  / *\  / *\  / *\  / *\  /  
\  / *\__/ *\  / *\  / *\  / *\  / *\  
/ *\  / * __/ *\  / *\  / *\  / *\  /  
\  / *\  / *\  / *\  / *\  / *\  / *\  
/ *\  / *\    *\  / *\  / *\  / *\  /  
\  / *\  / *\__/ *\  / *\  / *\  / *\  
/ *\  / *\  / * __/ *\  / *\  / *\  /  
\  / *\  / *\  / *\  / *\  / *\  /c*\  
/ *\  / *\  / *\    *\  / *\  / *\__/  
\__  *\__  *\__  *\__/ * __/ * __/c*\  
   \__/  \__/  \__/  \__/  \__/  \  /  
                                       
);

my $correct_hex =
q( 0028 000a 0002 000a 0002 000a 0002 000a 0002 000a 0002 000a 0022 0020
 0028 8060 8042 0040 0102 0048 0102 0048 0102 0048 0102 0048 8203 0022
 0028 8021 8060 8042 8142 0048 0042 0060 0022 0060 0022 0060 0022 0020
 0028 8021 8021 8022 8060 8042 8042 0003 0041 0021 0021 0021 0021 0020
 0028 8021 8021 8021 8021 8022 8060 8042 8042 0003 0041 0021 0201 0020
 0028 8021 8021 8021 8021 8021 8021 8022 8060 8042 8042 0003 0200 0020
 0028 8021 8021 8021 8021 8021 8021 8021 8021 8022 8060 8042 8202 0020
 0028 8041 8003 8041 8003 8041 8003 8041 8003 8041 8003 8042 8202 0020
 0028 002a 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028

 0028 000a 0002 000a 0002 000a 0002 000a 0002 000a 0002 000a 0002 0020
 0028 8060 8102 8048 8102 8048 8102 8048 8102 8048 8102 8028 8030 0022
 0028 8021 8060 8060 8022 8060 8022 8060 8022 8060 8022 8201 8021 0020
 0028 8021 8021 8003 8009 8021 8021 8021 8021 8021 8021 8060 8003 0020
 0028 8021 8021 8120 8060 8021 8021 8021 8021 8021 8021 8021 0030 0020
 0028 8021 8021 8021 8021 8003 8009 8021 8021 8021 8021 8021 0011 0020
 0028 8021 8021 8021 8021 8120 8060 8021 8021 8021 8021 8021 8210 0020
 0028 8041 8003 8041 8003 8041 8003 8003 8101 8009 8101 8009 8210 0020
 0028 002a 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028

 0028 000a 0002 000a 0002 000a 0002 000a 0002 000a 0002 000a 0002 0020
 0028 8060 8102 8048 8102 8048 8102 8048 8102 8048 8102 8048 8022 0022
 0028 8021 8060 8060 8022 8060 8022 8060 8022 8060 8022 8030 8021 0020
 0028 8021 8021 8003 8009 8021 8021 8021 8021 8021 8021 8021 8021 0020
 0028 8021 8021 8120 8060 8021 8021 8021 8021 8021 8021 8021 8021 0020
 0028 8021 8021 8021 8021 8003 8009 8021 8021 8021 8021 8021 8021 0020
 0028 8021 8021 8021 8021 8120 8060 8021 8021 8021 8021 8021 8011 0020
 0028 8041 8003 8041 8003 8041 8003 8003 8101 8009 8101 8009 8030 0020
 0028 002a 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028
);

my $minos = Games::Maze->new(
		dimensions => [12, 7, 3], cell => 'hex', upcolumn_even => 0,
		entry => [12,1,1], exit => [12,7,3],
		start => [1,6,1], fn_choosedir => \&no_turning
		);

$minos->make();
my $maze_form = $minos->to_ascii();
print +($maze_form ne $correct_make)? "not ok 2\n": "ok 2\n";

$minos->solve();
$maze_form = $minos->to_ascii();
print +($maze_form ne $correct_solve)? "not ok 3\n": "ok 3\n";

$maze_form = $minos->to_hex_dump();
print +($maze_form ne $correct_hex)? "not ok 4\n": "ok 4\n";

$minos->unsolve();
$maze_form = $minos->to_ascii();
print +($maze_form ne $correct_make)? "not ok 5\n": "ok 5\n";

exit(0);

sub no_turning
{
	foreach $d (@{$_[0]})
	{
		return $last_dir = $d if ($last_dir <= $d);
	}
	return ${$_[0]}[0];
}
