# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IM;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210309172131;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1624[5-8]\\d{5}',
                'geographic' => '1624[5-8]\\d{5}',
                'mobile' => '
          76245[06]\\d{4}|
          7(?:
            4576|
            [59]24\\d|
            624[0-4689]
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          8(?:
            440[49]06|
            72299\\d
          )\\d{3}|
          (?:
            8(?:
              45|
              70
            )|
            90[0167]
          )624\\d{4}
        )|(
          3440[49]06\\d{3}|
          (?:
            3(?:
              08162|
              3\\d{4}|
              45624|
              7(?:
                0624|
                2299
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '808162\\d{4}',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441228", "Carlisle",
"441952", "Telford",
"4416862", "Llanidloes",
"441876", "Lochmaddy",
"4418478", "Thurso",
"441625", "Macclesfield",
"442310", "Portsmouth",
"441623", "Mansfield",
"442311", "Southampton",
"441872", "Truro",
"441988", "Wigtown",
"441492", "Colwyn\ Bay",
"441277", "Brentwood",
"4418510", "Great\ Bernera\/Stornoway",
"441559", "Llandysul",
"4414376", "Haverfordwest",
"441501", "Harthill",
"441359", "Pakenham",
"4414238", "Harrogate",
"441300", "Cerne\ Abbas",
"4418903", "Coldstream",
"441496", "Port\ Ellen",
"441301", "Arrochar",
"441968", "Penicuik",
"441341", "Barmouth",
"441452", "Gloucester",
"441340", "Craigellachie\ \(Aberlour\)",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441880", "Tarbert",
"441540", "Kingussie",
"4418513", "Stornoway",
"441456", "Glenurquhart",
"4414308", "Market\ Weighton",
"441599", "Kyle",
"441239", "Cardigan",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"4418900", "Coldstream\/Ayton",
"441488", "Hungerford",
"441992", "Lea\ Valley",
"441373", "Frome",
"441375", "Grays\ Thurrock",
"441824", "Ruthin",
"441573", "Kelso",
"441631", "Oban",
"441575", "Kirriemuir",
"441630", "Market\ Drayton",
"441702", "Southend\-on\-Sea",
"441271", "Barnstaple",
"4414234", "Boroughbridge",
"441695", "Skelmersdale",
"441854", "Ullapool",
"441270", "Crewe",
"441307", "Forfar",
"4414231", "Harrogate\/Boroughbridge",
"441706", "Rochdale",
"441538", "Ipstones",
"441298", "Buxton",
"441785", "Stafford",
"441974", "Llanon",
"4414306", "Market\ Weighton",
"4418471", "Thurso\/Tongue",
"441262", "Bridlington",
"441422", "Halifax",
"441245", "Chelmsford",
"4418474", "Thurso",
"441243", "Chichester",
"4415075", "Spilsby\ \(Horncastle\)",
"441529", "Sleaford",
"441286", "Caernarfon",
"441205", "Boston",
"4418476", "Tongue",
"442892", "Lisburn",
"441329", "Fareham",
"4419647", "Patrington",
"441282", "Burnley",
"441608", "Chipping\ Norton",
"441637", "Newquay",
"441474", "Gravesend",
"442896", "Belfast",
"4414342", "Bellingham",
"441926", "Warwick",
"441887", "Aberfeldy",
"4414304", "North\ Cave",
"442868", "Kesh",
"441547", "Knighton",
"4419649", "Hornsea",
"441653", "Malton",
"441347", "Easingwold",
"441655", "Maybole",
"441746", "Bridgnorth",
"4414301", "North\ Cave\/Market\ Weighton",
"4414378", "Haverfordwest",
"441922", "Walsall",
"441258", "Blandford",
"441765", "Ripon",
"441763", "Royston",
"4414236", "Harrogate",
"441458", "Glastonbury",
"441945", "Wisbech",
"441962", "Winchester",
"441943", "Guiseley",
"441723", "Scarborough",
"441725", "Rockbourne",
"442828", "Larne",
"4416868", "Newtown",
"4418905", "Ayton",
"4418472", "Thurso",
"441482", "Kingston\-upon\-Hull",
"441809", "Tomdoun",
"4414232", "Harrogate",
"441274", "Bradford",
"441970", "Aberystwyth",
"441971", "Scourie",
"441569", "Stonehaven",
"44281", "Northern\ Ireland",
"4414346", "Hexham",
"441403", "Horsham",
"441369", "Dunoon",
"442877", "Limavady",
"441405", "Goole",
"441143", "Sheffield",
"441443", "Pontypridd",
"441145", "Sheffield",
"441462", "Hitchin",
"441445", "Gairloch",
"4414302", "North\ Cave",
"4414344", "Bellingham",
"441466", "Huntly",
"441226", "Barnsley",
"441878", "Lochboisdale",
"441389", "Dumbarton",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441982", "Builth\ Wells",
"441730", "Petersfield",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441986", "Bungay",
"441827", "Tamworth",
"4418515", "Stornoway",
"441905", "Worcester",
"441903", "Worthing",
"441864", "Abington\ \(Crawford\)",
"441606", "Northwich",
"441857", "Sanday",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441683", "Moffat",
"4417684", "Pooley\ Bridge",
"4415242", "Hornby",
"442898", "Belfast",
"441685", "Merthyr\ Tydfil",
"441304", "Dover",
"44113", "Leeds",
"441793", "Swindon",
"442871", "Londonderry",
"441795", "Sittingbourne",
"442870", "Coleraine",
"441288", "Bude",
"44147986", "Cairngorm",
"441977", "Pontefract",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441256", "Basingstoke",
"441439", "Helmsley",
"441919", "Durham",
"4416864", "Llanidloes",
"442866", "Enniskillen",
"44147983", "Boat\ of\ Garten",
"441928", "Runcorn",
"441252", "Aldershot",
"441779", "Peterhead",
"441833", "Barnard\ Castle",
"4416861", "Newtown\/Llanidloes",
"441748", "Richmond",
"441835", "St\ Boswells",
"442882", "Omagh",
"441737", "Redhill",
"441708", "Romford",
"441296", "Aylesbury",
"441536", "Kettering",
"442886", "Cookstown",
"4416866", "Newtown",
"441634", "Medway",
"44141", "Glasgow",
"44147984", "Carrbridge",
"441332", "Derby",
"441821", "Kinrossie",
"441477", "Holmes\ Chapel",
"441292", "Ayr",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441884", "Tiverton",
"441544", "Kington",
"4415073", "Louth",
"441663", "New\ Mills",
"441344", "Bracknell",
"441665", "Alnwick",
"441642", "Middlesbrough",
"441939", "Wem",
"4414348", "Hexham",
"441428", "Haslemere",
"441268", "Basildon",
"441646", "Milford\ Haven",
"441753", "Slough",
"441916", "Tyneside",
"441436", "Helensburgh",
"441259", "Alloa",
"441200", "Clitheroe",
"4418479", "Tongue",
"441772", "Preston",
"441904", "York",
"441432", "Hereford",
"4414237", "Harrogate",
"441912", "Tyneside",
"441577", "Kinross",
"44131", "Edinburgh",
"441776", "Stranraer",
"44151", "Liverpool",
"441377", "Driffield",
"4419646", "Patrington",
"4418477", "Tongue",
"441651", "Oldmeldrum",
"441650", "Cemmaes\ Road",
"441144", "Sheffield",
"441609", "Northallerton",
"441444", "Haywards\ Heath",
"441328", "Fakenham",
"4413395", "Aboyne",
"4414239", "Boroughbridge",
"441528", "Laggan",
"441760", "Swaffham",
"4415395", "Grange\-over\-Sands",
"441761", "Temple\ Cloud",
"441273", "Brighton",
"441691", "Oswestry",
"441690", "Betws\-y\-Coed",
"441275", "Clevedon",
"4419641", "Hornsea\/Patrington",
"441404", "Honiton",
"441932", "Weybridge",
"4414309", "Market\ Weighton",
"441780", "Stamford",
"4419644", "Patrington",
"441678", "Bala",
"441539", "Kendal",
"441299", "Bewdley",
"441724", "Scunthorpe",
"441944", "West\ Heslerton",
"4414307", "Market\ Weighton",
"441241", "Arbroath",
"442889", "Fivemiletown",
"441362", "Dereham",
"441806", "Shetland",
"441664", "Melton\ Mowbray",
"441343", "Elgin",
"441885", "Pencombe",
"4419753", "Strathdon",
"441562", "Kidderminster",
"441545", "Llanarth",
"441883", "Caterham",
"441543", "Cannock",
"441767", "Sandy",
"441754", "Skegness",
"441366", "Downham\ Market",
"441566", "Launceston",
"441489", "Bishops\ Waltham",
"441207", "Consett",
"441598", "Lynton",
"44118", "Reading",
"4412295", "Barrow\-in\-Furness",
"441398", "Dulverton",
"441371", "Great\ Dunmow",
"441571", "Lochinver",
"441969", "Leyburn",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441635", "Newbury",
"441570", "Lampeter",
"441633", "Newport",
"441358", "Ellon",
"44116", "Leicester",
"441558", "Llandeilo",
"442844", "Downpatrick",
"441834", "Narberth",
"441989", "Ross\-on\-Wye",
"441621", "Maldon",
"441620", "North\ Berwick",
"4414377", "Haverfordwest",
"441382", "Dundee",
"441684", "Malvern",
"4419648", "Hornsea",
"441582", "Luton",
"441865", "Oxford",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441842", "Thetford",
"441697", "Brampton",
"441863", "Ardgay",
"441787", "Sudbury",
"441505", "Johnstone",
"441503", "Looe",
"441386", "Evesham",
"4414379", "Haverfordwest",
"441305", "Dorchester",
"441586", "Campbeltown",
"441303", "Folkestone",
"441794", "Romsey",
"441469", "Killingholme",
"441429", "Hartlepool",
"441269", "Ammanford",
"441676", "Meriden",
"4413393", "Aboyne",
"441938", "Welshpool",
"4416869", "Newtown",
"441672", "Marlborough",
"441823", "Taunton",
"4417687", "Keswick",
"441825", "Uckfield",
"44147982", "Nethy\ Bridge",
"441661", "Prudhoe",
"441709", "Rotherham",
"4416867", "Llanidloes",
"441751", "Pickering",
"441750", "Selkirk",
"441749", "Shepton\ Mallet",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441778", "Bourne",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441929", "Wareham",
"441918", "Tyneside",
"441790", "Spilsby",
"441438", "Stevenage",
"441407", "Holyhead",
"442841", "Rostrevor",
"441326", "Falmouth",
"442840", "Banbridge",
"441727", "St\ Albans",
"441947", "Whitby",
"441289", "Berwick\-upon\-Tweed",
"441526", "Martin",
"4413390", "Aboyne\/Ballater",
"441624", "Isle\ of\ Man",
"441322", "Dartford",
"441830", "Kirkwhelpington",
"44247", "Coventry",
"441522", "Lincoln",
"4412293", "Millom",
"441140", "Sheffield",
"441440", "Haverhill",
"441352", "Mold",
"441141", "Sheffield",
"441667", "Nairn",
"441895", "Uxbridge",
"441654", "Machynlleth",
"441499", "Inveraray",
"441764", "Crieff",
"441757", "Selby",
"4416973", "Wigton",
"441356", "Brechin",
"44147981", "Aviemore",
"441556", "Castle\ Douglas",
"441204", "Bolton",
"441212", "Birmingham",
"441879", "Scarinish",
"441388", "Bishop\ Auckland",
"441733", "Peterborough",
"441848", "Thornhill",
"4419755", "Alford\ \(Aberdeen\)",
"441588", "Bishops\ Castle",
"4419467", "Gosforth",
"441216", "Birmingham",
"441475", "Greenock",
"442838", "Portadown",
"441473", "Ipswich",
"441959", "Westerham",
"441900", "Workington",
"441368", "Dunbar",
"44115", "Nottingham",
"441721", "Peebles",
"441720", "Isles\ of\ Scilly",
"441568", "Leominster",
"441808", "Tomatin",
"441837", "Okehampton",
"441244", "Chester",
"4414347", "Hexham",
"4412290", "Barrow\-in\-Furness\/Millom",
"441687", "Mallaig",
"441592", "Kirkcaldy",
"442829", "Kilrea",
"441855", "Ballachulish",
"441694", "Church\ Stretton",
"441392", "Exeter",
"441784", "Staines",
"4419642", "Hornsea",
"441236", "Coatbridge",
"4414349", "Bellingham",
"441400", "Honington",
"4413885", "Stanhope\ \(Eastgate\)",
"4412180", "Birmingham",
"441797", "Rye",
"441920", "Ware",
"4419645", "Hornsea",
"441689", "Orpington",
"442827", "Ballymoney",
"4415077", "Louth",
"4413882", "Stanhope\ \(Eastgate\)",
"441740", "Sedgefield",
"4413396", "Ballater",
"441799", "Saffron\ Walden",
"441464", "Insch",
"4415396", "Sedbergh",
"44238", "Southampton",
"441457", "Glossop",
"441224", "Aberdeen",
"441913", "Durham",
"441435", "Heathfield",
"441280", "Buckingham",
"441433", "Hathersage",
"441915", "Sunderland",
"4415079", "Alford\ \(Lincs\)",
"441997", "Strathpeffer",
"441984", "Watchet\ \(Williton\)",
"441773", "Ripley",
"442891", "Bangor\ \(Co\.\ Down\)",
"442890", "Belfast",
"441775", "Spalding",
"4412298", "Barrow\-in\-Furness",
"441260", "Congleton",
"441261", "Banff",
"441877", "Callander",
"441420", "Alton",
"441957", "Mid\ Yell",
"4419752", "Alford\ \(Aberdeen\)",
"441933", "Wellingborough",
"4415394", "Hawkshead",
"441276", "Camberley",
"441935", "Yeovil",
"441669", "Rothbury",
"441828", "Coupar\ Angus",
"4413394", "Ballater",
"441759", "Pocklington",
"441497", "Hay\-on\-Wye",
"441700", "Rothesay",
"4413391", "Aboyne\/Ballater",
"441484", "Huddersfield",
"441978", "Wrexham",
"4412296", "Barrow\-in\-Furness",
"441729", "Settle",
"441534", "Jersey",
"441294", "Ardrossan",
"441287", "Guisborough",
"441949", "Whatton",
"441334", "St\ Andrews",
"442897", "Saintfield",
"441858", "Market\ Harborough",
"441636", "Newark\-on\-Trent",
"441805", "Torrington",
"441747", "Shaftesbury",
"441803", "Torquay",
"442821", "Martinstown",
"442820", "Ballycastle",
"441346", "Fraserburgh",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441546", "Lochgilphead",
"44241", "Coventry",
"441451", "Stow\-on\-the\-Wold",
"441450", "Hawick",
"441342", "East\ Grinstead",
"441363", "Crediton",
"441409", "Holsworthy",
"441644", "New\ Galloway",
"441882", "Kinloch\ Rannoch",
"441565", "Knutsford",
"441542", "Keith",
"441563", "Kilmarnock",
"441502", "Lowestoft",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441302", "Doncaster",
"441866", "Kilchrenan",
"441604", "Northampton",
"441449", "Stowmarket",
"4420", "London",
"4413398", "Aboyne",
"441506", "Bathgate",
"441383", "Dunfermline",
"441707", "Welwyn\ Garden\ City",
"441862", "Tain",
"441738", "Perth",
"441845", "Thirsk",
"441491", "Henley\-on\-Thames",
"441583", "Carradale",
"441306", "Dorking",
"441490", "Corwen",
"441843", "Thanet",
"4412291", "Barrow\-in\-Furness\/Millom",
"441267", "Carmarthen",
"441871", "Castlebay",
"44291", "Cardiff",
"441870", "Isle\ of\ Benbecula",
"441254", "Blackburn",
"441427", "Gainsborough",
"4416974", "Raughton\ Head",
"441909", "Worksop",
"441950", "Sandwick",
"441951", "Colonsay",
"4412294", "Barrow\-in\-Furness",
"44239", "Portsmouth",
"441789", "Stratford\-upon\-Avon",
"441641", "Strathy",
"441467", "Inverurie",
"441454", "Chipping\ Sodbury",
"441227", "Canterbury",
"441330", "Banchory",
"4419643", "Patrington",
"441531", "Ledbury",
"441291", "Chepstow",
"441290", "Cumnock",
"441530", "Coalville",
"441675", "Coleshill",
"441822", "Tavistock",
"441673", "Market\ Rasen",
"441278", "Bridgwater",
"442880", "Carrickmore",
"442881", "Newtownstewart",
"441994", "St\ Clears",
"441249", "Chippenham",
"441987", "Ebbsfleet",
"441323", "Eastbourne",
"441209", "Redruth",
"441250", "Blairgowrie",
"4419640", "Hornsea\/Patrington",
"441874", "Brecon",
"441325", "Darlington",
"4419758", "Strathdon",
"441525", "Leighton\ Buzzard",
"4412292", "Barrow\-in\-Furness",
"441954", "Madingley",
"441967", "Strontian",
"441600", "Monmouth",
"441659", "Sanquhar",
"441769", "South\ Molton",
"441494", "High\ Wycombe",
"441487", "Warboys",
"441472", "Grimsby",
"441297", "Axminster",
"441508", "Brooke",
"441284", "Bury\ St\ Edmunds",
"441736", "Penzance",
"4419756", "Strathdon",
"441337", "Ladybank",
"441308", "Bridport",
"441629", "Matlock",
"441213", "Birmingham",
"442894", "Antrim",
"4418519", "Great\ Bernera",
"441215", "Birmingham",
"441981", "Wormbridge",
"441476", "Grantham",
"441980", "Amesbury",
"442887", "Dungannon",
"441732", "Sevenoaks",
"441896", "Galashiels",
"441744", "St\ Helens",
"441924", "Wakefield",
"441460", "Chard",
"441355", "East\ Kilbride",
"441461", "Gretna",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441892", "Tunbridge\ Wells",
"441353", "Ely",
"441647", "Moretonhampstead",
"4418517", "Stornoway",
"441555", "Lanark",
"441553", "Kings\ Lynn",
"441972", "Glenborrodale",
"4413392", "Aboyne",
"441638", "Newmarket",
"441856", "Orkney",
"441480", "Huntingdon",
"441233", "Ashford\ \(Kent\)",
"441593", "Lybster",
"441481", "Guernsey",
"4418907", "Ayton",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441235", "Abingdon",
"441704", "Southport",
"441852", "Kilmelford",
"441395", "Budleigh\ Salterton",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441264", "Andover",
"441257", "Coppull",
"441424", "Hastings",
"4419754", "Alford\ \(Aberdeen\)",
"441348", "Fishguard",
"441579", "Liskeard",
"441548", "Kingsbridge",
"442867", "Lisnaskea",
"441379", "Diss",
"4418909", "Ayton",
"441888", "Turriff",
"44117", "Bristol",
"442830", "Newry",
"44292", "Cardiff",
"441937", "Wetherby",
"441908", "Milton\ Keynes",
"441899", "Biggar",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441380", "Devizes",
"441381", "Fortrose",
"441495", "Pontypool",
"441841", "Newquay\ \(Padstow\)",
"441580", "Cranbrook",
"441840", "Camelford",
"441493", "Great\ Yarmouth",
"441581", "New\ Luce",
"4415078", "Alford\ \(Lincs\)",
"441524", "Lancaster",
"441873", "Abergavenny",
"441622", "Maidstone",
"441324", "Falkirk",
"441875", "Tranent",
"441955", "Wick",
"441953", "Wymondham",
"4414343", "Haltwhistle",
"441479", "Grantown\-on\-Spey",
"441626", "Newton\ Abbot",
"441674", "Montrose",
"4412299", "Millom",
"441372", "Esher",
"441408", "Golspie",
"441917", "Sunderland",
"441572", "Oakham",
"441376", "Braintree",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441777", "Retford",
"441993", "Witney",
"441576", "Lockerbie",
"441995", "Garstang",
"441859", "Harris",
"442825", "Ballymena",
"4412297", "Millom",
"441453", "Dursley",
"441360", "Killearn",
"441948", "Whitchurch",
"441361", "Duns",
"441455", "Hinckley",
"441728", "Saxmundham",
"441560", "Moscow",
"441561", "Laurencekirk",
"441425", "Ringwood",
"441242", "Cheltenham",
"441263", "Cromer",
"4418512", "Stornoway",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441758", "Pwllheli",
"441829", "Tarporley",
"441246", "Chesterfield",
"441668", "Bamburgh",
"4415074", "Alford\ \(Lincs\)",
"441931", "Shap",
"441782", "Stoke\-on\-Trent",
"442837", "Armagh",
"441692", "North\ Walsham",
"4416860", "Newtown\/Llanidloes",
"441394", "Felixstowe",
"441387", "Dumfries",
"441786", "Stirling",
"4414305", "North\ Cave",
"441594", "Lydney",
"441234", "Bedford",
"441923", "Watford",
"441925", "Warrington",
"441807", "Ballindalloch",
"441838", "Dalmally",
"441745", "Rhyl",
"441656", "Bridgend",
"441743", "Shrewsbury",
"441567", "Killin",
"441554", "Llanelli",
"4413399", "Ballater",
"4416863", "Llanidloes",
"442879", "Magherafelt",
"441367", "Faringdon",
"441354", "Chatteris",
"4414235", "Harrogate",
"441766", "Porthmadog",
"441652", "Brigg",
"441285", "Cirencester",
"441911", "Tyneside\/Durham\/Sunderland",
"4415076", "Louth",
"441798", "Pulborough",
"441910", "Tyneside\/Durham\/Sunderland",
"441431", "Helmsdale",
"441283", "Burton\-on\-Trent",
"4418475", "Thurso",
"4418902", "Coldstream",
"441206", "Colchester",
"44147985", "Dulnain\ Bridge",
"4417683", "Appleby",
"4413397", "Ballater",
"441771", "Maud",
"441202", "Bournemouth",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"442895", "Belfast",
"441770", "Isle\ of\ Arran",
"441214", "Birmingham",
"442893", "Ballyclare",
"441549", "Lairg",
"441889", "Rugeley",
"441578", "Lauder",
"441349", "Dingwall",
"441934", "Weston\-super\-Mare",
"441591", "Llanwrtyd\ Wells",
"441483", "Guildford",
"4414345", "Haltwhistle",
"441590", "Lymington",
"441485", "Hunstanton",
"441406", "Holbeach",
"441946", "Whitehaven",
"441527", "Redditch",
"441726", "St\ Austell",
"4418514", "Great\ Bernera",
"441327", "Daventry",
"441639", "Neath",
"441942", "Wigan",
"4415072", "Spilsby\ \(Horncastle\)",
"441963", "Wincanton",
"4414373", "Clynderwen\ \(Clunderwen\)",
"4418511", "Great\ Bernera\/Stornoway",
"4418906", "Ayton",
"441722", "Salisbury",
"441677", "Bedale",
"4418904", "Coldstream",
"44161", "Manchester",
"4419759", "Alford\ \(Aberdeen\)",
"441902", "Wolverhampton",
"441914", "Tyneside",
"441210", "Birmingham",
"441985", "Warminster",
"441211", "Birmingham",
"4418516", "Great\ Bernera",
"4418901", "Coldstream\/Ayton",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441983", "Isle\ of\ Wight",
"4419757", "Strathdon",
"441446", "Barry",
"441869", "Bicester",
"441628", "Maidenhead",
"441463", "Inverness",
"441309", "Forres",
"441223", "Cambridge",
"441142", "Sheffield",
"441465", "Girvan",
"441225", "Bath",
"441350", "Dunkeld",
"441442", "Hemel\ Hempstead",
"441509", "Loughborough",
"441550", "Llandovery",
"441320", "Fort\ Augustus",
"441255", "Clacton\-on\-Sea",
"441253", "Blackpool",
"441520", "Lochcarron",
"441768", "Penrith",
"441832", "Clopton",
"4418518", "Stornoway",
"442842", "Kircubbin",
"4414303", "North\ Cave",
"4414230", "Harrogate\/Boroughbridge",
"441603", "Norwich",
"441792", "Swansea",
"4418470", "Thurso\/Tongue",
"441584", "Ludlow",
"441844", "Thame",
"441796", "Pitlochry",
"441397", "Fort\ William",
"441384", "Dudley",
"441237", "Bideford",
"441208", "Bodmin",
"441597", "Llandrindod\ Wells",
"441248", "Bangor\ \(Gwynedd\)",
"4413873", "Langholm",
"441666", "Malmesbury",
"441752", "Plymouth",
"441279", "Bishops\ Stortford",
"4418473", "Thurso",
"441564", "Lapworth",
"441557", "Kirkcudbright",
"441364", "Ashburton",
"441357", "Strathaven",
"441643", "Minehead",
"441756", "Skipton",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441335", "Ashbourne",
"441293", "Crawley",
"441671", "Newton\ Stewart",
"441788", "Rugby",
"441295", "Banbury",
"441535", "Keighley",
"441670", "Morpeth",
"4416865", "Newtown",
"442885", "Ballygawley",
"441698", "Motherwell",
"4414300", "North\ Cave\/Market\ Weighton",
"4414233", "Boroughbridge",
"4418908", "Coldstream",
"441217", "Birmingham",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:0|([5-8]\d{5})$)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/1624$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;