
use strict;
use warnings;

use Module::Build 0.3601;


my %module_build_args = (
  "build_requires" => {
    "Module::Build" => "0.3601"
  },
  "configure_requires" => {
    "Module::Build" => "0.3601"
  },
  "dist_abstract" => "Rinci/Riap-based command-line application framework",
  "dist_author" => [
    "Steven Haryanto <stevenharyanto\@gmail.com>"
  ],
  "dist_name" => "Perinci-CmdLine",
  "dist_version" => "0.84",
  "license" => "perl",
  "module_name" => "Perinci::CmdLine",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "Data::Dump::OneLine" => 0,
    "Data::Format::Pretty::Console" => 0,
    "File::Which" => 0,
    "JSON" => 0,
    "Log::Any" => 0,
    "Log::Any::App" => 0,
    "Monkey::Patch::Action" => 0,
    "Moo" => 0,
    "Perinci::Access" => "0.30",
    "Perinci::Access::HTTP::Client" => "0.06",
    "Perinci::Access::InProcess" => "0.36",
    "Perinci::Access::Simple::Client" => 0,
    "Perinci::BashComplete" => "0.29",
    "Perinci::Object" => "0.11",
    "Perinci::Result::Format" => "0.11",
    "Perinci::Sub::GetArgs::Argv" => "0.22",
    "Perinci::Sub::Wrapper" => "0.40",
    "Perinci::ToUtil" => 0,
    "Perinci::Tx::Manager" => "0.34",
    "Progress::Any" => "0.07",
    "Progress::Any::Output" => 0,
    "Progress::Any::Output::TermProgressBarColor" => 0,
    "Rinci" => "v1.1.27",
    "SHARYANTO::Getopt::Long::Util" => 0,
    "SHARYANTO::Role::Doc::Section" => "0.53",
    "SHARYANTO::Role::Doc::Section::AddTextLines" => "0.53",
    "SHARYANTO::Role::I18N" => "0.46",
    "SHARYANTO::Role::I18NRinci" => 0,
    "Tie::Simple" => 0,
    "UUID::Random" => 0,
    "YAML::Syck" => 0,
    "experimental" => 0,
    "perl" => "5.010001"
  },
  "script_files" => [
    "bin/strip-result-env-json",
    "bin/peri-func-usage",
    "bin/strip-result-env-yaml",
    "bin/peri-run"
  ],
  "test_requires" => {
    "Capture::Tiny" => 0,
    "File::Slurp" => 0,
    "Test::More" => "0.96",
    "Test::Script" => "1.05",
    "blib" => 0
  }
);


unless ( eval { Module::Build->VERSION(0.4004) } ) {
  my $tr = delete $module_build_args{test_requires};
  my $br = $module_build_args{build_requires};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

my $build = Module::Build->new(%module_build_args);

$build->create_build_script;
