
BEGIN { $| = 1; print "1..33\n"; }
END {print "not ok 1\n" unless $loaded;}

use String::Multibyte;

$bytes = String::Multibyte->new('Bytes',1);
$euc   = String::Multibyte->new('EUC',1);
$eucjp = String::Multibyte->new('EUC_JP',1);
$sjis  = String::Multibyte->new('ShiftJIS',1);
$utf8  = String::Multibyte->new('UTF8',1);
$u16be = String::Multibyte->new('UTF16BE',1);
$u16le = String::Multibyte->new('UTF16LE',1);

$^W = 1;
$loaded = 1;
print "ok 1\n";

#####

sub asc2str ($$) {
   my($cs, $str) = @_;
   $str =~ s/([\x00-\xFF])/\x00$1/g if $cs eq 'UTF16BE';
   $str =~ s/([\x00-\xFF])/$1\x00/g if $cs eq 'UTF16LE';
   return $str;
}
sub str2asc ($$) {
   my($cs, $str) = @_;
   $str =~ s/\x00([\x00-\xFF])/$1/g if $cs eq 'UTF16BE';
   $str =~ s/([\x00-\xFF])\x00/$1/g if $cs eq 'UTF16LE';
   return $str;
}

#####

for (["A-D", "ABCD"],
     ["-0",  "-0"],
     ["ab-", "ab-"],
     ['-+\-XYZ-', "-+-XYZ-"],
     ['-+\\-XYZ-', "-+-XYZ-"],
     ['-+\\\\-`', "-+\\]^_`"],
     ['\\\-^',  '\\]^' ],
     ['\\\\-]', '\\]' ],
     ['\\\\\-]', '\-]' ],
     ['\a-c', '\abc'],
     ['abZ-\\', 'abZ[\\'],
     ["0-9", "0123456789"],
     ["0-9", "0123456789", 1],
     ["9-0", "9876543210", 1],
     ["0-9-5", "01234567898765", 1],
     ["0-9-5-7", "0123456789876567", 1],
     ["", ""] ) { #14
    $NG = 0;
    $NG++ unless $bytes ->mkrange($_->[0], $_->[2]) eq $_->[1];
    $NG++ unless $euc  ->mkrange($_->[0], $_->[2]) eq $_->[1];
    $NG++ unless $eucjp->mkrange($_->[0], $_->[2]) eq $_->[1];
    $NG++ unless $sjis ->mkrange($_->[0], $_->[2]) eq $_->[1];
    $NG++ unless $utf8 ->mkrange($_->[0], $_->[2]) eq $_->[1];
    $NG++ unless asc2str('UTF16BE', $_->[1]) eq
	$u16be->mkrange(asc2str('UTF16BE', $_->[0]), $_->[2]);
    $NG++ unless asc2str('UTF16LE', $_->[1]) eq
	$u16le->mkrange(asc2str('UTF16LE', $_->[0]), $_->[2]);
    print ! $NG ? "ok" : "not ok", " ", ++$loaded, "\n";
}

#####

print $sjis->mkrange("\xDE-\x81\x42")
	eq "\xDE\xDF\x81\x40\x81\x41\x81\x42"
   && $sjis->mkrange("\x9F\xFC-\xE0\x41")
	eq "\x9F\xFC\xE0\x40\xE0\x41"
   && $sjis->mkrange("\x7D-\xA1\xA3")
	eq "\x7D\x7E\x7F\xA1\xA3"
   && $sjis->mkrange("\x81\x7D-\x81\x81")
	eq "\x81\x7D\x81\x7E\x81\x80\x81\x81"
   && $sjis->mkrange("\x86\xF9-\x87\x42")
	eq "\x86\xF9\x86\xFA\x86\xFB\x86\xFC\x87\x40\x87\x41\x87\x42"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

print $euc->mkrange("\x7E-\xA1\xA2")
	eq "\x7E\x7F\xA1\xA1\xA1\xA2"
   && $euc->mkrange("\xA1\xFC-\xA2\xA2")
	eq "\xA1\xFC\xA1\xFD\xA1\xFE\xA2\xA1\xA2\xA2"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

print $eucjp->mkrange("\x7E-\x8E\xA2")
	eq "\x7E\x7F\x8E\xA1\x8E\xA2"
   && $eucjp->mkrange("\x8E\xDF-\xA1\xA2")
	eq join('', map "\x8E".chr, 0xDF..0xFE)."\xA1\xA1\xA1\xA2"
   && $eucjp->mkrange("\x8E\xFD-\xA1\xA2")
	eq "\x8E\xFD\x8E\xFE\xA1\xA1\xA1\xA2"
   && $eucjp->mkrange("\xA1\xFC-\xA2\xA2")
	eq "\xA1\xFC\xA1\xFD\xA1\xFE\xA2\xA1\xA2\xA2"
   && $eucjp->mkrange("\xFD\xFD-\xFE\xA2")
	eq "\xFD\xFD\xFD\xFE\xFE\xA1\xFE\xA2"
   && $eucjp->mkrange("\xFE\xFE-\x8F\xA1\xA2")
	eq "\xFE\xFE\x8F\xA1\xA1\x8F\xA1\xA2"
   && $eucjp->mkrange("\x8F\xA3\xB1-\x8F\xA3\xB2")
	eq "\x8F\xA3\xB1\x8F\xA3\xB2"
   && $eucjp->mkrange("\x8F\xA1\xFC-\x8F\xA2\xA2")
	eq "\x8F\xA1\xFC\x8F\xA1\xFD\x8F\xA1\xFE\x8F\xA2\xA1\x8F\xA2\xA2"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

#####

# U+D7FE..U+E002
print $utf8->mkrange("\xed\x9f\xbe-\xee\x80\x82")
	eq "\xed\x9f\xbe\xed\x9f\xbf\xee\x80\x80\xee\x80\x81\xee\x80\x82"
   && $u16be->mkrange("\xD7\xFE\0-\xE0\x02")
	eq "\xD7\xFE\xD7\xFF\xE0\x00\xE0\x01\xE0\x02"
   && $u16le->mkrange("\xFE\xD7-\0\x02\xE0")
	eq "\xFE\xD7\xFF\xD7\x00\xE0\x01\xE0\x02\xE0"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+FFFD..U+10001
print $utf8->mkrange("\xef\xbf\xbd-\xf0\x90\x80\x81")
  eq "\xef\xbf\xbd\xef\xbf\xbe\xef\xbf\xbf\xf0\x90\x80\x80\xf0\x90\x80\x81"
   && $u16be->mkrange("\xFF\xFD\0-\xD8\x00\xDC\x01")
	eq "\xFF\xFD\xFF\xFE\xFF\xFF\xD8\x00\xDC\x00\xD8\x00\xDC\x01"
   && $u16le->mkrange("\xFD\xFF-\0\x00\xD8\x01\xDC")
	eq "\xFD\xFF\xFE\xFF\xFF\xFF\x00\xD8\x00\xDC\x00\xD8\x01\xDC"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+2FFFE..U+30001
print $utf8->mkrange("\xf0\xaf\xbf\xbe-\xf0\xb0\x80\x81")
	eq "\xf0\xaf\xbf\xbe\xf0\xaf\xbf\xbf\xf0\xb0\x80\x80\xf0\xb0\x80\x81"
   && $u16be->mkrange("\xd8\x7f\xdf\xfe\0-\xd8\x80\xdc\x01")
	eq "\xd8\x7f\xdf\xfe\xd8\x7f\xdf\xff\xd8\x80\xdc\x00\xd8\x80\xdc\x01"
   && $u16le->mkrange("\x7f\xd8\xfe\xdf-\0\x80\xd8\x01\xdc")
	eq "\x7f\xd8\xfe\xdf\x7f\xd8\xff\xdf\x80\xd8\x00\xdc\x80\xd8\x01\xdc"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+7FFFE..U+80001
print $utf8->mkrange("\xf1\xbf\xbf\xbe-\xf2\x80\x80\x81")
	eq "\xf1\xbf\xbf\xbe\xf1\xbf\xbf\xbf\xf2\x80\x80\x80\xf2\x80\x80\x81"
   && $u16be->mkrange("\xd9\xbf\xdf\xfe\0-\xd9\xc0\xdc\x01")
	eq "\xd9\xbf\xdf\xfe\xd9\xbf\xdf\xff\xd9\xc0\xdc\x00\xd9\xc0\xdc\x01"
   && $u16le->mkrange("\xbf\xd9\xfe\xdf-\0\xc0\xd9\x01\xdc")
	eq "\xbf\xd9\xfe\xdf\xbf\xd9\xff\xdf\xc0\xd9\x00\xdc\xc0\xd9\x01\xdc"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+8FFFE..U+90001
print $utf8->mkrange("\xf2\x8f\xbf\xbe-\xf2\x90\x80\x81")
	eq "\xf2\x8f\xbf\xbe\xf2\x8f\xbf\xbf\xf2\x90\x80\x80\xf2\x90\x80\x81"
   && $u16be->mkrange("\xd9\xff\xdf\xfe\0-\xda\x00\xdc\x01")
	eq "\xd9\xff\xdf\xfe\xd9\xff\xdf\xff\xda\x00\xdc\x00\xda\x00\xdc\x01"
   && $u16le->mkrange("\xff\xd9\xfe\xdf-\0\x00\xda\x01\xdc")
	eq "\xff\xd9\xfe\xdf\xff\xd9\xff\xdf\x00\xda\x00\xdc\x00\xda\x01\xdc"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

#####

# U+E002..U+D7FE
print $utf8->mkrange("\xee\x80\x82-\xed\x9f\xbe", 1)
	eq "\xee\x80\x82\xee\x80\x81\xee\x80\x80\xed\x9f\xbf\xed\x9f\xbe"
   && $u16be->mkrange("\xE0\x02\0-\xD7\xFE", 1)
	eq "\xE0\x02\xE0\x01\xE0\x00\xD7\xFF\xD7\xFE"
   && $u16le->mkrange("\x02\xE0-\0\xFE\xD7", 1)
	eq "\x02\xE0\x01\xE0\x00\xE0\xFF\xD7\xFE\xD7"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+10001..U+FFFD
print $utf8->mkrange("\xf0\x90\x80\x81-\xef\xbf\xbd", 1)
  eq "\xf0\x90\x80\x81\xf0\x90\x80\x80\xef\xbf\xbf\xef\xbf\xbe\xef\xbf\xbd"
   && $u16be->mkrange("\xD8\x00\xDC\x01\0-\xFF\xFD", 1)
	eq "\xD8\x00\xDC\x01\xD8\x00\xDC\x00\xFF\xFF\xFF\xFE\xFF\xFD"
   && $u16le->mkrange("\x00\xD8\x01\xDC-\0\xFD\xFF", 1)
	eq "\x00\xD8\x01\xDC\x00\xD8\x00\xDC\xFF\xFF\xFE\xFF\xFD\xFF"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+30001..U+2FFFE
print $utf8->mkrange("\xf0\xb0\x80\x81-\xf0\xaf\xbf\xbe", 1)
	eq "\xf0\xb0\x80\x81\xf0\xb0\x80\x80\xf0\xaf\xbf\xbf\xf0\xaf\xbf\xbe"
   && $u16be->mkrange("\xd8\x80\xdc\x01\0-\xd8\x7f\xdf\xfe", 1)
	eq "\xd8\x80\xdc\x01\xd8\x80\xdc\x00\xd8\x7f\xdf\xff\xd8\x7f\xdf\xfe"
   && $u16le->mkrange("\x80\xd8\x01\xdc-\0\x7f\xd8\xfe\xdf", 1)
	eq "\x80\xd8\x01\xdc\x80\xd8\x00\xdc\x7f\xd8\xff\xdf\x7f\xd8\xfe\xdf"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+80001..U+7FFFE
print $utf8->mkrange("\xf2\x80\x80\x81-\xf1\xbf\xbf\xbe", 1)
	eq "\xf2\x80\x80\x81\xf2\x80\x80\x80\xf1\xbf\xbf\xbf\xf1\xbf\xbf\xbe"
   && $u16be->mkrange("\xd9\xc0\xdc\x01\0-\xd9\xbf\xdf\xfe", 1)
	eq "\xd9\xc0\xdc\x01\xd9\xc0\xdc\x00\xd9\xbf\xdf\xff\xd9\xbf\xdf\xfe"
   && $u16le->mkrange("\xc0\xd9\x01\xdc-\0\xbf\xd9\xfe\xdf", 1)
	eq "\xc0\xd9\x01\xdc\xc0\xd9\x00\xdc\xbf\xd9\xff\xdf\xbf\xd9\xfe\xdf"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+90001..U+8FFFE
print $utf8->mkrange("\xf2\x90\x80\x81-\xf2\x8f\xbf\xbe", 1)
	eq "\xf2\x90\x80\x81\xf2\x90\x80\x80\xf2\x8f\xbf\xbf\xf2\x8f\xbf\xbe"
   && $u16be->mkrange("\xda\x00\xdc\x01\0-\xd9\xff\xdf\xfe", 1)
	eq "\xda\x00\xdc\x01\xda\x00\xdc\x00\xd9\xff\xdf\xff\xd9\xff\xdf\xfe"
   && $u16le->mkrange("\x00\xda\x01\xdc-\0\xff\xd9\xfe\xdf", 1)
	eq "\x00\xda\x01\xdc\x00\xda\x00\xdc\xff\xd9\xff\xdf\xff\xd9\xfe\xdf"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+D7FF..U+E000, U+10000..U+FFFF
print $utf8->mkrange(
	"\xed\x9f\xbf-\xee\x80\x80\xf0\x90\x80\x80-\xef\xbf\xbf", 1)
	eq "\xed\x9f\xbf\xee\x80\x80\xf0\x90\x80\x80\xef\xbf\xbf"
   && $u16be->mkrange("\xD7\xFF\0-\xE0\x00\xD8\x00\xDC\x00\0-\xFF\xFF", 1)
	eq "\xD7\xFF\xE0\x00\xD8\x00\xDC\x00\xFF\xFF"
   && $u16le->mkrange("\xFF\xD7-\0\x00\xE0\x00\xD8\x00\xDC-\0\xFF\xFF", 1)
	eq "\xFF\xD7\x00\xE0\x00\xD8\x00\xDC\xFF\xFF"
    ? "ok" : "not ok", " ", ++$loaded, "\n";

# U+D7FF..U+E000, U+10000..U+FFFF, U+7F
print $utf8->mkrange(
	"\xed\x9f\xbf-\xee\x80\x80\xf0\x90\x80\x80-\xef\xbf\xbf\x7F")
	eq "\xed\x9f\xbf\xee\x80\x80\x7F"
   && $u16be->mkrange("\xD7\xFF\0-\xE0\x00\xD8\x00\xDC\x00\0-\xFF\xFF\0\x7F")
	eq "\xD7\xFF\xE0\x00\0\x7F"
   && $u16le->mkrange("\xFF\xD7-\0\x00\xE0\x00\xD8\x00\xDC-\0\xFF\xFF\x7F\0")
	eq "\xFF\xD7\x00\xE0\x7F\0"
    ? "ok" : "not ok", " ", ++$loaded, "\n";


1;
__END__

