#!/usr/local/bin/perl

# Copyright 2001, Paul Johnson (pjcj@cpan.org)

# This software is free.  It is licensed under the same terms as Perl itself.

# The latest version of this software should be available from my homepage:
# http://www.pjcj.net

require 5.6.1;

use strict;
use warnings;

use ExtUtils::MakeMaker;

$| = 1;

my $Version = "0.12";
my $Date    = "14th October 2001";
my $Author  = 'pjcj@cpan.org';

my @perlbug = ("perlbug", "-a", $Author,
                          "-s", "Installation of Devel::Cover $Version");

my $Perlbug = join " ", map { / / ? "'$_'" : $_ } @perlbug;


open M, "MANIFEST" or die "Cannot open MANIFEST: $!";
my @files    = map { split } <M>, "Cover/Inc.pm";
my @versions = grep { $_ ne "README" && $_ ne "Makefile.PL" } @files;
close M or die "Cannot close MANIFEST: $!";

open I, ">Cover/Inc.pm" or die "Cannot open Cover/Inc.pm: $!";
print I <<"EOI";
# Copyright 2001, Paul Johnson (pjcj\@cpan.org)

# This software is free.  It is licensed under the same terms as Perl itself.

# The latest version of this software should be available from my homepage:
# http://www.pjcj.net

# This file was automatically generated by Makefile.PL.

package Devel::Cover::Inc;

use strict;
use warnings;

our \$VERSION = "$Version";
our \@Inc = qw( @INC );

1
EOI
close I or die "Cannot close Cover/Inc.pm: $!";

$ExtUtils::MakeMaker::Verbose = 0;

WriteMakefile
(
  NAME     => "Devel::Cover",
  VERSION  => $Version,
  AUTHOR   => 'Paul Johnson (pjcj@cpan.org)',
  ABSTRACT => "Code coverage metrics for Perl",
  DIR      => [],
  PM       => { map {($_ => '$(INST_LIBDIR)/' . $_)}
                    grep { /\.p(m|od)/ } @files },
  dist     => { COMPRESS => "gzip --best --force" },
  clean    => { FILES => join " ",  map { "$_.version" } @versions },
  depend   => { distdir => "@files" },
);

print "\n";
print "checking for Pod::Coverage.pm version 0.06 ........ ";

my $e = <<EOM;

Pod::Coverage.pm 0.06 is required to do pod coverage.  This will tell
you how well you have documented your modules.  Pod coverage will be
unavailable until you install this module, available from CPAN.  In the
meantime, you may continue to use the rest of Devel::Cover.pm.
EOM

eval "use Pod::Coverage";
if (my $m = $INC{"Pod/Coverage.pm"})
{
  my $v = eval { no warnings; $Pod::Coverage::VERSION };
  print $v < 0.06 ? "$v\n\n$e\n" : "$v $m\n";
}
else
{
  print "not found\n\n$e\n";
}

print <<EOM if 0;

--------------------------------------------------------------------------------

I like to have some idea of the distribution of this software.  To that end I
would be very grateful for mail from you.  This will be used only to satisfy my
curiosity and to help me make decisions which may involve changes to the
module.

If you can run perlbug you can send me a success report with "make ok".
Failure reports with "make nok" are also appreciated.

If you have any questions or comments, mailing list details are available in the
README file, or send mail to me directly.

EOM

sub MY::postamble
{
  qq[
SET_VERSION = \$(PERL) -pi.version \\
  -e 's/(^\\s*(?:our\\s+)\\\$\$VERSION = ")\\d+\\.\\d+(";)/\$\${1}$Version\$\$2/;' \\
  -e 's/(Version )\\d+\\.\\d+( - ).*/\$\${1}$Version\$\${2}$Date/;' \\
  -e 's/(^\\s*use Devel::Cover(?:::\\w+)*\\s+)\\d+\\.\\d+/\$\${1}$Version/;'

tags : @files
\t ptags @files

@versions : Makefile.PL
\t \$(SET_VERSION) @versions

README : Cover.pm
\t TERMCAP= COLUMNS=80 pod2text Cover.pm | \\
  \$(PERL) -n \\
  -e 'print if (/NAME/ ... /^[A-Z ]+\$\$/) =~ /^\\d+\$\$/;' \\
  -e 'print if (/DESCRIPTION/ ... /^[A-Z ]+\$\$/) =~ /^\\d+\$\$/;' \\
  > README

ppm : ppd pure_all
\t tar cf Devel-Cover.tar blib
\t gzip --best --force Devel-Cover.tar
\t \$(PERL) -pi.bak \\
  -e 's/(OS NAME=")[^"]*/\$\$1MSWin32/;' \\
  -e 's/(ARCHITECTURE NAME=")[^"]*/\$\$1MSWin32-x86-multi-thread/;' \\
  -e 's/(CODEBASE HREF=")[^"]*/\$\$1Gedcom.tar.gz/;' \\
  Devel-Cover.ppd

ok :
\t \@$Perlbug -okay  || echo "Please send your report manually to $Author"

nok :
\t \@$Perlbug -nokay || echo "Please send your report manually to $Author"
  ]
}
