package App::bif::drop::topic;
use strict;
use warnings;
use Bif::Mo;

our $VERSION = '0.1.5_6';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $dbw  = $self->dbw;
    my $info = $self->get_node( $opts->{id}, 'topic' );

    if ( !$opts->{force} ) {
        print "Nothing dropped (missing --force, -f)\n";
        return $self->ok('DropNoForce');
    }

    my $uuid = substr( $info->{uuid}, 0, 8 );

    $dbw->txn(
        sub {
            $self->start_work(
                start         => time,
                start_comment => "drop topic $info->{id} <$uuid>",
                billable      => 0,
                save          => 1,
            );

            # TODO: copy existing work_deltas rows into work_buffers
            # with NULL node_id so that the work activity is not lost.
            # Perhaps a new --no-work-buffer option or similar to
            # disable that behaviour.
            $dbw->xdo(
                delete_from => 'topics',
                where       => { id => $info->{id} },
            );

            print "Topic dropped: $info->{id} <$uuid>\n";

            $self->stop_work(
                stop    => time,
                restore => 1,
            );
        }
    );

    return $self->ok('Drop'. ucfirst($info->{tkind}));
}

1;
__END__

=head1 NAME

=for bif-doc #delete

bif-drop-topic - remove an topic from the repository

=head1 VERSION

0.1.5_6 (2015-10-20)

=head1 SYNOPSIS

    bif drop topic ID [OPTIONS...]

=head1 DESCRIPTION

The bif-drop-topic command removes a topic from the repository.

=head1 ARGUMENTS

=over

=item ID

A topic ID.

=back

=head1 OPTIONS

=over

=item --force, -f

Actually do the drop. This option is required as a safety measure to
stop you shooting yourself in the foot.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

