all: $(TESTS_PROGS)

if BUILD_PERL_EXTENSION 
PERLBINDINGS = perl
endif
if BUILD_PYTHON_EXTENSION 
PYTHONBINDINGS = python
endif
if BUILD_PHP_EXTENSION 
PHPBINDINGS = php
endif
if USE_CXX 
CXXBINDINGS = cxx
endif

BINDINGS = "c $(CXXBINDINGS) $(PERLBINDINGS) $(PYTHONBINDINGS) $(PHPBINDINGS)"

#
# Warning!!!!
# This is a cheat. Reference results should never be generated using the
# same code that it is testing. Due to the large number of tests involved,
# and the likelyhood of listswf output changing as things get fixed, we
# need a reasonable way to avoid having to hand edit a huge number of
# reference files. The compromise, is that all new reference files, and
# all changes to existing files must be carefully inspected by hand before
# committing them.
#
refs: $(C_PROGS)
	for t in $(C_PROGS); do ./$$t; $(top_builddir)/util/listswf $$t.swf >$$t.ref; done

gen: refs $(SWFS) php.ini
	for t in $(C_PROGS); do \
	$(top_builddir)/util/swftophp $$t.swf $$t.swf | sed -e 's^/usr/bin/php^/usr/bin/php -c.^' >$$t.php ;\
	$(top_builddir)/util/swftoperl $$t.swf $$t.swf >$$t.pl ;\
	$(top_builddir)/util/swftopython $$t.swf $$t.swf >$$t.py ;\
	$(top_builddir)/util/swftocxx $$t.swf $$t.swf >$$t-cxx.C ;\
	$(top_builddir)/util/swftotcl $$t.swf $$t.swf >$$t.tcl ;\
	done

.PHONY: dotests php.ini
dotests: $(top_srcdir)/test/dotests.pl php.ini
	echo "top_builddir=$(top_builddir) builddir=$(PWD) srcdir=$(srcdir) BINDINGS='$(BINDINGS)' $(PERL) -w $(top_srcdir)/test/dotests.pl" > $@
	chmod +x $@

php.ini: 
	echo "extension_dir=$(top_builddir)/php_ext/tmp/modules" >php.ini
	echo "extension=ming.so" >>php.ini
