9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600  1) package Devel::hdb::Router;
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600  2) 
e34e73c3 (Anthony Brummett 2013-02-07 11:02:41 -0600  3) use strict;
e34e73c3 (Anthony Brummett 2013-02-07 11:02:41 -0600  4) use warnings;
e34e73c3 (Anthony Brummett 2013-02-07 11:02:41 -0600  5) 
95157038 (Anthony Brummett 2016-11-23 11:43:33 -0600  6) our $VERSION = '0.23_07';
9be5a965 (Anthony Brummett 2016-10-31 11:42:11 -0500  7) 
a947fbf2 (Anthony Brummett 2016-12-07 16:45:45 -0600  8) use Devel::hdb::Logger qw(log);
a947fbf2 (Anthony Brummett 2016-12-07 16:45:45 -0600  9) 
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 10) sub new {
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 11)     my $class = shift;
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 12)     return bless {}, $class;
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 13) }
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 14) 
2802502a (Anthony Brummett 2014-07-03 22:20:39 -0500 15) foreach my $method ( qw(get post put delete head) ) {
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 16)     my $key = uc($method);
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 17)     my $sub = qq(
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 18)         sub {
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 19)             my(\$self, \$path, \$sub) = \@_;
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 20)             my \$list = \$self->{$key} ||= [];
a947fbf2 (Anthony Brummett 2016-12-07 16:45:45 -0600 21)             #log("Registering route for \$key \$path");
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 22)             push \@\$list, [ \$path, \$sub ];
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 23)         };
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 24)     );
fe092a86 (Anthony Brummett 2014-08-25 10:36:04 -0500 25)     $sub =~ s/#// if $ENV{HDB_DEBUG_MSG};
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 26)     no strict 'refs';
a8ef41c0 (Anthony Brummett 2014-07-03 20:57:15 -0500 27)     *$method = eval $sub;
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 28) }
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 29) 
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 30) sub route($$) {
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 31)     my $self = shift;
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 32)     my $env = shift;
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 33) 
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 34)     my $req_method = $env->{REQUEST_METHOD};
a947fbf2 (Anthony Brummett 2016-12-07 16:45:45 -0600 35)     log "Incoming request: $req_method ",$env->{PATH_INFO};
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 36)     return unless exists $self->{$req_method};
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 37)     my $matchlist = $self->{$req_method};
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 38) 
9143c390 (Anthony Brummett 2013-02-04 19:32:19 -0600 39)     my($fire, @matches);
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 40)     foreach my $route ( @$matchlist ) {
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 41)         my($path,$cb) = @$route;
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 42) 
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 43)         if (my $ref = ref($path)) {
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 44)             if ($ref eq 'Regexp') {
9143c390 (Anthony Brummett 2013-02-04 19:32:19 -0600 45)                 $fire = 1 if (@matches = $env->{PATH_INFO} =~ $path);
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 46)             } elsif ($ref eq 'CODE') {
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 47)                 $fire = 1 if ($path->($self, $env));
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 48)             }
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 49)         } elsif ($env->{PATH_INFO} eq $path) {
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 50)             $fire = 1;
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 51)         }
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 52) 
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 53)         if ($fire) {
a947fbf2 (Anthony Brummett 2016-12-07 16:45:45 -0600 54)             log '  matched!';
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 55)             my $rv = $cb->($env, @matches);
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 56)             my $hooks = $self->{after_hooks}->{$req_method}->{$path};
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 57)             if ($hooks && @$hooks) {
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 58)                 $_->($rv, $env, @matches) foreach @$hooks;
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 59)             }
a947fbf2 (Anthony Brummett 2016-12-07 16:45:45 -0600 60)             log '  returning code ',$rv->[0];
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 61)             return $rv;
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 62)         }
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 63)     }
a947fbf2 (Anthony Brummett 2016-12-07 16:45:45 -0600 64)     log '  no matching route';
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 65)     return [ 404, [ 'Content-Type' => 'text/html'], ['Not found']];
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 66) }
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 67) 
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 68) sub once_after($$$&) {
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 69)     my($self, $req, $path, $cb) = @_;
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 70) 
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 71)     my $this_list = $self->{after_hooks}->{$req}->{$path} ||= [];
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 72) 
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 73)     my $wrapped_as_str;
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 74)     my $wrapped = sub {
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 75)         &$cb;
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 76)         for (my $i = 0; $i < @$this_list; $i++) {
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 77)             if ($this_list->[$i] eq $wrapped_as_str) {
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 78)                 splice(@$this_list, $i, 1);
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 79)                 return;
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 80)            }
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 81)         }
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 82)     };
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 83)     $wrapped_as_str = $wrapped . '';
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 84) 
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 85)     push @$this_list, $wrapped;
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 86) }
614503ef (Anthony Brummett 2013-04-03 14:36:22 -0500 87) 
9feea3d2 (Anthony Brummett 2013-02-04 16:01:55 -0600 88) 1;
