;; bbdb-reportmail.el --- Hooks the Insidious Big Brother Database
;;                        into the Reportmail package

;; Copyright (C) 1997 Christopher Kline

;; Author: Christopher Kline <ckline@media.mit.edu>
;; Maintainer: Christopher Kline <ckline@media.mit.edu>
;; Version: 1.01
;; Created: 25 Jun 1997
;; Date: 26 Jun 1997

;; Bbdb-reportmail is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Bbdb-reportmail is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Bbdb-reportmail advises the reportmail package function
;; display-time-get-field so that it attempts to replace the reported
;; "from" and "to" fields with the name field (or mail-name, if it
;; exists) of the corresponding BBDB record, if such a correspondence
;; can be made.

;; To use this, simply add the following lines AFTER you load in your
;; bbdb, set bbdb variables, etc.
;;
;;  (bbdb-insinuate-reportmail)
;;
;; (A require used to be necessary - it is no longer needed as long as
;; bbdb-insinuate-reportmail is called)

;;; History:

;; v1.01 26 June 1997
;;       Fixed the advice so that if we are the message recipient, do
;;       nothing so that display-time-process-new-mail will correctly
;;       trap this case.
;;
;; v1.00 26 June 1997
;;       Initial release.

;;
;; $Id: bbdb-reportmail.el,v 1.4 2002/02/12 22:56:38 youngs Exp $
;;
;; $Log: bbdb-reportmail.el,v $
;; Revision 1.4  2002/02/12 22:56:38  youngs
;; 2002-02-13  Steve Youngs  <youngs@xemacs.org>
;;
;; 	* Sync to BBDB 2.34.
;;
;; 	* lisp/bbdb-sc.el (bbdb-insinuate-sc): Autoload it.
;;
;; 2002-01-15  Waider  <waider@waider.ie>
;;
;; 	* testing/bbdb-test.el:
;; 	  New file
;;
;; 	* bits/make.bat:
;; 	  Merged in some changes from the mailing list. Note, this is
;; 	  still experimental.
;;
;; 	* lisp/bbdb-com.el:
;; 	  Don't fset things that aren't ours
;; 	  Last of compiler warning cleanup
;; 	  Fixed one more completion bug
;;
;; 2002-01-14  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-hooks.el:
;; 	  Conditionalise the rmail load
;;
;; 	* lisp/bbdb-gui.el:
;; 	  Make X/Emacs compatibility less intrusive
;;
;; 2002-01-13  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-hooks.el:
;; 	  Don't force VM on people, even if it is a great mailer...
;;
;; 2002-01-10  Waider  <waider@waider.ie>
;;
;; 	* bbdb-com.el:
;; 	  Last few fixes (hopefully) to completion
;;
;; 	* lisp/bbdb-snarf.el:
;; 	  Make bbdb-rfc822-addresses the default address parser
;; 	  Remove test-harness code to elsewhere (i.e. not in user code!)
;;
;; 	* lisp/bbdb.el:
;; 	  Changed the workaround for set-keymap-prompt, as it seemed to be
;; 	  clashing with VM. Ideally, all this Emacs/XEmacs stuff should go
;; 	  in a separate file, or at least all in one part of bbdb.el.
;;
;; 2002-01-06  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-xemacs.el, lisp/bbdb-srv.el, lisp/bbdb-sc.el,
;; 	  lisp/bbdb-gui.el, lisp/bbdb-ftp.el, lisp/bbdb-com.el,
;; 	  lisp/bbdb-hooks.el, lisp/bbdb-w3.el, lisp/bbdb.el,
;; 	  lisp/bbdb-snarf.el:
;; 	Compiler cleanup
;;
;; 2002-01-04  Robert Fenk  <Robert.Fenk@gmx.de>
;;
;; 	* lisp/bbdb-snarf.el (bbdb-extract-address-component-regexps):
;; 	Replaced the call of bbdb-clean-username bt a call to
;; 	mail-extract-address-components in order to handle addresses of
;; 	the form "Lastname, Firstname" and "Firstname Lastname, Jr" in the
;; 	right way.
;; 	(bbdb-test/bbdb-extract-address-components): New test function to
;; 	check if everything is working as it should.
;;
;; 2002-01-03  Robert Fenk  <Robert.Fenk@gmx.de>
;;
;; 	* lisp/bbdb-com.el (bbdb-complete-name): fixed cycling when the
;; 	current completion is equal to one of the nets.
;; 	Added code for C-u M-TAB which lists all possible nets of current
;; 	completed addess.
;;
;; 2002-01-01  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-com.el (bbdb-complete-name):
;; 	Two fixes based on further testing with completion-type.
;;
;; 2001-12-27  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-com.el
;; 	(bbdb-completing-read-one-record):
;; 	Correctly handle case where no records are selected
;; 	(bbdb-complete-name):
;; 	Whoops. Small logic error in cycling code
;;
;; 	* lisp/bbdb.el (bbdb-send-mail-style),
;; 	  lisp/bbdb-com.el (bbdb-send-mail-internal):
;; 	Add Mew as an option for bbdb-send-mail-style
;;
;; 2001-12-27  Jeff Bigler  <jcb@mit.edu>
;;
;; 	* lisp/bbdb-com.el (bbdb-phone-area-regexp):
;; 	Allow / and . as separators when parsing a phone number.
;;
;; 2001-12-26  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-com.el (bbdb-complete-name):
;; 	Mostly rewritten to consolidate the last four years(!) of code
;; 	glomming.
;;
;; 	* lisp/bbdb.el (bbdb-search-intertwingle):
;; 	New function. More stringent version of bbdb-search-simple,
;; 	intended for internal bbdb use only
;;
;; 2001-12-10  Karl Fogel <kfogel@red-bean.com>
;;
;; 	* bbdb.texinfo
;; 	(Mail Sending Interfaces):
;; 	Use `add-hook' instead of `setq' in the examples, so users won't
;; 	clobber existing hooks.
;; 	(Known Bugs):
;; 	Reference mailing lists, as is done in other places where the
;; 	`bbdb-info' list is mentioned.
;;
;; 2001-11-19  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb.el (bbdb-format-address):
;; 	Several people contributed a patch to fix this. Alex Schroeder's
;;       	  was the most general as it handles both printing and
;; 	  non-printing situations.
;;
;; 	* lisp/bbdb-print.el
;; 	Some more fixes from Alex.
;;
;; 2001-11-12  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-snarf.el (bbdb-extract-address-component-regexps):
;; 	Allow '+' as part of an email address
;;
;; 	* lisp/bbdb-com.el (bbdb-complete-name-allow-cycling):
;; 	Documentation fix
;; 	(bbdb-get-help-window):
;; 	Removed dead code
;;
;; 	* lisp/bbdb.el
;; 	Try to autoload the message-mode and mail-mode keymaps rather than
;; 	defining them as nil.
;;
;; 2001-11-11  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-vm.el (bbdb/vm-set-auto-folder-alist-field):
;; 	Move into mua-specific group
;; 	(bbdb/vm-set-auto-folder-alist):
;; 	Documentation typo
;;
;; 2001-11-06  Waider  <waider@waider.ie>
;;
;; 	* texinfo/bbdb.texinfo (Mail Sending Interfaces):
;; 	Mention message-setup-hook in the mail aliases section
;; 	(Raymond Scholz)
;;
;; 2001-10-14  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-gnus.el
;; 	(bbdb/gnus-pop-up-bbdb-buffer):
;; 	Move the call to bbdb-display-records back inside the (when...)
;; 	I had two bug reports for this (Sudesh Joseph and Michael
;; 	Totschnig).
;;
;; 	* lisp/bbdb.el:
;; 	Added Nix's patch to make inside-bbdb-notice-hook work as
;; 	advertised, also other bbdb-expire support.
;; 	(bbdb-search-simple):
;; 	Try company name if record name is unset, before falling back to
;; 	"". (Martin Schwenke)
;;
;; 	* lisp/bbdb-com.el
;; 	(bbdb-complete-name):
;; 	Restored the original code to handle making sure primary addresses
;; 	get picked first, since the code I'd replaced it with had some
;; 	dubious side-effects.
;; 	(bbdb-create-internal):
;; 	Documentation fix. (Ueli Schlpfer)
;;
;; 2001-09-20  Robert Fenk  <Robert.Fenk@gmx.de>
;;
;; 	* lisp/bbdb.el (bbdb-create-hook), (bbdb-notice-hook):
;; 	Added a note that hook functions might use the new variables
;; 	bbdb-update-address-class and bbdb-update-address-header to obtain
;; 	information about the currently processed email address.
;;
;; 	* lisp/bbdb-com.el (bbdb-get-addresses-headers): merged
;; 	bbdb-get-addresses-from-headers  and bbdb-get-addresses-to-headers
;; 	into this variable.
;; 	(bbdb-get-addresses): new generic function for extraction of email
;; 	addresses from header, which is used by Gnus and VM
;; 	(bbdb-update-address-class), (bbdb-update-address-header): new
;; 	variable providing additional information to hook functions about
;; 	the currently processed email address.
;;
;; 	* lisp/bbdb-gnus.el (bbdb/gnus-update-records): uses
;; 	bbdb-get-addresses instead of bbdb/gnus-get-addresses which was
;; 	removed.
;; 	(bbdb/gnus-show-sender), (bbdb/gnus-show-all-recipients),
;; 	(bbdb/gnus-show-records): modified to use new style of
;; 	bbdb-get-addresses-headers
;;
;; 	* lisp/bbdb-vm.el (bbdb/vm-get-header-content): VM specific header
;; 	extraction function.
;; 	(bbdb/vm-update-records): bbdb-get-addresses instead of
;; 	bbdb/vm-get-addresses which was removed.
;; 	(bbdb/vm-show-all-recipients),
;; 	(bbdb/vm-show-sender), (bbdb/vm-show-records): modified to use new
;; 	style of bbdb-get-addresses-headers
;;
;; 	* lisp/bbdb-hooks.el (bbdb-auto-notes-alist): Additional element
;; 	type to allow actions also on recipients of an message
;; 	(bbdb-auto-notes-hook): Fixed to perfom auto-note actions only for
;; 	authors of a message.  Support for new features of
;; 	bbdb-auto-notes-alist.  Honor bbdb-silent-running.
;;
;; 2001-09-18  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-snarf.el (bbdb-rfc822-addresses):
;; 	Cope with rfc822-addresses returning nil as the car.
;;
;; 2001-09-11  Robert Fenk  <Robert.Fenk@gmx.de>
;;
;; 	* lisp/bbdb-print.el (bbdb-print-field-shown-p): Added as a
;; 	replacement for bbdb-field-shown-p.
;; 	(bbdb-print-omit-fields): Added as a replacement for
;; 	bbdb-print-elided-display.
;;
;; 	* lisp/bbdb-com.el (bbdb-get-addresses-headers):
;; 	bbdb-auto-notes-alist does not know if a address comes form a
;; 	author or recipient of a message and therefore might update wrong
;; 	records, e.g. the organization of recipients to that of the
;; 	author.
;; 	Therfore the default is now bbdb-get-addresses-from-headers until
;; 	the hook functions are able to tell the type (author/recp) of an
;; 	address.
;;
;; 2001-09-09  Waider  <waider@waider.ie>
;;
;; 	* lisp/bbdb-gui.el:
;; 	Fixed bogus fset (fsetting variable instead of 'variable)
;; 	(bbdb-hack-x-face):
;; 	use bbdb-find-face, not find-face
;;
;; 	* lisp/bbdb.el
;; 	(bbdb-initialize):
;; 	Fixed vm entry. vm-load-hook no longer exists!
;; 	(bbdb-mode):
;; 	Removed references to bbdb-elide-record
;;
;; 2001-09-05  Robert Fenk  <Robert.Fenk@gmx.de>
;;
;; 	* lisp/bbdb-com.el (bbdb-complete-name-hooks): Fixed the
;; 	documentation.
;; 	(bbdb-get-only-first-address-p): fixed the default value, which
;; 	should have been t
;;
;; 2001-09-04  Robert Fenk  <Robert.Fenk@gmx.de>
;;
;; 	* lisp/bbdb.el (bbdb-annotate-message-sender): calling of
;; 	bbdb-create-hook functions moved to the end of function
;; 	(bbdb-display-layout-alist): replaced by the nice version
;; 	provided by Alex Schroeder <alex@gnu.org>
;;
;; 2001-08-31  Robert Fenk  <Robert.Fenk@gmx.de>
;;
;; 	* lisp/bbdb-hooks.el (bbdb-auto-notes-alist): applied posted
;; 	patch of better customization.
;;
;; 	* lisp/bbdb-srv.el, lisp/bbdb-rmail.el, lisp/bbdb-mhe.el,
;; 	lisp/bbdb-vm.el, lisp/bbdb-gnus.el, lisp/bbdb.el,
;; 	lisp/bbdb-com.el: replaced occureneces of bbdb-elided-display and
;; 	bbdb-pop-up-elided-display.
;;
;; 	* lisp/bbdb-gui.el (build-bbdb-menu): Fix menus to use new display
;; 	layout toggeling functions.
;;
;; 	* lisp/bbdb-com.el (bbdb-change-records-state-and-redisplay),
;; 	(bbdb-toggle-all-records-display-layout),
;; 	(bbdb-toggle-records-display-layout),
;; 	(bbdb-display-all-records-completely),
;; 	(bbdb-display-record-completely): modified functions for toggeling
;; 	the display layout of records.  Old functions bbdb-elide-record
;; 	and bbdb-unelide-records have been removed.
;;
;; 	* lisp/bbdb.el
;; 	(bbdb-display-layout-alist): variable controling options for
;; 	display layouts, support for user defines format functions still
;; 	missing.
;; 	(bbdb-display-layout): variable controling the default display layout
;; 	(bbdb-pop-up-display-layout): variable controling  the default display
;; 	layout for pop-up buffers.
;; 	(bbdb-elided-display), (bbdb-pop-up-elided-display): are obsolete
;; 	variables now.
;; 	(bbdb-elided-display-sanity-setup): function which sets up the
;; 	layout variables from the obsolete bbdb-elided-display and
;; 	bbdb-pop-up-elided-display variables.  Might be removed along with
;; 	the variables in the future.
;; 	(bbdb-format-record): rewitten to support multiple
;; 	layouts according to bbdb-display-layout-alist
;; 	(bbdb-format-record-layout-multi-line),
;; 	(bbdb-format-record-layout-one-line),
;; 	(bbdb-format-record-one-line-*): Function specific to certain
;; 	layouts.
;;
;; Revision 1.55  2000/07/13 17:07:00  sds
;; minor doc fixes to comply with the standards
;;
;; Revision 1.54  1998/04/11 07:18:55  simmonmt
;; Colin Rafferty's patch adding autoload cookies back
;;
;; Revision 1.53  1998/01/06 06:10:06  simmonmt
;; Changed setup documentation and added RCS ID and Log strings
;;
;;

;;-----------------------------------------------------------------------

(require 'bbdb)
(require 'reportmail)
(require 'advice)
(require 'mail-extr)

(defun bbdb/reportmail-alternate-full-name (address)
  (if address
      (let ((entry (bbdb-search-simple nil address)))
	(if entry
	    (or (bbdb-record-getprop entry 'mail-name)
		(bbdb-record-name entry))))))

(defadvice display-time-get-field
  (around bbdb/reportmail-hack-display-time-get-field disable activate)
  "Advises the `display-time-get-field' function in the reportmail package.
If the field is \"from\" or \"to\", it tries to replace the value of the field
with the name field of the corresponding BBDB entry, if one can be found.

If no corresponding record can be found, the field value is left unaltered."
  (let (gf-field)
    ;; Get the original argument to display-time-get-field
    (setq gf-field (ad-get-arg 0))
    ;; Call the original display-time-get-field
    ad-do-it
    (if (or (string= gf-field "To") (string= gf-field "From"))
	(setq ad-return-value
	      (or
	       ;; If this message is to me, then do nothing so
	       ;; reportmail can trap this case in
	       ;; display-time-process-new-mail
	       (if (display-time-member ad-return-value
                      display-time-my-addresses)
		   ad-return-value
		 nil)
	       ;; Is the sender/recipient in our BBDB?
	       (bbdb/reportmail-alternate-full-name
		(car (cdr (mail-extract-address-components ad-return-value))))
	       ;; Can't find sender/recipient in BBDB; do nothing.
	       ad-return-value)
	      ))))

;;;###autoload
(defun bbdb-insinuate-reportmail ()
  "Call this function to hook BBDB into reportmail."
  (ad-enable-advice 'display-time-get-field 'around
		    'bbdb/reportmail-hack-display-time-get-field)
  (ad-activate 'display-time-get-field)
  (message "Insinuated BBDB into Reportmail.")
)

(provide 'bbdb-reportmail)


