/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHCastExpression;
import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.ClassPathException;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Name;
import bsh.NameSource;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.This;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NameSpace
implements Serializable,
BshClassManager.Listener,
NameSource {
    public static final NameSpace JAVACODE = new NameSpace("Called from compiled Java code");
    public String name;
    private NameSpace parent;
    private Hashtable variables;
    private Hashtable methods;
    private Hashtable importedClasses;
    private This thisReference;
    private Vector importedPackages;
    private static transient boolean superImport;
    private transient Hashtable classCache;
    SimpleNode callerInfoNode;
    Vector nameSourceListeners;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public NameSpace(String string) {
        this(null, string);
    }

    public NameSpace(NameSpace nameSpace, String string) {
        this.setName(string);
        this.setParent(nameSpace);
        BshClassManager.addCMListener(this);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    void setNode(SimpleNode simpleNode) {
        this.callerInfoNode = simpleNode;
    }

    SimpleNode getNode() {
        return this.callerInfoNode;
    }

    public Object get(String string, Interpreter interpreter) throws EvalError {
        CallStack callStack = new CallStack();
        return this.getNameResolver(string).toObject(callStack, interpreter);
    }

    public void setVariable(String string, Object object) throws EvalError {
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if (object == null) {
            this.variables.remove(string);
        } else {
            Object v = this.variables.get(string);
            if (v != null && v instanceof TypedVariable) {
                try {
                    ((TypedVariable)v).setValue(object);
                }
                catch (EvalError evalError) {
                    throw new EvalError("Typed variable: " + string + ": " + evalError.getMessage());
                }
            } else {
                this.variables.put(string, object);
            }
        }
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.variables.keys());
    }

    public String[] getMethodNames() {
        if (this.methods == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.methods.keys());
    }

    private String[] enumerationToStringArray(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NameSpace getParent() {
        return this.parent;
    }

    public NameSpace getSuper() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    public NameSpace getGlobal() {
        if (this.parent != null) {
            return this.parent.getGlobal();
        }
        return this;
    }

    This getThis(Interpreter interpreter) {
        if (this.thisReference == null) {
            this.thisReference = This.getThis(this, interpreter);
        }
        return this.thisReference;
    }

    public void prune() {
        this.parent = null;
    }

    public void setParent(NameSpace nameSpace) {
        this.parent = nameSpace;
    }

    public Object getVariable(String string) {
        return this.getVariable(string, true);
    }

    public Object getVariable(String string, boolean bl) {
        Object object = this.getVariableImpl(string, bl);
        return this.unwrapVariable(object);
    }

    protected Object unwrapVariable(Object object) {
        if (object instanceof TypedVariable) {
            object = ((TypedVariable)object).getValue();
        }
        return object == null ? Primitive.VOID : object;
    }

    protected Object getVariableImpl(String string, boolean bl) {
        Object object = null;
        if (this.variables != null) {
            object = this.variables.get(string);
        }
        if (bl && object == null && this.parent != null) {
            object = this.parent.getVariable(string, bl);
        }
        return object;
    }

    public void setTypedVariable(String string, Class clazz, Object object, boolean bl) throws EvalError {
        Object object2;
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if (object == null) {
            if (clazz.isPrimitive()) {
                if (clazz == Boolean.TYPE) {
                    object = new Primitive(Boolean.FALSE);
                } else if (clazz == Byte.TYPE) {
                    object = new Primitive(0);
                } else if (clazz == Short.TYPE) {
                    object = new Primitive(0);
                } else if (clazz == Character.TYPE) {
                    object = new Primitive('\u0000');
                } else if (clazz == Integer.TYPE) {
                    object = new Primitive(0);
                } else if (clazz == Long.TYPE) {
                    object = new Primitive(0L);
                } else if (clazz == Float.TYPE) {
                    object = new Primitive(0.0f);
                } else if (clazz == Double.TYPE) {
                    object = new Primitive(0.0);
                }
            } else {
                object = Primitive.NULL;
            }
        }
        if (this.variables.containsKey(string) && (object2 = this.getVariableImpl(string, false)) instanceof TypedVariable) {
            if (((TypedVariable)object2).getType() != clazz) {
                throw new EvalError("Typed variable: " + string + " was previously declared with type: " + ((TypedVariable)object2).getType());
            }
            ((TypedVariable)object2).setValue(object);
            return;
        }
        this.variables.put(string, new TypedVariable(clazz, object, bl));
    }

    public void setMethod(String string, BshMethod bshMethod) {
        Object v;
        if (this.methods == null) {
            this.methods = new Hashtable();
        }
        if ((v = this.methods.get(string)) == null) {
            this.methods.put(string, bshMethod);
        } else if (v instanceof BshMethod) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(v);
            vector.addElement(bshMethod);
            this.methods.put(string, vector);
        } else {
            ((Vector)v).addElement(bshMethod);
        }
    }

    public BshMethod getMethod(String string, Class[] classArray) {
        Object object = null;
        Object var4_4 = null;
        if (this.methods != null) {
            var4_4 = this.methods.get(string);
        }
        if (var4_4 instanceof Vector) {
            Vector vector = var4_4;
            Object[] objectArray = new BshMethod[vector.size()];
            vector.copyInto(objectArray);
            Class[][] classArray2 = new Class[objectArray.length][];
            int n = 0;
            while (n < objectArray.length) {
                classArray2[n] = ((BshMethod)objectArray[n]).getArgTypes();
                ++n;
            }
            int n2 = Reflect.findMostSpecificSignature(classArray, classArray2);
            if (n2 != -1) {
                object = objectArray[n2];
            }
        } else {
            object = var4_4;
        }
        if (object == null && this.parent != null) {
            return this.parent.getMethod(string, classArray);
        }
        return object;
    }

    public void importClass(String string) {
        if (this.importedClasses == null) {
            this.importedClasses = new Hashtable();
        }
        this.importedClasses.put(Name.suffix(string, 1), string);
        this.nameSpaceChanged();
    }

    private String getImportedClass(String string) throws ClassPathException {
        String string2 = null;
        if (this.importedClasses != null) {
            string2 = (String)this.importedClasses.get(string);
        }
        if (string2 == null && this.parent != null) {
            return this.parent.getImportedClass(string);
        }
        return string2;
    }

    public void importPackage(String string) {
        if (this.importedPackages == null) {
            this.importedPackages = new Vector();
        }
        this.importedPackages.addElement(string);
        this.nameSpaceChanged();
    }

    public String[] getImportedPackages() {
        Vector<String> vector = new Vector<String>();
        if (this.parent != null) {
            String[] stringArray = this.parent.getImportedPackages();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        if (this.importedPackages != null) {
            int n = 0;
            while (n < this.importedPackages.size()) {
                vector.addElement((String)this.importedPackages.elementAt(n));
                ++n;
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Class getClass(String string) throws ClassPathException {
        Class clazz = null;
        if (this.classCache != null) {
            clazz = (Class)this.classCache.get(string);
        }
        if (clazz == null && (clazz = this.getClassImpl(string)) != null) {
            if (this.classCache == null) {
                this.classCache = new Hashtable();
            }
            this.classCache.put(string, clazz);
        }
        return clazz;
    }

    private Class getClassImpl(String string) throws ClassPathException {
        Object object;
        if (!Name.isCompound(string)) {
            Object object2;
            Object object3;
            object = this.getImportedClass(string);
            if (object != null) {
                Class clazz = this.classForName((String)object);
                if (clazz == null) {
                    if (Name.isCompound((String)object)) {
                        try {
                            clazz = this.getNameResolver((String)object).toClass();
                        }
                        catch (EvalError evalError) {}
                    } else {
                        Interpreter.debug("imported unpackaged name not found:" + (String)object);
                    }
                }
                if (clazz != null) {
                    BshClassManager.cacheClassInfo((String)object, clazz);
                    return clazz;
                }
                return null;
            }
            String[] stringArray = this.getImportedPackages();
            int n = stringArray.length - 1;
            while (n >= 0) {
                object3 = stringArray[n] + "." + string;
                object2 = this.classForName((String)object3);
                if (object2 != null) {
                    return object2;
                }
                --n;
            }
            if (superImport && (object3 = BshClassManager.getClassManager()) != null && (object2 = ((BshClassManager)object3).getClassNameByUnqName(string)) != null) {
                return this.classForName((String)object2);
            }
        }
        if ((object = this.classForName(string)) != null) {
            return object;
        }
        Interpreter.debug("getClass(): " + string + " not\tfound in " + this);
        return null;
    }

    private Class classForName(String string) {
        return BshClassManager.classForName(string);
    }

    public String[] getAllNames() {
        Vector vector = new Vector();
        this.getAllNamesAux(vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void getAllNamesAux(Vector vector) {
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Enumeration enumeration2 = this.methods.keys();
        while (enumeration2.hasMoreElements()) {
            vector.addElement(enumeration2.nextElement());
        }
        if (this.parent != null) {
            this.parent.getAllNamesAux(vector);
        }
    }

    public void addNameSourceListener(NameSource.Listener listener) {
        if (this.nameSourceListeners == null) {
            this.nameSourceListeners = new Vector();
        }
        this.nameSourceListeners.addElement(listener);
    }

    public static void doSuperImport() throws EvalError {
        BshClassManager bshClassManager = BshClassManager.getClassManager();
        if (bshClassManager != null) {
            bshClassManager.doSuperImport();
        }
        superImport = true;
    }

    public static Object checkAssignableFrom(Object object, Class clazz) throws EvalError {
        return NameSpace.getAssignableForm(object, clazz);
    }

    static Object getAssignableForm(Object object, Class clazz) throws EvalError {
        Class clazz2;
        Class<Boolean> clazz3;
        if (clazz == null) {
            throw new InterpreterError("Null value for type in getAssignableForm");
        }
        if (object == null) {
            throw new InterpreterError("Null value in getAssignableForm.");
        }
        if (object == Primitive.VOID) {
            throw new EvalError("Undefined variable or class name");
        }
        if (object == Primitive.NULL) {
            if (!clazz.isPrimitive()) {
                return object;
            }
            throw new EvalError("Can't assign null to primitive type " + clazz.getName());
        }
        if (object instanceof Primitive) {
            clazz3 = ((Primitive)object).getType();
            clazz2 = clazz3;
            if (!clazz.isPrimitive()) {
                if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = NameSpace.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || (class$java$lang$Character == null ? (class$java$lang$Character = NameSpace.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz) || (class$java$lang$Number == null ? (class$java$lang$Number = NameSpace.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz)) {
                    object = ((Primitive)object).getValue();
                    clazz2 = object.getClass();
                } else {
                    NameSpace.assignmentError(clazz, clazz3);
                }
            }
        } else {
            clazz3 = object.getClass();
            clazz2 = clazz3;
            if (clazz.isPrimitive()) {
                if (clazz2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = NameSpace.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    object = new Primitive((Boolean)object);
                    clazz2 = Boolean.TYPE;
                } else if (clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = NameSpace.class$("java.lang.Character")) : class$java$lang$Character)) {
                    object = new Primitive((Character)object);
                    clazz2 = Character.TYPE;
                } else if ((class$java$lang$Number == null ? (class$java$lang$Number = NameSpace.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz2)) {
                    object = new Primitive((Number)object);
                    clazz2 = ((Primitive)object).getType();
                } else {
                    NameSpace.assignmentError(clazz, clazz3);
                }
            }
        }
        if (Reflect.isAssignableFrom(clazz, clazz2)) {
            return object;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = NameSpace.class$("java.lang.Short")) : class$java$lang$Short) && clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = NameSpace.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Short(((Number)object).shortValue());
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = NameSpace.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            if (clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = NameSpace.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = NameSpace.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Integer(((Number)object).intValue());
            }
            if (clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = NameSpace.class$("java.lang.Character")) : class$java$lang$Character)) {
                return new Integer(((Number)object).intValue());
            }
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = NameSpace.class$("java.lang.Long")) : class$java$lang$Long)) {
            if (clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = NameSpace.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = NameSpace.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = NameSpace.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Long(((Number)object).longValue());
            }
            if (clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = NameSpace.class$("java.lang.Character")) : class$java$lang$Character)) {
                return new Long(((Number)object).longValue());
            }
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NameSpace.class$("java.lang.Float")) : class$java$lang$Float)) {
            if (clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = NameSpace.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = NameSpace.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = NameSpace.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = NameSpace.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Float(((Number)object).floatValue());
            }
            if (clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = NameSpace.class$("java.lang.Character")) : class$java$lang$Character)) {
                return new Float(((Number)object).floatValue());
            }
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NameSpace.class$("java.lang.Double")) : class$java$lang$Double)) {
            if (clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = NameSpace.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = NameSpace.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = NameSpace.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = NameSpace.class$("java.lang.Long")) : class$java$lang$Long) || clazz2 == (class$java$lang$Float == null ? (class$java$lang$Float = NameSpace.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Double(((Number)object).doubleValue());
            }
            if (clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = NameSpace.class$("java.lang.Character")) : class$java$lang$Character)) {
                return new Double(((Number)object).doubleValue());
            }
        }
        if (Capabilities.canGenerateInterfaces() && clazz.isInterface() && object instanceof This) {
            return ((This)object).getInterface(clazz);
        }
        NameSpace.assignmentError(clazz, clazz3);
        return object;
    }

    private static void assignmentError(Class clazz, Class clazz2) throws EvalError {
        String string = Reflect.normalizeClassName(clazz);
        String string2 = Reflect.normalizeClassName(clazz2);
        throw new EvalError("Can't assign " + string2 + " to " + string);
    }

    public String toString() {
        return "NameSpace: " + (this.name == null ? super.toString() : this.name + " (" + super.toString() + ")");
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public Object invokeMethod(String string, Object[] objectArray, Interpreter interpreter) throws EvalError {
        return this.invokeMethod(string, objectArray, interpreter, null, null);
    }

    public Object invokeMethod(String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        BshMethod bshMethod;
        if (callStack == null) {
            callStack = new CallStack();
            callStack.push(this);
        }
        if ((bshMethod = this.getMethod(string, Reflect.getTypes(objectArray))) != null) {
            return bshMethod.invokeDeclaredMethod(objectArray, interpreter, callStack, simpleNode);
        }
        bshMethod = this.getMethod("invoke", new Class[]{null, null});
        if (bshMethod != null) {
            return bshMethod.invokeDeclaredMethod(new Object[]{string, objectArray}, interpreter, callStack, simpleNode);
        }
        throw new EvalError("No locally declared method: " + string + " in namespace: " + this);
    }

    public void classLoaderChanged() {
        this.nameSpaceChanged();
    }

    public void nameSpaceChanged() {
        this.classCache = null;
    }

    public void loadDefaultImports() {
        this.importClass("bsh.EvalError");
        this.importPackage("javax.swing.event");
        this.importPackage("javax.swing");
        this.importPackage("java.awt.event");
        this.importPackage("java.awt");
        this.importPackage("java.net");
        this.importPackage("java.util");
        this.importPackage("java.io");
        this.importPackage("java.lang");
    }

    Name getNameResolver(String string) {
        return new Name(this, string);
    }

    public int getInvocationLine() {
        SimpleNode simpleNode = this.getNode();
        if (simpleNode != null) {
            return simpleNode.getLineNumber();
        }
        return -1;
    }

    public String getInvocationText() {
        SimpleNode simpleNode = this.getNode();
        if (simpleNode != null) {
            return simpleNode.getText();
        }
        return "<invoked from Java code>";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TypedVariable
    implements Serializable {
        Class type;
        Object value = null;
        boolean isFinal;

        TypedVariable(Class clazz, Object object, boolean bl) throws EvalError {
            this.type = clazz;
            if (clazz == null) {
                throw new InterpreterError("null type in typed var: " + object);
            }
            this.isFinal = bl;
            this.setValue(object);
        }

        void setValue(Object object) throws EvalError {
            if (this.isFinal && this.value != null) {
                throw new EvalError("Final variable, can't assign");
            }
            if ((object = NameSpace.getAssignableForm(object, this.type)) instanceof Primitive && ((Primitive)object).isNumber()) {
                try {
                    object = BSHCastExpression.castPrimitive((Primitive)object, this.type);
                }
                catch (EvalError evalError) {
                    throw new InterpreterError("auto assignment cast failed");
                }
            }
            this.value = object;
        }

        Object getValue() {
            return this.value;
        }

        Class getType() {
            return this.type;
        }
    }
}

