//: com:bruceeckel:simpletest:SimpleTest.java
// Simple utility for testing program output. Hijacks
// System.out to print both to the console and a buffer.
package com.bruceeckel.simpletest;
import java.io.*;
import java.util.*;
import java.util.regex.*;

public class SimpleTest extends PrintStream {
  private List output =
    Collections.synchronizedList(new ArrayList());
  private PrintStream console;
  private PrintStream err;
  private String className;
  private boolean endOfLine = true;
  public SimpleTest(String cname) {
    super(System.out);
    console = System.out;
    err = System.err;
    System.setOut(this);
    System.setErr(this);
    className = cname;
  }
  public void cleanup() {
    System.setOut(console);
  }
  private void reset() {
    output.clear();
    if (!endOfLine)
      endOfLine = true;
  }
  private void addToOutput(String s) {
    if (s == null)
      s = "null";
    if (s.equals("")) {
      if (endOfLine)
        output.add(s);
      return;
    }
    StringTokenizer st = 
      new StringTokenizer(s, 
        System.getProperty("line.separator"));
    if (endOfLine)
      output.add(st.nextToken());
    else {
      String str =
        (String) output.remove(output.size() - 1);
      output.add(str.concat(st.nextToken()));
    }
    while (st.hasMoreTokens())
      output.add(st.nextToken());
  }
  public synchronized void print(boolean b) {
    console.print(b);
    addToOutput(b ? "true" : "false");
    if (endOfLine)
      endOfLine = false;
  }
  public synchronized void print(char c) {
    console.print(c);
    addToOutput(String.valueOf(c));
    if (endOfLine)
      endOfLine = false;
  }
  public synchronized void print(int i) {
    console.print(i);
    addToOutput(String.valueOf(i));
    if (endOfLine)
      endOfLine = false;
  }
  public synchronized void print(long l) {
    console.print(l);
    addToOutput(String.valueOf(l));
    if (endOfLine)
      endOfLine = false;
  }
  public synchronized void print(float f) {
    console.print(f);
    addToOutput(String.valueOf(f));
    if (endOfLine)
      endOfLine = false;
  }
  public synchronized void print(double d) {
    console.print(d);
    addToOutput(String.valueOf(d));
    if (endOfLine)
      endOfLine = false;
  }
  public synchronized void print(char[] s) {
    console.print(s);
    addToOutput(String.valueOf(s));
    if (endOfLine)
      endOfLine = false;
  }
  public synchronized void print(String s) {
    console.print(s);
    addToOutput(s);
    if (endOfLine)
      endOfLine = false;
  }
  public synchronized void print(Object obj) {
    console.print(obj);
    addToOutput(String.valueOf(obj));
    if (endOfLine)
      endOfLine = false;
  }
  public synchronized void println() {
    console.println();
    if (endOfLine)
      output.add(new String(""));
    else
      endOfLine = true;
  }
  public synchronized void println(boolean x) {
    console.println(x);
    addToOutput(x ? "true" : "false");
    if (!endOfLine)
      endOfLine = true;
  }
  public synchronized void println(char x) {
    console.println(x);
    addToOutput(String.valueOf(x));
    if (!endOfLine)
      endOfLine = true;
  }
  public synchronized void println(int x) {
    console.println(x);
    addToOutput(String.valueOf(x));
    if (!endOfLine)
      endOfLine = true;
  }
  public synchronized void println(long x) {
    console.println(x);
    addToOutput(String.valueOf(x));
    if (!endOfLine)
      endOfLine = true;
  }
  public synchronized void println(float x) {
    console.println(x);
    addToOutput(String.valueOf(x));
    if (!endOfLine)
      endOfLine = true;
  }
  public synchronized void println(double x) {
    console.println(x);
    addToOutput(String.valueOf(x));
    if (!endOfLine)
      endOfLine = true;
  }
  public synchronized void println(char[] x) {
    console.println(x);
    addToOutput(String.valueOf(x));
    if (!endOfLine)
      endOfLine = true;
  }
  public synchronized void println(String x) {
    console.println(x);
    addToOutput(x);
    if (!endOfLine)
      endOfLine = true;
  }
  public synchronized void println(Object x) {
    console.println(x);
    addToOutput(String.valueOf(x));
    if (!endOfLine)
      endOfLine = true;
  }
  // Used for test output generation
  public void expect() {
    try {
      PrintStream fout =
        new PrintStream(
          new FileOutputStream(
            new File(className + "Output.txt")));
      Iterator it = output.iterator();
      while (it.hasNext())
        fout.println(it.next());
      fout.close();
    } catch (FileNotFoundException e) {
    } finally {
      reset();
    }
  }
  public void expect(Writer w) {
    PrintWriter pw = new PrintWriter(w);
    Iterator it = output.iterator();
    while (it.hasNext())
      pw.println(it.next());
    pw.close();
    reset();
  }
  public void 
  expectRegularExpression(Object[] expectedOutput) {
    int expectedLines = 0;
    for (int i = 0; i < expectedOutput.length; i++)
      if (expectedOutput[i].getClass() == String.class)
        expectedLines++;
      else
        expectedLines
          += ((RegularExpression) expectedOutput[i])
            .getNumOfLines();
    if (expectedLines != output.size()) {
      // Test failed
      console.println("test failed!");
      throw new RuntimeException(
        "Error testing output of class "
          + className
          + ": num of lines of output and expected " 
          + "output did not match (expected:  "
          + expectedLines
          + " lines  output:  "
          + output.size()
          + " lines)");
    } else {
      int i = 0;
      Matcher m = null;
      Iterator it = output.iterator();
      while (it.hasNext()) {
        String ln = (String) it.next();
        if (expectedOutput[i].getClass() == String.class) {
          if (!expectedOutput[i].equals(ln)) {
            console.println("test failed!");
            console.println("expected:  " + "'" 
              + expectedOutput[i] + "'");
            console.println("output:  " + ln);
            throw new RuntimeException(
              "Error testing output of class "
                + className
                + ": line "
                + i
                + " of output did not match " 
                + "expected output (expected:  "
                +  expectedOutput[i]
                + "  output:  "
                + ln);
          }
        } else {
          m =
            (
              (
                RegularExpression) expectedOutput[i])
                  .getMatcher(
              ln);
          for (int j = 0;
            j
              < ((RegularExpression) expectedOutput[i])
                .getNumOfLines();
            j++) {
            if (j > 0)
              m = m.reset((String) it.next());
            if (!m.matches()) {
              console.println("test failed!");
              console.println(
                "expected:  " + m.pattern().pattern());
              console.println("output:  " + ln);
              throw new RuntimeException(
                "Error testing output of class "
                  + className
                  + ": line "
                  + i
                  + " of output did not match " 
                  + "expected output (expected:  "
                  + m.pattern().pattern()
                  + "  output:  "
                  + ln);
            }
          }
        }
        i++;
      }
      console.println("test ok");
      reset();
    }
  }
  public void expect(String[] expectedOutput) {
    if (expectedOutput.length != output.size()) {
      // Test failed
      console.println("test failed!");
      throw new RuntimeException(
        "Error testing output of class "
          + className
          + ": num of lines of output and expected " 
          + "output did not match (expected:  "
          + expectedOutput.length
          + " lines  output:  "
          + output.size()
          + " lines)");
    } else {
      int i = 0;
      Iterator it = output.iterator();
      while (it.hasNext()) {
        String ln = (String) it.next();
        if (!expectedOutput[i++].equals(ln)) {
          console.println("test failed!");
          console.println(
            "expected:  " + expectedOutput[i - 1]);
          console.println("output:  " + ln);
          throw new RuntimeException(
            "Error testing output of class "
              + className
              + ": line "
              + i
              + " of output did not match " 
              + "expected output (expected:  "
              + expectedOutput[i
              - 1]
              + "  output:  "
              + ln);
        }
      }
      console.println("test ok");
      reset();
    }
  }
  public void expectIgnoreOrder(String[] expectedOutput) {
    try {
      Thread.currentThread().sleep(500);
    } catch (InterruptedException e) {
    }
    if (expectedOutput.length != output.size()) {
      // Test failed
      console.println("test failed!");
      throw new RuntimeException(
        "Error testing output of class "
          + className
          + ": num of lines of output and " 
          + "expected output did not match (expected:  "
          + expectedOutput.length
          + " lines  output:  "
          + output.size()
          + " lines)");
    } else {
      // Sort the arrays
      Object[] out = output.toArray();
      Arrays.sort(out);
      Arrays.sort(expectedOutput);
      if (!Arrays.equals(out, expectedOutput)) {
        // Test failed
        console.println("test failed!");
        throw new RuntimeException(
          "Error testing output of class "
            + className
            + " (output:  "
            + out);
      }
      console.println("test ok");
      reset();
    }
  }
} ///:~