//: c04:Mugs.java
// Java "Instance Initialization."
import com.bruceeckel.simpletest.*;

class Mug {
  Mug(int marker) {
    System.out.println("Mug(" + marker + ")");
  }
  void f(int marker) {
    System.out.println("f(" + marker + ")");
  }
}

public class Mugs {
  Mug c1;
  Mug c2;
  {
    c1 = new Mug(1);
    c2 = new Mug(2);
    System.out.println("c1 & c2 initialized");
  }
  Mugs() {
    System.out.println("Mugs()");
  }
  public static void main(String[] args) {
    SimpleTest monitor =
      new SimpleTest("Mugs");
    System.out.println("Inside main()");
    Mugs x = new Mugs();
    monitor.expect(new String[] {
      "Inside main()",
      "Mug(1)",
      "Mug(2)",
      "c1 & c2 initialized",
      "Mugs()"
    });
  }
} ///:~