


MAKERKEY(1)         UNIX Programmer's Manual          MAKERKEY(1)



NAME
     makerkey - Make Rabin public key for "rpem"

SYNOPSIS
     makerkey [ -s privfile ] [ -b numbits ] [ -b numbits2 ] [ -g
     ] [ -u username ] [ >> modulusout ]

DESCRIPTION
     makerkey creates a public encryption key for use by the rpem
     privacy-enhanced mail system.  Both the private and public
     components of the public key are created.  The private com-
     ponent consists of two prime numbers; the public component
     consists of the product of these two primes.  The private
     and public components are encoded into printable format and
     are written out to two separate files.  The private com-
     ponent is optionally encrypted for security reasons.

     The public component is identified with the user's elec-
     tronic mail address and is suitable for inclusion in a
     system-wide directory of rpem keys.

OPTIONS
     -s   ("secret") specifies the filename into which the two
          primes should be placed.  This is the private component
          of the key.  If -s is not specified, the value of the
          environment variable RABIN PQ FILE is used.  If this
          variable is not defined, the file ~/.rabinkey is used
          for Unix, or RABINKEY for MS-DOS.

     -b   ("bits") specifies the number of bits desired in the
          primes.  May be specified twice--once for p and once
          for q.  If specified only once, that number of bits
          will be used for p and a slightly larger (random)
          number of bits will be used for q.  If not specified, p
          defaults to 100 bits for performance reasons; if you're
          serious about security, pick a number > 330.

          Warning:  RFC 1114 specifies a minimum modulus size
          (sum of bit sizes of the two primes) of 512 bits for
          the RSA system.  Similar guidelines should probably
          apply to the Rabin system.  Because the Rabin system is
          rather slow, a smaller default has been chosen.

     -g   ("garble") means that the primes in the output file are
          encrypted.  If specified, the program will prompt for
          the encryption key.  The NEWDES algorithm (Robert
          Scott, Cryptologia, Jan 1985) is used.

     -n   ("no prompt") means do not prompt the user for a
          pseudo-random seed, but instead rely solely on system-
          dependent information gathered by the program (such as
          the time of day) to generate the primes.  The default
          is to prompt the user for a string as well as use
          system-dependent information.

     -u   ("username") specifies the username to use in the
          modulus output file.  Default under Unix is your
          userid@hostname.  Default under MSDOS is the value of
          the environment variable USER NAME; if that does not
          exist, "me" is used.

AUTHOR
     Mark Riordan, riordanmr@clvax1.cl.msu.edu.

     Other contributors:

     Arjen Lenstra   lenstra@flash.bellcore.com      Wrote the
     multiple-precision integer package used here.

     Marc Ringuette  mnr+@cs.cmu.edu      Wrote miscellaneous
     large integer routines, provided ideas.






















































