# -*- Shell-script -*-
%define rel    1
%define prefix /usr

Summary: GNU mail utilities
Name: mailutils
Version: 0.3.1
Release: %rel
Copyright: GPL
Source: ftp://ftp.gnu.org/pub/%{name}/%{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
URL: http://www.gnu.org/software/%{name}/%{name}.html
Group: Development/Libraries

%description
GNU mail utilities

%package -n libmailbox
Summary: GNU mail utilities mailbox access library
Copyright: LGPL
Group: Development/Libraries

%description -n libmailbox
The runtime library libmailbox. This library contains various mailbox
access routines and support for a number of mailbox types, such as
mbox, mh, POP3, and IMAP4. It also support mime message handling,
and sending mail via SMTP and /sbin/sendmail.

%package -n libmailbox-dev
Summary: GNU mail utilities mailbox access library development
Copyright: LGPL
Requires: libmailbox
Group: Development/Libraries

%description -n libmailbox-dev
The static library and header files for libmailbox. API documentation
is in %{name}-doc.

%package doc
Summary: GNU mail utitlies documentation
Prereq: /sbin/install-info
Group: Development/Libraries

%description doc
API reference for libmailbox and user documentation for the rest of
the GNU mail utilities.

%package -n gnu-mail
Summary: GNU mail utilties mail(x) replacement
Requires: libmailbox
Group: Console/Mail

%description -n gnu-mail
A replacement for /bin/mail(x) conforming to the UNIX98 specification
for mailx.

%package -n gnu-pop3d
Summary: GNU mail utilites POP3 daemon
Requires: libmailbox
Group: Networking/Daemons

%description -n gnu-pop3d
The GNU POP3 daemon. Uses libmailbox to support different styles of
mailboxes.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
make

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install-strip
gzip -9n $RPM_BUILD_ROOT%{prefix}/info/*

%clean
rm -rf $RPM_BUILD_ROOT

%post -n libmailbox -p /sbin/ldconfig

%postun -n libmailbox -p /sbin/ldconfig

%post doc
/sbin/install-info %{prefix}/info/mailutils.info.gz %{prefix}/info/dir

%preun doc
/sbin/install-info --delete %{prefix}/info/mailutils.info.gz \
    %{prefix}/info/dif

%files -n libmailbox
%defattr(-, root, root)
%{prefix}/lib/libmailbox.so.*

%files -n libmailbox-dev
%defattr(-, root, root)
%{prefix}/lib/lib*.so
%{prefix}/lib/*a

%files doc
%defattr(-, root, root)
%doc AUTHORS COPYING COPYING.LIB COPYING.FDL ChangeLog NEWS README THANKS TODO
%{prefix}/info/*

%files -n gnu-mail
%defattr(-, root, root)
%{prefix}/bin/mail

%files -n gnu-pop3d
%defattr(-, root, root)
%{prefix}/sbin/pop3d

