
/*  A Bison parser, made from msgset.y
 by  GNU Bison version 1.27
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	TYPE	257
#define	IDENT	258
#define	REGEXP	259
#define	HEADER	260
#define	BODY	261
#define	NUMBER	262

#line 18 "msgset.y"

#include "mail.h"

#include <stdio.h>
#include <stdlib.h>

#include <xalloc.h>

/* Defined in <limits.h> on some systems, but redefined in <regex.h>
   if we are using GNU's regex. So, undef it to avoid duplicate definition
   warnings. */

#ifdef RE_DUP_MAX
# undef RE_DUP_MAX
#endif
#include <regex.h>

struct header_data
{
  char *header;
  char *expr;
};

static msgset_t *msgset_select __P ((int (*sel) __P ((message_t, void *)),
				     void *closure, int rev,
				     unsigned int max_matches));
static int select_header __P ((message_t msg, void *closure));
static int select_body __P ((message_t msg, void *closure));
static int select_type __P ((message_t msg, void *closure));
static int select_sender __P ((message_t msg, void *closure));
static int select_deleted __P ((message_t msg, void *closure));

int yyerror __P ((const char *));
int yylex  __P ((void));

static msgset_t *result;

#line 56 "msgset.y"
typedef union {
  char *string;
  int number;
  int type;
  msgset_t *mset;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		48
#define	YYFLAG		-32768
#define	YYNTBASE	23

#define YYTRANSLATE(x) ((unsigned)(x) <= 262 ? yytranslate[x] : 33)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    18,     2,     2,    11,     2,     2,     2,    21,
    22,    12,    14,    15,    13,     9,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    19,     2,    20,    10,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    16,     2,    17,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     3,     5,     7,     9,    11,    13,    15,    17,
    21,    24,    26,    30,    33,    35,    40,    42,    45,    47,
    49,    51,    52,    54,    56,    60,    63,    65,    69,    73,
    75,    80,    82
};

static const short yyrhs[] = {    -1,
     9,     0,    24,     0,    10,     0,    11,     0,    12,     0,
    13,     0,    14,     0,    25,     0,    24,    15,    25,     0,
    24,    25,     0,    26,     0,    16,    24,    17,     0,    18,
    25,     0,    27,     0,    27,    19,    29,    20,     0,    30,
     0,    28,     5,     0,     7,     0,     3,     0,     4,     0,
     0,     6,     0,    30,     0,    29,    15,    30,     0,    29,
    30,     0,    31,     0,     8,    13,    31,     0,     8,    13,
    12,     0,    32,     0,    32,    19,    29,    20,     0,     8,
     0,    21,    29,    22,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    71,    75,    79,    83,    87,    91,    95,    99,   105,   106,
   110,   116,   117,   121,   127,   128,   134,   137,   147,   151,
   160,   167,   171,   177,   178,   182,   188,   189,   203,   209,
   210,   218,   222
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","TYPE","IDENT",
"REGEXP","HEADER","BODY","NUMBER","'.'","'^'","'$'","'*'","'-'","'+'","','",
"'{'","'}'","'!'","'['","']'","'('","')'","input","msgset","msgexpr","msgspec",
"msg","header","rangeset","range","number","partno", NULL
};
#endif

static const short yyr1[] = {     0,
    23,    23,    23,    23,    23,    23,    23,    23,    24,    24,
    24,    25,    25,    25,    26,    26,    26,    27,    27,    27,
    27,    28,    28,    29,    29,    29,    30,    30,    30,    31,
    31,    32,    32
};

static const short yyr2[] = {     0,
     0,     1,     1,     1,     1,     1,     1,     1,     1,     3,
     2,     1,     3,     2,     1,     4,     1,     2,     1,     1,
     1,     0,     1,     1,     3,     2,     1,     3,     3,     1,
     4,     1,     3
};

static const short yydefact[] = {     1,
    20,    21,    23,    19,    32,     2,     4,     5,     6,     7,
     8,    22,    22,     0,     3,     9,    12,    15,     0,    17,
    27,    30,     0,    22,    14,     0,    24,    22,    11,     0,
    18,     0,    32,    29,    28,    13,     0,    33,    26,    10,
     0,     0,    25,    16,    31,     0,     0,     0
};

static const short yydefgoto[] = {    46,
    15,    16,    17,    18,    19,    26,    20,    21,    22
};

static const short yypact[] = {    26,
-32768,-32768,-32768,-32768,   -12,-32768,-32768,-32768,-32768,-32768,
-32768,    48,    48,     0,    -1,-32768,-32768,   -10,     5,-32768,
-32768,     6,    71,    42,-32768,    53,-32768,    48,-32768,     0,
-32768,     0,-32768,-32768,-32768,-32768,     0,-32768,-32768,-32768,
    57,    65,-32768,-32768,-32768,    19,    24,-32768
};

static const short yypgoto[] = {-32768,
    41,    -2,-32768,-32768,-32768,    11,   -14,    39,-32768
};


#define	YYLAST		92


static const short yytable[] = {    27,
    23,     1,     2,   -22,     3,     4,     5,     5,    30,    31,
    25,    39,    29,    28,    12,    27,    13,    27,    47,    14,
    14,    29,    43,    48,    32,    40,    39,    39,     1,     2,
   -22,     3,     4,     5,     6,     7,     8,     9,    10,    11,
    41,    12,    42,    13,     1,     2,    14,     3,     4,     5,
     1,     2,    24,     3,     4,     5,    28,    12,    36,    13,
     5,    35,    14,    12,     5,    13,     0,    37,    14,     0,
     0,    37,     5,    14,    38,     0,    44,    14,    33,    37,
     0,     0,    34,     0,    45,    14,     0,     0,     0,     0,
     0,    14
};

static const short yycheck[] = {    14,
    13,     3,     4,     5,     6,     7,     8,     8,    19,     5,
    13,    26,    15,    15,    16,    30,    18,    32,     0,    21,
    21,    24,    37,     0,    19,    28,    41,    42,     3,     4,
     5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
    30,    16,    32,    18,     3,     4,    21,     6,     7,     8,
     3,     4,    12,     6,     7,     8,    15,    16,    17,    18,
     8,    23,    21,    16,     8,    18,    -1,    15,    21,    -1,
    -1,    15,     8,    21,    22,    -1,    20,    21,     8,    15,
    -1,    -1,    12,    -1,    20,    21,    -1,    -1,    -1,    -1,
    -1,    21
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.27.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 216 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 72 "msgset.y"
{
	     result = msgset_make_1 (cursor);
	   ;
    break;}
case 2:
#line 76 "msgset.y"
{
	     result = msgset_make_1 (cursor);
	   ;
    break;}
case 3:
#line 80 "msgset.y"
{
	     result = yyvsp[0].mset;
	   ;
    break;}
case 4:
#line 84 "msgset.y"
{
	     result = msgset_select (select_deleted, NULL, 0, 1);
	   ;
    break;}
case 5:
#line 88 "msgset.y"
{
	     result = msgset_select (select_deleted, NULL, 1, 1);
	   ;
    break;}
case 6:
#line 92 "msgset.y"
{
	     result = msgset_range (1, total);
	   ;
    break;}
case 7:
#line 96 "msgset.y"
{
	     result = msgset_select (select_deleted, NULL, 1, 1);
	   ;
    break;}
case 8:
#line 100 "msgset.y"
{
	     result = msgset_select (select_deleted, NULL, 0, 1);
	   ;
    break;}
case 10:
#line 107 "msgset.y"
{
	     yyval.mset = msgset_append (yyvsp[-2].mset, yyvsp[0].mset);
	   ;
    break;}
case 11:
#line 111 "msgset.y"
{
	     yyval.mset = msgset_append (yyvsp[-1].mset, yyvsp[0].mset);
	   ;
    break;}
case 13:
#line 118 "msgset.y"
{
	     yyval.mset = yyvsp[-1].mset;
	   ;
    break;}
case 14:
#line 122 "msgset.y"
{
	     yyval.mset = msgset_negate (yyvsp[0].mset);
	   ;
    break;}
case 16:
#line 129 "msgset.y"
{
	     yyval.mset = msgset_expand (yyvsp[-3].mset, yyvsp[-1].mset);
	     msgset_free (yyvsp[-3].mset);
	     msgset_free (yyvsp[-1].mset);
	   ;
    break;}
case 18:
#line 138 "msgset.y"
{
	     struct header_data hd;
	     hd.header = yyvsp[-1].string;
	     hd.expr   = yyvsp[0].string;
	     yyval.mset = msgset_select (select_header, &hd, 0, 0);
	     if (yyvsp[-1].string)
	       free (yyvsp[-1].string);
	     free (yyvsp[0].string);
	   ;
    break;}
case 19:
#line 148 "msgset.y"
{
	     yyval.mset = msgset_select (select_body, yyvsp[0].string, 0, 0);
	   ;
    break;}
case 20:
#line 152 "msgset.y"
{
	     if (strchr ("dnorTtu", yyvsp[0].type) == NULL)
	       {
		 yyerror ("unknown message type");
		 YYERROR;
	       }
	     yyval.mset = msgset_select (select_type, (void *)&yyvsp[0].type, 0, 0);
	   ;
    break;}
case 21:
#line 161 "msgset.y"
{
	     yyval.mset = msgset_select (select_sender, (void *)yyvsp[0].string, 0, 0);
	     free (yyvsp[0].string);
	   ;
    break;}
case 22:
#line 168 "msgset.y"
{
	     yyval.string = NULL;
	   ;
    break;}
case 23:
#line 172 "msgset.y"
{
	     yyval.string = yyvsp[0].string;
	   ;
    break;}
case 25:
#line 179 "msgset.y"
{
	     yyval.mset = msgset_append (yyvsp[-2].mset, yyvsp[0].mset);
	   ;
    break;}
case 26:
#line 183 "msgset.y"
{
	     yyval.mset = msgset_append (yyvsp[-1].mset, yyvsp[0].mset);
	   ;
    break;}
case 28:
#line 190 "msgset.y"
{
	     if (yyvsp[0].mset->npart == 1)
	       {
		 yyval.mset = msgset_range (yyvsp[-2].number, yyvsp[0].mset->msg_part[0]);
	       }
	     else
	       {
		 yyval.mset = msgset_range (yyvsp[-2].number, yyvsp[0].mset->msg_part[0]-1);
		 if (!yyval.mset)
		   YYERROR;
		 msgset_append (yyval.mset, yyvsp[0].mset);
	       }
	   ;
    break;}
case 29:
#line 204 "msgset.y"
{
	     yyval.mset = msgset_range (yyvsp[-2].number, total);
	   ;
    break;}
case 31:
#line 211 "msgset.y"
{
	     yyval.mset = msgset_expand (yyvsp[-3].mset, yyvsp[-1].mset);
	     msgset_free (yyvsp[-3].mset);
	     msgset_free (yyvsp[-1].mset);
	   ;
    break;}
case 32:
#line 219 "msgset.y"
{
	     yyval.mset = msgset_make_1 (yyvsp[0].number);
	   ;
    break;}
case 33:
#line 223 "msgset.y"
{
	     yyval.mset = yyvsp[-1].mset;
	   ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 542 "/usr/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 227 "msgset.y"


static int xargc;
static char **xargv;
static int cur_ind;
static char *cur_p;

int
yyerror (const char *s)
{
  fprintf (stderr, "%s: ", xargv[0]);
  fprintf (stderr, "%s", s);
  if (!cur_p)
    fprintf (stderr, " near end");
  else if (*cur_p == 0)
    {
      int i =  (*cur_p == 0) ? cur_ind + 1 : cur_ind;
      if (i == xargc)
	fprintf (stderr, " near end");
      else
	fprintf (stderr, " near %s", xargv[i]);
    }
  else
    fprintf (stderr, " near %s", cur_p);
  fprintf (stderr, "\n");
  return 0;
}

int
yylex()
{
  if (cur_ind == xargc)
    return 0;
  if (!cur_p)
    cur_p = xargv[cur_ind];
  if (*cur_p == 0)
    {
      cur_ind++;
      cur_p = NULL;
      return yylex ();
    }

  if (isdigit (*cur_p))
    {
      yylval.number = strtoul (cur_p, &cur_p, 10);
      return NUMBER;
    }

  if (isalpha (*cur_p))
    {
      char *p = cur_p;
      int len;

      while (*cur_p && *cur_p != ',' && *cur_p != ':') 
	cur_p++;
      len = cur_p - p + 1;
      yylval.string = xmalloc (len);
      memcpy (yylval.string, p, len-1);
      yylval.string[len-1] = 0;
      if (*cur_p == ':')
	{
	  ++cur_p;
	  return HEADER;
	}
      return IDENT;
    }

  if (*cur_p == '/')
    {
      char *p = ++cur_p;
      int len;

      while (*cur_p && *cur_p != '/')
	cur_p++;
      len = cur_p - p + 1;
      cur_p++;
      yylval.string = xmalloc (len);
      memcpy (yylval.string, p, len-1);
      yylval.string[len-1] = 0;
      return REGEXP;
    }

  if (*cur_p == ':')
    {
      cur_p++;
      if (*cur_p == '/')
	{
	  char *p = ++cur_p;
	  int len;

	  while (*cur_p && *cur_p != '/')
	    cur_p++;
	  len = cur_p - p + 1;
	  cur_p++;
	  yylval.string = xmalloc (len);
	  memcpy (yylval.string, p, len-1);
	  yylval.string[len-1] = 0;
	  return BODY;
	}
      yylval.type = *cur_p++;
      return TYPE;
    }

  return *cur_p++;
}

int
msgset_parse (const int argc, char **argv, msgset_t **mset)
{
  int rc;
  xargc = argc;
  xargv = argv;
  cur_ind = 1;
  cur_p = NULL;
  result = NULL;
  rc = yyparse ();
  if (rc == 0)
    *mset = result;
  return rc;
}

void
msgset_free (msgset_t *msg_set)
{
  msgset_t *next;

  if (!msg_set)
    return;
  while (msg_set)
    {
      next = msg_set->next;
      if (msg_set->msg_part)
	free (msg_set->msg_part);
      free (msg_set);
      msg_set = next;
    }
}

/* Create a message set consisting of a single msg_num and no subparts */
msgset_t *
msgset_make_1 (int number)
{
  msgset_t *mp;

  mp = xmalloc (sizeof (*mp));
  mp->next = NULL;
  mp->npart = 1;
  mp->msg_part = xmalloc (sizeof mp->msg_part[0]);
  mp->msg_part[0] = number;
  return mp;
}

msgset_t *
msgset_dup (const msgset_t *set)
{
  msgset_t *mp;
  mp = xmalloc (sizeof (*mp));
  mp->next = NULL;
  mp->npart = set->npart;
  mp->msg_part = xcalloc (mp->npart, sizeof mp->msg_part[0]);
  memcpy (mp->msg_part, set->msg_part, mp->npart * sizeof mp->msg_part[0]);
  return mp;
}

msgset_t *
msgset_append (msgset_t *one, msgset_t *two)
{
  msgset_t *last;

  if (!one)
    return two;
  for (last = one; last->next; last = last->next)
    ;
  last->next = two;
  return one;
}

int
msgset_member (msgset_t *set, size_t n)
{
  for (; set; set = set->next)
    if (set->msg_part[0] == n)
      return 1;
  return 0;
}

msgset_t *
msgset_negate (msgset_t *set)
{
  size_t i;
  msgset_t *first = NULL, *last = NULL;

  for (i = 1; i < total; i++)
    {
      if (!msgset_member (set, i))
	{
	  msgset_t *mp = msgset_make_1 (i);
	  if (!first)
	    first = mp;
	  else
	    last->next = mp;
	  last = mp;
	}
    }
  return first;
}

msgset_t *
msgset_range (int low, int high)
{
  int i;
  msgset_t *mp, *first = NULL, *last = NULL;

  if (low == high)
    return msgset_make_1 (low);

  if (low >= high)
    {
      yyerror ("range error");
      return NULL;
    }

  for (i = 0; low <= high; i++, low++)
    {
      mp = msgset_make_1 (low);
      if (!first)
	first = mp;
      else
	last->next = mp;
      last = mp;
    }
  return first;
}

msgset_t *
msgset_expand (msgset_t *set, msgset_t *expand_by)
{
  msgset_t *i, *j;
  msgset_t *first = NULL, *last = NULL, *mp;

  for (i = set; i; i = i->next)
    for (j = expand_by; j; j = j->next)
      {
	mp = xmalloc (sizeof *mp);
	mp->next = NULL;
	mp->npart = i->npart + j->npart;
	mp->msg_part = xcalloc (mp->npart, sizeof mp->msg_part[0]);
	memcpy (mp->msg_part, i->msg_part, i->npart * sizeof i->msg_part[0]);
	memcpy (mp->msg_part + i->npart, j->msg_part,
		j->npart * sizeof j->msg_part[0]);

	if (!first)
	  first = mp;
	else
	  last->next = mp;
	last = mp;
      }
  return first;
}

msgset_t *
msgset_select (int (*sel) __P ((message_t, void *)), void *closure, int rev,
	       unsigned int max_matches)
{
  size_t i, match_count = 0;
  msgset_t *first = NULL, *last = NULL, *mp;
  message_t msg = NULL;

  if (max_matches == 0)
    max_matches = total;

  if (rev)
    {
      for (i = total; i > 0; i--)
	{
	  mailbox_get_message (mbox, i, &msg);
	  if ((*sel)(msg, closure))
	    {
	      mp = msgset_make_1 (i);
	      if (!first)
		first = mp;
	      else
		last->next = mp;
	      last = mp;
	      if (++match_count == max_matches)
		break;
	    }
	}
    }
  else
    {
      for (i = 1; i <= total; i++)
	{
	  mailbox_get_message (mbox, i, &msg);
	  if ((*sel)(msg, closure))
	    {
	      mp = msgset_make_1 (i);
	      if (!first)
		first = mp;
	      else
		last->next = mp;
	      last = mp;
	      if (++match_count == max_matches)
		break;
	    }
	}
    }
  return first;
}

int
select_header (message_t msg, void *closure)
{
  struct header_data *hd = (struct header_data *)closure;
  header_t hdr;
  char *contents;
  const char *header = hd->header ? hd->header : MU_HEADER_SUBJECT;

  message_get_header (msg, &hdr);
  if (header_aget_value (hdr, header, &contents) == 0)
    {
      if (util_getenv (NULL, "regex", Mail_env_boolean, 0) == 0)
	{
	  /* Match string against the extended regular expression(ignoring
	     case) in pattern, treating errors as no match.
	     Return 1 for match, 0 for no match.
	  */
          regex_t re;
          int status;
	  int flags = REG_EXTENDED;

	  if (islower (header[0]))
	    flags |= REG_ICASE;
          if (regcomp (&re, hd->expr, flags) != 0)
	    {
	      free (contents);
	      return 0;
	    }
          status = regexec (&re, contents, 0, NULL, 0);
          free (contents);
	  regfree (&re);
          return status == 0;
	}
      else
	{
	  int rc;
	  util_strupper (contents);
	  rc = strstr (contents, hd->expr) != NULL;
	  free (contents);
	  return rc;
	}
    }
  return 0;
}

int
select_body (message_t msg, void *closure)
{
  char *expr = closure;
  int noregex = util_getenv (NULL, "regex", Mail_env_boolean, 0);
  regex_t re;
  int status;
  body_t body = NULL;
  stream_t stream = NULL;
  size_t size = 0, lines = 0;
  char buffer[128];
  size_t n = 0;
  off_t offset = 0;

  if (noregex)
    util_strupper (expr);
  else if (regcomp (&re, expr, REG_EXTENDED | REG_ICASE) != 0)
    return 0;

  message_get_body (msg, &body);
  body_size (body, &size);
  body_lines (body, &lines);
  body_get_stream (body, &stream);
  status = 0;
  while (status == 0
	 && stream_readline (stream, buffer, sizeof(buffer)-1, offset, &n) == 0
	 && n > 0)
    {
      offset += n;
      if (noregex)
	{
	  util_strupper (buffer);
	  status = strstr (buffer, expr) != NULL;
	}
      else
	status = regexec (&re, buffer, 0, NULL, 0);
    }

  if (!noregex)
    regfree (&re);

  return status;
}

int
select_sender (message_t msg, void *closure)
{
  /* char *sender = (char*) closure; */
  /* FIXME: all messages from sender argv[i] */
  /* Annoying we can use address_create() for that
     but to compare against what? The email ?  */
  (void)msg; (void)closure;
  return 0;
}

int
select_type (message_t msg, void *closure)
{
  int type = *(int*) closure;
  attribute_t attr= NULL;

  message_get_attribute (msg, &attr);

  switch (type)
    {
    case 'd':
      return attribute_is_deleted (attr);
    case 'n':
      return attribute_is_recent (attr);
    case 'o':
      return attribute_is_seen (attr);
    case 'r':
      return attribute_is_read (attr);
    case 'u':
      return !attribute_is_read (attr);
    case 't':
      return attribute_is_userflag (attr, MAIL_ATTRIBUTE_TAGGED);
    case 'T':
      return !attribute_is_userflag (attr, MAIL_ATTRIBUTE_TAGGED);
    }
  return 0;
}

int
select_deleted (message_t msg, void *closure)
{
  attribute_t attr= NULL;
  int rc;

  (void)closure;
  message_get_attribute (msg, &attr);
  rc = attribute_is_deleted (attr);
  return strcmp (xargv[0], "undelete") == 0 ? rc : !rc;
}

#if 0
void
msgset_print (msgset_t *mset)
{
  int i;
  printf ("(");
  printf ("%d .", mset->msg_part[0]);
  for (i = 1; i < mset->npart; i++)
    {
      printf (" %d", mset->msg_part[i]);
    }
  printf (")\n");
}

int
main(int argc, char **argv)
{
  msgset_t *mset = NULL;
  int rc = msgset_parse (argc, argv, &mset);

  for (; mset; mset = mset->next)
    msgset_print (mset);
  return 0;
}
#endif
