
;;; weblint.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: weblint.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Calls the Perl script weblint (not written by me)
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:


(defvar weblint--bufname "*weblint*")

(defun weblint (directory)
  (interactive "DEnter dir: ")

  (let ((go-deep (y-or-n-p "Go deep? ")))
    (if (get-buffer weblint--bufname)
        (kill-buffer weblint--bufname))

    (let ((default-directory directory))

      (shell-command (concat "perl ~/dlisp/weblint " (if go-deep "." "*.html")))
      (switch-to-buffer "*Shell Command Output*")
      (goto-char (point-min))

      (progn
        (flush-lines "extended markup")
        (flush-lines "text/css")
        (flush-lines "as an anchor")
        (flush-lines "empty container element")
        (flush-lines "illegal context for <LI>")
        (flush-lines "outer tags should be <HTML>")
        (flush-lines "unknown attribute \"TYPE\" for element <script>")
        (flush-lines "illegal value for TYPE attribute of script (text/javascript)")
        (flush-lines "<SCRIPT> cannot appear in the HEAD element.")
        (flush-lines "expected tag(s) not seen: HEAD TITLE BODY")
        (flush-lines "illegal value for TYPE attribute of ul (disk)")
        (flush-lines "illegal value for BGCOLOR attribute of td")
        )

      (when prefs-home-emacs-p
        (flush-lines "IMG does not have ALT text defined.")
        ;;(flush-lines "The HTML spec. recommends the TITLE be no longer than 64 characters.")
        )

      (let ((zero-buffer-size (= 0 (buffer-size))))
        (insert "*** weblint for buffer " directory (if go-deep ", deep" ", shallow") "\n")
        (insert "\n")
        (if zero-buffer-size
            (insert "*** no errors\n")))

      (compilation-mode)
      (read-only-mode -1)
      (delete-other-windows)
      (rename-buffer weblint--bufname)
      (message "weblint done")
      )
    )
  )

;;; downloaded from
;;;
;;;  http://ftp.akopia.com/minivend3/unsupported/weblint
;;;

(provide 'weblint)
;;; weblint.el ends here
