
;;; d-movement-advice.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-movement-advice.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: advice for various functions regarding d-movement--unpad-buffer and d-movement--pad-buffer
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defadvice save-buffer (around d-movement activate)
  ;;(d-foo)
  (if (d-movement--is-correct-mode)
      (let ((ro  buffer-read-only)
            (c   (current-column))
            (m   (point-marker)))
        (setq buffer-read-only nil)
        (d-movement--unpad-buffer)
        (goto-char (marker-position m))
        ad-do-it
        (d-movement--pad-buffer)
        (d-movement--munge-line)
        (goto-char (marker-position m))
        (set-marker m nil)
        (move-to-column c)
        (set-buffer-modified-p nil)
        (setq buffer-read-only ro))
    ad-do-it))

;;;
;;; NOTE: why is saveplace not executed when you save a file?
;;;

(defadvice kill-line (around d-movement activate)
  (if (d-movement--is-correct-mode)
      (d-movement--unpad-line-slow))
  ad-do-it
  (if (d-movement--is-correct-mode)
      (d-movement--pad-line-fast)))

;;(defadvice yank (after d-movement activate)
;;  (when (d-movement--is-correct-mode)
;;    ;;(d-movement--unpad-buffer)
;;    ;;(d-movement--pad-buffer)
;;    ))
;;
(defadvice d-compilation-finish-function (after d-movement activate)
  ;;(d-movement--unpad-buffer)
  ;;(d-movement--pad-buffer)
  )

(defadvice indent-sexp (around d-movement activate)
  (if (d-movement--is-correct-mode)
      (d-movement--unpad-buffer))
  ad-do-it
  (if (d-movement--is-correct-mode)
      (d-movement--pad-buffer)))

(defadvice c-indent-exp (around d-movement activate)
  (if (d-movement--is-correct-mode)
      (d-movement--unpad-buffer))
  ad-do-it
  (if (d-movement--is-correct-mode)
      (d-movement--pad-buffer)))

(defadvice d-cc--comment-region (around d-movement activate)
  ;;(when (d-movement--is-correct-mode)
  ;;  (d-movement--unpad-buffer))
  ad-do-it
  (when (d-movement--is-correct-mode)
    (d-movement--unpad-buffer)
    (d-movement--pad-buffer)
    (if (eq major-mode 'jtw-mode)
        (jtw--meta-control-backslash)
      )
    )
  )

(defadvice query-replace (around d-movement activate)
  (if (d-movement--is-correct-mode)
      (d-movement--unpad-buffer))
  ad-do-it
  (if (d-movement--is-correct-mode)
      (d-movement--pad-buffer)))

(defadvice query-replace-regexp (around d-movement activate)
  (if (d-movement--is-correct-mode)
      (d-movement--unpad-buffer))
  ad-do-it
  (if (d-movement--is-correct-mode)
      (d-movement--pad-buffer)))

(defadvice d-html--meta-control-backslash (around d-movement activate)
  (if (d-movement--is-correct-mode)
      (d-movement--unpad-buffer))
  ad-do-it
  (if (d-movement--is-correct-mode)
      (d-movement--pad-buffer)))

(defadvice d-recenter (after d-movement activate)
  (when (d-movement--is-correct-mode)
    (let ((c (current-column)))
      (d-movement--unpad-buffer)
      (d-movement--pad-buffer)
      (move-to-column c)
      ))
  (when (not (memq 'd-movement--post-command-hook post-command-hook))
    (d-beeps "*** Warning post-command-hook missing d-movement--post-command-hook")
    (add-hook 'post-command-hook d-movement--pad-buffer 'd-movement--post-command-hook))
  )

(defadvice d-html-meta-control-backslash (after d-movement activate)
  (when (d-movement--is-correct-mode)
    (let ((c (current-column)))
      (d-movement--unpad-buffer)
      (d-movement--pad-buffer)
      (move-to-column c)
      ))
  )

(defadvice occur (after d-movement activate)
  ;;(d-foo)
  ;;(message "current-buffer=%s" (current-buffer))

  (save-excursion
    (when (get-buffer "*Occur*")
      (set-buffer "*Occur*")
      (d-movement--unpad-buffer)
      (d-movement--pad-buffer)
      )
    ))

;; (setq post-command-hook (remq 'd-movement--post-command-hook post-command-hook))

;;(defadvice d-html--tab-key (after d-movement activate)
;;  (if (> (current-column) 100)
;;      (beginning-of-line)))
;;
;;;
;;; Replaced with d-movement--post-command-hook
;;;
;;(defadvice dabbrev-expand (after d-movement activate)
;;  (if (d-movement--is-correct-mode)
;;      (d-movement--munge-line)))
;;
;;;
;;; Replaced with d-movement--post-command-hook
;;;
;;(defadvice yank (after d-movement activate)
;;  (if (d-movement--is-correct-mode)
;;      (d-movement--munge-line)))
;;;
;;; Replaced with d-movement--string-rectangle that calls string-rectangle interactively
;;;
;;(defadvice string-rectangle (around d-movement (start end string) activate)
;;  (interactive "*r\nsString rectangle: ")
;;  (d-movement--unpad-buffer)
;;  ad-do-it
;;  (d-movement--pad-buffer))

(defun d-movement--string-rectangle ()
  (interactive)
  (if (d-movement--is-correct-mode)
      (d-movement--unpad-buffer))
  (call-interactively 'string-rectangle)
  (if (d-movement--is-correct-mode)
      (d-movement--pad-buffer))
  )

(global-set-key "\C-xrt" 'd-movement--string-rectangle)

(defadvice d-log--generate-browser (after d-movement activate)
  (read-only-mode -1)
  (d-movement--unpad-buffer)
  (d-movement--pad-buffer)
  (read-only-mode 1))

(defadvice d-latex--meta-control-backslash (around d-movement activate)
  (d-movement--unpad-buffer)
  ad-do-it
  (d-movement--pad-buffer))

(defadvice d-meta-f1 (around d-movement activate)
  (d-movement--unpad-buffer)
  ad-do-it
  (d-movement--pad-buffer))

(provide 'd-movement-advice)
