;;; duplicate-files.el

;; Copyright (C) 2006-2016 Davin Pearson

;; Author/Maintainer: Davin Max Pearson <davin.pearson@gmail.com>
;; Version: 1.17
;; Package-Requires: ()
;; Keywords: Duplicate files
;; URL: http://davin.50webs.com/research/2006/mopa2e.html#duplicate-files

;;; Commentary:

;; This file is not part of GNU Emacs.

;; This file copies files from ~/bak to g:/home/bak and h:/home/bak

;;; m4_limitation_of_warranty

;;; m4_install_instructions(duplicate-files)

;;; Known Bugs:

;; None!

;;; Code:

;; (setq source-dir "~/bak/")
;; (setq destination-dir "/media/www/C1TB/home/bak/")
;; (setq destination-dir "/media/www/F2TB/home/bak/")
;; (setq extension ".tar.gz")
;; (setq d-message-on t)
(defun duplicate-files-inner (source-dir destination-dir extension)
  ;;(let (list1 ptr list2 ptr2 rqe (d-message-on t))
  (progn
    (cull-same-dates-dir-plus-extension destination-dir extension)
    (message "cull-same-dates destination-dir=%s" destination-dir)
    (cull-size-quota-dir-plus-extension destination-dir extension)
    (message "cull-size-quota-dir-plus-extension destination-dir=%s extension=%s" destination-dir extension)
    (assert (or (string= ".tar.gz" extension)
                (string= ".tar" extension)
                (string= ".zip" extension)))
    (setq rqe (concat (regexp-quote extension) "$"))
    (message "source-dir=%s destination-dir=%s" source-dir destination-dir)
    (sit-for 1)
    (setq list1 (directory-files source-dir nil rqe t))
    (setq list1 (sort list1 'string<-ignore-case))
    (setq ptr list1)
    (while ptr                 ;;;          Y    Y    Y    Y    M    M    D    D     h    h    m    m    s    s
      (when (string-match (concat "^\\(.*\\)[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9][0-9][0-9]" rqe) (car ptr))
        (setcar ptr (substring (car ptr) (match-beginning 1) (match-end 1))))
      (setq ptr (cdr ptr)))
    (setq list1 (delete-duplicates list1 :test 'string=))
    (setq ptr list1)
    (while ptr
      ;;(debug "schmu")
      (setq list2 (directory-files source-dir nil (concat "^" (regexp-quote (car ptr)) ".*" rqe) t))
      (setq list2 (sort list2 'string<-ignore-case))
      (setq ptr2 list2)
      (while ptr2
        (when (not (file-exists-p (concat destination-dir (car ptr2))))
          (copy-file (concat source-dir (car ptr2)) (concat destination-dir (car ptr2)) 'OK-IF-ALREADY-EXISTS 'KEEP-TIME)
          (message "copying file %s -> %s" (concat source-dir (car ptr2)) (concat destination-dir (car ptr2)))
          )
        (setq ptr2 (cdr ptr2)))
      (cull-same-dates-dir-plus-extension destination-dir extension)
      (message "cull-same-dates destination-dir=%s" destination-dir)
      (cull-size-quota-dir-plus-extension destination-dir extension)
      (message "cull-size-quota-dir-plus-extension destination-dir=%s extension=%s" destination-dir extension)
      (setq ptr (cdr ptr)))
    )
  )

(defun duplicate-files ()
  (interactive)
  (progn
    (datify--dir "~/bak")
    (cull-same-dates "~/bak")
    (cull-size-quota "~/bak")
    ;;(make-directory "/media/www/F2TB/home/bak/"  'parents)
    (safe-command (make-directory "/media/www/G16GB/home/bak/" 'parents))
    (duplicate-files-inner "~/bak/" "/media/www/C1TB/home/bak/"    ".tar.gz")
    (duplicate-files-inner "~/bak/" "/media/www/C1TB/home/bak/"    ".zip")
    (duplicate-files-inner "~/bak/" "/media/www/F2TB/home/bak/"    ".tar.gz")
    (duplicate-files-inner "~/bak/" "/media/www/F2TB/home/bak/"    ".zip")
    (duplicate-files-inner "~/bak/" "/media/www/G16GB/home/bak/"   ".tar.gz")
    (duplicate-files-inner "~/bak/" "/media/www/G16GB/home/bak/"   ".zip")
    ;;(duplicate-files-inner "~/bak/" "/media/www/H16GB/home/bak/" ".tar.gz")
    ;;(duplicate-files-inner "~/bak/" "/media/www/H16GB/home/bak/" ".zip")
    (duplicate-files-inner "~/bak/" "/media/www/K2TB/home/bak/"    ".tar.gz")
    (duplicate-files-inner "~/bak/" "/media/www/K2TB/home/bak/"    ".zip")
    (duplicate-files-inner "~/bak/" "/media/www/BLU16GB/home/bak/" ".tar.gz")
    (duplicate-files-inner "~/bak/" "/media/www/BLU16GB/home/bak/" ".zip")
    (duplicate-files-inner "~/bak/" "/media/www/GRN16GB/home/bak/" ".tar.gz")
    (duplicate-files-inner "~/bak/" "/media/www/GRN16GB/home/bak/" ".zip")

    (duplicate-files-inner "~/bak/" "/media/www/WD2TB/home/bak/"   ".tar.gz")
    (duplicate-files-inner "~/bak/" "/media/www/WD2TB/home/bak/"   ".zip")
    (progn
      (duplicate-files-inner "~/bak/" "/media/www/WD2TB2/home/bak/"  ".tar.gz")
      (duplicate-files-inner "~/bak/" "/media/www/WD2TB2/home/bak/"  ".zip")
      )
    (progn
      (duplicate-files-inner "~/bak/" "f:/home/bak/" ".tar.gz")
      (duplicate-files-inner "~/bak/" "f:/home/bak/" ".zip")
      )
    (progn
      (duplicate-files-inner "~/bak/" "h:/home/bak/" ".tar.gz")
      (duplicate-files-inner "~/bak/" "h:/home/bak/" ".zip")
      )
    (progn
      (duplicate-files-inner "~/bak/" "j:/home/bak/" ".tar.gz")
      (duplicate-files-inner "~/bak/" "j:/home/bak/" ".zip")
      )
    (progn
      (duplicate-files-inner "c:/davinpearson-com/binaries/" "f:/davinpearson-com/binaries/" ".tar.gz")
      (duplicate-files-inner "c:/davinpearson-com/binaries/" "f:/davinpearson-com/binaries/" ".zip")
      )
    )
  )

(provide 'duplicate-files)
;;; duplicate-files.el ends here
