// Copyright 2011 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// DO NOT EDIT THIS FILE. GENERATED BY mkalldocs.sh.
// Edit the documentation in other files and rerun mkalldocs.sh to generate this one.

// Go is a tool for managing Go source code.
//
// Usage:
//
// 	go command [arguments]
//
// The commands are:
//
// 	build       compile packages and dependencies
// 	clean       remove object files
// 	doc         show documentation for package or symbol
// 	env         print Go environment information
// 	bug         start a bug report
// 	fix         run go tool fix on packages
// 	fmt         run gofmt on package sources
// 	generate    generate Go files by processing source
// 	get         download and install packages and dependencies
// 	install     compile and install packages and dependencies
// 	list        list packages
// 	run         compile and run Go program
// 	test        test packages
// 	tool        run specified go tool
// 	version     print Go version
// 	vet         run go tool vet on packages
//
// Use "go help [command]" for more information about a command.
//
// Additional help topics:
//
// 	c           calling between Go and C
// 	buildmode   description of build modes
// 	filetype    file types
// 	gopath      GOPATH environment variable
// 	environment environment variables
// 	importpath  import path syntax
// 	packages    description of package lists
// 	testflag    description of testing flags
// 	testfunc    description of testing functions
//
// Use "go help [topic]" for more information about that topic.
//
//
// Compile packages and dependencies
//
// Usage:
//
// 	go build [-o output] [-i] [build flags] [packages]
//
// Build compiles the packages named by the import paths,
// along with their dependencies, but it does not install the results.
//
// If the arguments to build are a list of .go files, build treats
// them as a list of source files specifying a single package.
//
// When compiling a single main package, build writes
// the resulting executable to an output file named after
// the first source file ('go build ed.go rx.go' writes 'ed' or 'ed.exe')
// or the source code directory ('go build unix/sam' writes 'sam' or 'sam.exe').
// The '.exe' suffix is added when writing a Windows executable.
//
// When compiling multiple packages or a single non-main package,
// build compiles the packages but discards the resulting object,
// serving only as a check that the packages can be built.
//
// When compiling packages, build ignores files that end in '_test.go'.
//
// The -o flag, only allowed when compiling a single package,
// forces build to write the resulting executable or object
// to the named output file, instead of the default behavior described
// in the last two paragraphs.
//
// The -i flag installs the packages that are dependencies of the target.
//
// The build flags are shared by the build, clean, get, install, list, run,
// and test commands:
//
// 	-a
// 		force rebuilding of packages that are already up-to-date.
// 	-n
// 		print the commands but do not run them.
// 	-p n
// 		the number of programs, such as build commands or
// 		test binaries, that can be run in parallel.
// 		The default is the number of CPUs available.
// 	-race
// 		enable data race detection.
// 		Supported only on linux/amd64, freebsd/amd64, darwin/amd64 and windows/amd64.
// 	-msan
// 		enable interoperation with memory sanitizer.
// 		Supported only on linux/amd64,
// 		and only with Clang/LLVM as the host C compiler.
// 	-v
// 		print the names of packages as they are compiled.
// 	-work
// 		print the name of the temporary work directory and
// 		do not delete it when exiting.
// 	-x
// 		print the commands.
//
// 	-asmflags 'flag list'
// 		arguments to pass on each go tool asm invocation.
// 	-buildmode mode
// 		build mode to use. See 'go help buildmode' for more.
// 	-compiler name
// 		name of compiler to use, as in runtime.Compiler (gccgo or gc).
// 	-gccgoflags 'arg list'
// 		arguments to pass on each gccgo compiler/linker invocation.
// 	-gcflags 'arg list'
// 		arguments to pass on each go tool compile invocation.
// 	-installsuffix suffix
// 		a suffix to use in the name of the package installation directory,
// 		in order to keep output separate from default builds.
// 		If using the -race flag, the install suffix is automatically set to race
// 		or, if set explicitly, has _race appended to it.  Likewise for the -msan
// 		flag.  Using a -buildmode option that requires non-default compile flags
// 		has a similar effect.
// 	-ldflags 'flag list'
// 		arguments to pass on each go tool link invocation.
// 	-linkshared
// 		link against shared libraries previously created with
// 		-buildmode=shared.
// 	-pkgdir dir
// 		install and load all packages from dir instead of the usual locations.
// 		For example, when building with a non-standard configuration,
// 		use -pkgdir to keep generated packages in a separate location.
// 	-tags 'tag list'
// 		a list of build tags to consider satisfied during the build.
// 		For more information about build tags, see the description of
// 		build constraints in the documentation for the go/build package.
// 	-toolexec 'cmd args'
// 		a program to use to invoke toolchain programs like vet and asm.
// 		For example, instead of running asm, the go command will run
// 		'cmd args /path/to/asm <arguments for asm>'.
//
// The list flags accept a space-separated list of strings. To embed spaces
// in an element in the list, surround it with either single or double quotes.
//
// For more about specifying packages, see 'go help packages'.
// For more about where packages and binaries are installed,
// run 'go help gopath'.
// For more about calling between Go and C/C++, run 'go help c'.
//
// Note: Build adheres to certain conventions such as those described
// by 'go help gopath'. Not all projects can follow these conventions,
// however. Installations that have their own conventions or that use
// a separate software build system may choose to use lower-level
// invocations such as 'go tool compile' and 'go tool link' to avoid
// some of the overheads and design decisions of the build tool.
//
// See also: go install, go get, go clean.
//
//
// Remove object files
//
// Usage:
//
// 	go clean [-i] [-r] [-n] [-x] [build flags] [packages]
//
// Clean removes object files from package source directories.
// The go command builds most objects in a temporary directory,
// so go clean is mainly concerned with object files left by other
// tools or by manual invocations of go build.
//
// Specifically, clean removes the following files from each of the
// source directories corresponding to the import paths:
//
// 	_obj/            old object directory, left from Makefiles
// 	_test/           old test directory, left from Makefiles
// 	_testmain.go     old gotest file, left from Makefiles
// 	test.out         old test log, left from Makefiles
// 	build.out        old test log, left from Makefiles
// 	*.[568ao]        object files, left from Makefiles
//
// 	DIR(.exe)        from go build
// 	DIR.test(.exe)   from go test -c
// 	MAINFILE(.exe)   from go build MAINFILE.go
// 	*.so             from SWIG
//
// In the list, DIR represents the final path element of the
// directory, and MAINFILE is the base name of any Go source
// file in the directory that is not included when building
// the package.
//
// The -i flag causes clean to remove the corresponding installed
// archive or binary (what 'go install' would create).
//
// The -n flag causes clean to print the remove commands it would execute,
// but not run them.
//
// The -r flag causes clean to be applied recursively to all the
// dependencies of the packages named by the import paths.
//
// The -x flag causes clean to print remove commands as it executes them.
//
// For more about build flags, see 'go help build'.
//
// For more about specifying packages, see 'go help packages'.
//
//
// Show documentation for package or symbol
//
// Usage:
//
// 	go doc [-u] [-c] [package|[package.]symbol[.method]]
//
// Doc prints the documentation comments associated with the item identified by its
// arguments (a package, const, func, type, var, or method) followed by a one-line
// summary of each of the first-level items "under" that item (package-level
// declarations for a package, methods for a type, etc.).
//
// Doc accepts zero, one, or two arguments.
//
// Given no arguments, that is, when run as
//
// 	go doc
//
// it prints the package documentation for the package in the current directory.
// If the package is a command (package main), the exported symbols of the package
// are elided from the presentation unless the -cmd flag is provided.
//
// When run with one argument, the argument is treated as a Go-syntax-like
// representation of the item to be documented. What the argument selects depends
// on what is installed in GOROOT and GOPATH, as well as the form of the argument,
// which is schematically one of these:
//
// 	go doc <pkg>
// 	go doc <sym>[.<method>]
// 	go doc [<pkg>.]<sym>[.<method>]
// 	go doc [<pkg>.][<sym>.]<method>
//
// The first item in this list matched by the argument is the one whose documentation
// is printed. (See the examples below.) However, if the argument starts with a capital
// letter it is assumed to identify a symbol or method in the current directory.
//
// For packages, the order of scanning is determined lexically in breadth-first order.
// That is, the package presented is the one that matches the search and is nearest
// the root and lexically first at its level of the hierarchy.  The GOROOT tree is
// always scanned in its entirety before GOPATH.
//
// If there is no package specified or matched, the package in the current
// directory is selected, so "go doc Foo" shows the documentation for symbol Foo in
// the current package.
//
// The package path must be either a qualified path or a proper suffix of a
// path. The go tool's usual package mechanism does not apply: package path
// elements like . and ... are not implemented by go doc.
//
// When run with two arguments, the first must be a full package path (not just a
// suffix), and the second is a symbol or symbol and method; this is similar to the
// syntax accepted by godoc:
//
// 	go doc <pkg> <sym>[.<method>]
//
// In all forms, when matching symbols, lower-case letters in the argument match
// either case but upper-case letters match exactly. This means that there may be
// multiple matches of a lower-case argument in a package if different symbols have
// different cases. If this occurs, documentation for all matches is printed.
//
// Examples:
// 	go doc
// 		Show documentation for current package.
// 	go doc Foo
// 		Show documentation for Foo in the current package.
// 		(Foo starts with a capital letter so it cannot match
// 		a package path.)
// 	go doc encoding/json
// 		Show documentation for the encoding/json package.
// 	go doc json
// 		Shorthand for encoding/json.
// 	go doc json.Number (or go doc json.number)
// 		Show documentation and method summary for json.Number.
// 	go doc json.Number.Int64 (or go doc json.number.int64)
// 		Show documentation for json.Number's Int64 method.
// 	go doc cmd/doc
// 		Show package docs for the doc command.
// 	go doc -cmd cmd/doc
// 		Show package docs and exported symbols within the doc command.
// 	go doc template.new
// 		Show documentation for html/template's New function.
// 		(html/template is lexically before text/template)
// 	go doc text/template.new # One argument
// 		Show documentation for text/template's New function.
// 	go doc text/template new # Two arguments
// 		Show documentation for text/template's New function.
//
// 	At least in the current tree, these invocations all print the
// 	documentation for json.Decoder's Decode method:
//
// 	go doc json.Decoder.Decode
// 	go doc json.decoder.decode
// 	go doc json.decode
// 	cd go/src/encoding/json; go doc decode
//
// Flags:
// 	-c
// 		Respect case when matching symbols.
// 	-cmd
// 		Treat a command (package main) like a regular package.
// 		Otherwise package main's exported symbols are hidden
// 		when showing the package's top-level documentation.
// 	-u
// 		Show documentation for unexported as well as exported
// 		symbols and methods.
//
//
// Print Go environment information
//
// Usage:
//
// 	go env [var ...]
//
// Env prints Go environment information.
//
// By default env prints information as a shell script
// (on Windows, a batch file).  If one or more variable
// names is given as arguments,  env prints the value of
// each named variable on its own line.
//
//
// Start a bug report
//
// Usage:
//
// 	go bug
//
// Bug opens the default browser and starts a new bug report.
// The report includes useful system information.
//
//
// Run go tool fix on packages
//
// Usage:
//
// 	go fix [packages]
//
// Fix runs the Go fix command on the packages named by the import paths.
//
// For more about fix, see 'go doc cmd/fix'.
// For more about specifying packages, see 'go help packages'.
//
// To run fix with specific options, run 'go tool fix'.
//
// See also: go fmt, go vet.
//
//
// Run gofmt on package sources
//
// Usage:
//
// 	go fmt [-n] [-x] [packages]
//
// Fmt runs the command 'gofmt -l -w' on the packages named
// by the import paths.  It prints the names of the files that are modified.
//
// For more about gofmt, see 'go doc cmd/gofmt'.
// For more about specifying packages, see 'go help packages'.
//
// The -n flag prints commands that would be executed.
// The -x flag prints commands as they are executed.
//
// To run gofmt with specific options, run gofmt itself.
//
// See also: go fix, go vet.
//
//
// Generate Go files by processing source
//
// Usage:
//
// 	go generate [-run regexp] [-n] [-v] [-x] [build flags] [file.go... | packages]
//
// Generate runs commands described by directives within existing
// files. Those commands can run any process but the intent is to
// create or update Go source files.
//
// Go generate is never run automatically by go build, go get, go test,
// and so on. It must be run explicitly.
//
// Go generate scans the file for directives, which are lines of
// the form,
//
// 	//go:generate command argument...
//
// (note: no leading spaces and no space in "//go") where command
// is the generator to be run, corresponding to an executable file
// that can be run locally. It must either be in the shell path
// (gofmt), a fully qualified path (/usr/you/bin/mytool), or a
// command alias, described below.
//
// Note that go generate does not parse the file, so lines that look
// like directives in comments or multiline strings will be treated
// as directives.
//
// The arguments to the directive are space-separated tokens or
// double-quoted strings passed to the generator as individual
// arguments when it is run.
//
// Quoted strings use Go syntax and are evaluated before execution; a
// quoted string appears as a single argument to the generator.
//
// Go generate sets several variables when it runs the generator:
//
// 	$GOARCH
// 		The execution architecture (arm, amd64, etc.)
// 	$GOOS
// 		The execution operating system (linux, windows, etc.)
// 	$GOFILE
// 		The base name of the file.
// 	$GOLINE
// 		The line number of the directive in the source file.
// 	$GOPACKAGE
// 		The name of the package of the file containing the directive.
// 	$DOLLAR
// 		A dollar sign.
//
// Other than variable substitution and quoted-string evaluation, no
// special processing such as "globbing" is performed on the command
// line.
//
// As a last step before running the command, any invocations of any
// environment variables with alphanumeric names, such as $GOFILE or
// $HOME, are expanded throughout the command line. The syntax for
// variable expansion is $NAME on all operating systems.  Due to the
// order of evaluation, variables are expanded even inside quoted
// strings. If the variable NAME is not set, $NAME expands to the
// empty string.
//
// A directive of the form,
//
// 	//go:generate -command xxx args...
//
// specifies, for the remainder of this source file only, that the
// string xxx represents the command identified by the arguments. This
// can be used to create aliases or to handle multiword generators.
// For example,
//
// 	//go:generate -command foo go tool foo
//
// specifies that the command "foo" represents the generator
// "go tool foo".
//
// Generate processes packages in the order given on the command line,
// one at a time. If the command line lists .go files, they are treated
// as a single package. Within a package, generate processes the
// source files in a package in file name order, one at a time. Within
// a source file, generate runs generators in the order they appear
// in the file, one at a time.
//
// If any generator returns an error exit status, "go generate" skips
// all further processing for that package.
//
// The generator is run in the package's source directory.
//
// Go generate accepts one specific flag:
//
// 	-run=""
// 		if non-empty, specifies a regular expression to select
// 		directives whose full original source text (excluding
// 		any trailing spaces and final newline) matches the
// 		expression.
//
// It also accepts the standard build flags including -v, -n, and -x.
// The -v flag prints the names of packages and files as they are
// processed.
// The -n flag prints commands that would be executed.
// The -x flag prints commands as they are executed.
//
// For more about build flags, see 'go help build'.
//
// For more about specifying packages, see 'go help packages'.
//
//
// Download and install packages and dependencies
//
// Usage:
//
// 	go get [-d] [-f] [-fix] [-insecure] [-t] [-u] [build flags] [packages]
//
// Get downloads the packages named by the import paths, along with their
// dependencies. It then installs the named packages, like 'go install'.
//
// The -d flag instructs get to stop after downloading the packages; that is,
// it instructs get not to install the packages.
//
// The -f flag, valid only when -u is set, forces get -u not to verify that
// each package has been checked out from the source control repository
// implied by its import path. This can be useful if the source is a local fork
// of the original.
//
// The -fix flag instructs get to run the fix tool on the downloaded packages
// before resolving dependencies or building the code.
//
// The -insecure flag permits fetching from repositories and resolving
// custom domains using insecure schemes such as HTTP. Use with caution.
//
// The -t flag instructs get to also download the packages required to build
// the tests for the specified packages.
//
// The -u flag instructs get to use the network to update the named packages
// and their dependencies.  By default, get uses the network to check out
// missing packages but does not use it to look for updates to existing packages.
//
// The -v flag enables verbose progress and debug output.
//
// Get also accepts build flags to control the installation. See 'go help build'.
//
// When checking out a new package, get creates the target directory
// GOPATH/src/<import-path>. If the GOPATH contains multiple entries,
// get uses the first one. For more details see: 'go help gopath'.
//
// When checking out or updating a package, get looks for a branch or tag
// that matches the locally installed version of Go. The most important
// rule is that if the local installation is running version "go1", get
// searches for a branch or tag named "go1". If no such version exists it
// retrieves the most recent version of the package.
//
// When go get checks out or updates a Git repository,
// it also updates any git submodules referenced by the repository.
//
// Get never checks out or updates code stored in vendor directories.
//
// For more about specifying packages, see 'go help packages'.
//
// For more about how 'go get' finds source code to
// download, see 'go help importpath'.
//
// See also: go build, go install, go clean.
//
//
// Compile and install packages and dependencies
//
// Usage:
//
// 	go install [build flags] [packages]
//
// Install compiles and installs the packages named by the import paths,
// along with their dependencies.
//
// For more about the build flags, see 'go help build'.
// For more about specifying packages, see 'go help packages'.
//
// See also: go build, go get, go clean.
//
//
// List packages
//
// Usage:
//
// 	go list [-e] [-f format] [-json] [build flags] [packages]
//
// List lists the packages named by the import paths, one per line.
//
// The default output shows the package import path:
//
//     bytes
//     encoding/json
//     github.com/gorilla/mux
//     golang.org/x/net/html
//
// The -f flag specifies an alternate format for the list, using the
// syntax of package template.  The default output is equivalent to -f
// '{{.ImportPath}}'. The struct being passed to the template is:
//
//     type Package struct {
//         Dir           string // directory containing package sources
//         ImportPath    string // import path of package in dir
//         ImportComment string // path in import comment on package statement
//         Name          string // package name
//         Doc           string // package documentation string
//         Target        string // install path
//         Shlib         string // the shared library that contains this package (only set when -linkshared)
//         Goroot        bool   // is this package in the Go root?
//         Standard      bool   // is this package part of the standard Go library?
//         Stale         bool   // would 'go install' do anything for this package?
//         StaleReason   string // explanation for Stale==true
//         Root          string // Go root or Go path dir containing this package
//         ConflictDir   string // this directory shadows Dir in $GOPATH
//         BinaryOnly    bool   // binary-only package: cannot be recompiled from sources
//
//         // Source files
//         GoFiles        []string // .go source files (excluding CgoFiles, TestGoFiles, XTestGoFiles)
//         CgoFiles       []string // .go sources files that import "C"
//         IgnoredGoFiles []string // .go sources ignored due to build constraints
//         CFiles         []string // .c source files
//         CXXFiles       []string // .cc, .cxx and .cpp source files
//         MFiles         []string // .m source files
//         HFiles         []string // .h, .hh, .hpp and .hxx source files
//         FFiles         []string // .f, .F, .for and .f90 Fortran source files
//         SFiles         []string // .s source files
//         SwigFiles      []string // .swig files
//         SwigCXXFiles   []string // .swigcxx files
//         SysoFiles      []string // .syso object files to add to archive
//         TestGoFiles    []string // _test.go files in package
//         XTestGoFiles   []string // _test.go files outside package
//
//         // Cgo directives
//         CgoCFLAGS    []string // cgo: flags for C compiler
//         CgoCPPFLAGS  []string // cgo: flags for C preprocessor
//         CgoCXXFLAGS  []string // cgo: flags for C++ compiler
//         CgoFFLAGS    []string // cgo: flags for Fortran compiler
//         CgoLDFLAGS   []string // cgo: flags for linker
//         CgoPkgConfig []string // cgo: pkg-config names
//
//         // Dependency information
//         Imports      []string // import paths used by this package
//         Deps         []string // all (recursively) imported dependencies
//         TestImports  []string // imports from TestGoFiles
//         XTestImports []string // imports from XTestGoFiles
//
//         // Error information
//         Incomplete bool            // this package or a dependency has an error
//         Error      *PackageError   // error loading package
//         DepsErrors []*PackageError // errors loading dependencies
//     }
//
// Packages stored in vendor directories report an ImportPath that includes the
// path to the vendor directory (for example, "d/vendor/p" instead of "p"),
// so that the ImportPath uniquely identifies a given copy of a package.
// The Imports, Deps, TestImports, and XTestImports lists also contain these
// expanded imports paths. See golang.org/s/go15vendor for more about vendoring.
//
// The error information, if any, is
//
//     type PackageError struct {
//         ImportStack   []string // shortest path from package named on command line to this one
//         Pos           string   // position of error (if present, file:line:col)
//         Err           string   // the error itself
//     }
//
// The template function "join" calls strings.Join.
//
// The template function "context" returns the build context, defined as:
//
// 	type Context struct {
// 		GOARCH        string   // target architecture
// 		GOOS          string   // target operating system
// 		GOROOT        string   // Go root
// 		GOPATH        string   // Go path
// 		CgoEnabled    bool     // whether cgo can be used
// 		UseAllFiles   bool     // use files regardless of +build lines, file names
// 		Compiler      string   // compiler to assume when computing target paths
// 		BuildTags     []string // build constraints to match in +build lines
// 		ReleaseTags   []string // releases the current release is compatible with
// 		InstallSuffix string   // suffix to use in the name of the install dir
// 	}
//
// For more information about the meaning of these fields see the documentation
// for the go/build package's Context type.
//
// The -json flag causes the package data to be printed in JSON format
// instead of using the template format.
//
// The -e flag changes the handling of erroneous packages, those that
// cannot be found or are malformed.  By default, the list command
// prints an error to standard error for each erroneous package and
// omits the packages from consideration during the usual printing.
// With the -e flag, the list command never prints errors to standard
// error and instead processes the erroneous packages with the usual
// printing.  Erroneous packages will have a non-empty ImportPath and
// a non-nil Error field; other information may or may not be missing
// (zeroed).
//
// For more about build flags, see 'go help build'.
//
// For more about specifying packages, see 'go help packages'.
//
//
// Compile and run Go program
//
// Usage:
//
// 	go run [build flags] [-exec xprog] gofiles... [arguments...]
//
// Run compiles and runs the main package comprising the named Go source files.
// A Go source file is defined to be a file ending in a literal ".go" suffix.
//
// By default, 'go run' runs the compiled binary directly: 'a.out arguments...'.
// If the -exec flag is given, 'go run' invokes the binary using xprog:
// 	'xprog a.out arguments...'.
// If the -exec flag is not given, GOOS or GOARCH is different from the system
// default, and a program named go_$GOOS_$GOARCH_exec can be found
// on the current search path, 'go run' invokes the binary using that program,
// for example 'go_nacl_386_exec a.out arguments...'. This allows execution of
// cross-compiled programs when a simulator or other execution method is
// available.
//
// For more about build flags, see 'go help build'.
//
// See also: go build.
//
//
// Test packages
//
// Usage:
//
// 	go test [build/test flags] [packages] [build/test flags & test binary flags]
//
// 'Go test' automates testing the packages named by the import paths.
// It prints a summary of the test results in the format:
//
// 	ok   archive/tar   0.011s
// 	FAIL archive/zip   0.022s
// 	ok   compress/gzip 0.033s
// 	...
//
// followed by detailed output for each failed package.
//
// 'Go test' recompiles each package along with any files with names matching
// the file pattern "*_test.go".
// Files whose names begin with "_" (including "_test.go") or "." are ignored.
// These additional files can contain test functions, benchmark functions, and
// example functions.  See 'go help testfunc' for more.
// Each listed package causes the execution of a separate test binary.
//
// Test files that declare a package with the suffix "_test" will be compiled as a
// separate package, and then linked and run with the main test binary.
//
// The go tool will ignore a directory named "testdata", making it available
// to hold ancillary data needed by the tests.
//
// By default, go test needs no arguments.  It compiles and tests the package
// with source in the current directory, including tests, and runs the tests.
//
// The package is built in a temporary directory so it does not interfere with the
// non-test installation.
//
// In addition to the build flags, the flags handled by 'go test' itself are:
//
// 	-args
// 	    Pass the remainder of the command line (everything after -args)
// 	    to the test binary, uninterpreted and unchanged.
// 	    Because this flag consumes the remainder of the command line,
// 	    the package list (if present) must appear before this flag.
//
// 	-c
// 	    Compile the test binary to pkg.test but do not run it
// 	    (where pkg is the last element of the package's import path).
// 	    The file name can be changed with the -o flag.
//
// 	-exec xprog
// 	    Run the test binary using xprog. The behavior is the same as
// 	    in 'go run'. See 'go help run' for details.
//
// 	-i
// 	    Install packages that are dependencies of the test.
// 	    Do not run the test.
//
// 	-o file
// 	    Compile the test binary to the named file.
// 	    The test still runs (unless -c or -i is specified).
//
// The test binary also accepts flags that control execution of the test; these
// flags are also accessible by 'go test'. See 'go help testflag' for details.
//
// For more about build flags, see 'go help build'.
// For more about specifying packages, see 'go help packages'.
//
// See also: go build, go vet.
//
//
// Run specified go tool
//
// Usage:
//
// 	go tool [-n] command [args...]
//
// Tool runs the go tool command identified by the arguments.
// With no arguments it prints the list of known tools.
//
// The -n flag causes tool to print the command that would be
// executed but not execute it.
//
// For more about each tool command, see 'go tool command -h'.
//
//
// Print Go version
//
// Usage:
//
// 	go version
//
// Version prints the Go version, as reported by runtime.Version.
//
//
// Run go tool vet on packages
//
// Usage:
//
// 	go vet [-n] [-x] [build flags] [packages]
//
// Vet runs the Go vet command on the packages named by the import paths.
//
// For more about vet, see 'go doc cmd/vet'.
// For more about specifying packages, see 'go help packages'.
//
// To run the vet tool with specific options, run 'go tool vet'.
//
// The -n flag prints commands that would be executed.
// The -x flag prints commands as they are executed.
//
// For more about build flags, see 'go help build'.
//
// See also: go fmt, go fix.
//
//
// Calling between Go and C
//
// There are two different ways to call between Go and C/C++ code.
//
// The first is the cgo tool, which is part of the Go distribution.  For
// information on how to use it see the cgo documentation (go doc cmd/cgo).
//
// The second is the SWIG program, which is a general tool for
// interfacing between languages.  For information on SWIG see
// http://swig.org/.  When running go build, any file with a .swig
// extension will be passed to SWIG.  Any file with a .swigcxx extension
// will be passed to SWIG with the -c++ option.
//
// When either cgo or SWIG is used, go build will pass any .c, .m, .s,
// or .S files to the C compiler, and any .cc, .cpp, .cxx files to the C++
// compiler.  The CC or CXX environment variables may be set to determine
// the C or C++ compiler, respectively, to use.
//
//
// Description of build modes
//
// The 'go build' and 'go install' commands take a -buildmode argument which
// indicates which kind of object file is to be built. Currently supported values
// are:
//
// 	-buildmode=archive
// 		Build the listed non-main packages into .a files. Packages named
// 		main are ignored.
//
// 	-buildmode=c-archive
// 		Build the listed main package, plus all packages it imports,
// 		into a C archive file. The only callable symbols will be those
// 		functions exported using a cgo //export comment. Requires
// 		exactly one main package to be listed.
//
// 	-buildmode=c-shared
// 		Build the listed main packages, plus all packages that they
// 		import, into C shared libraries. The only callable symbols will
// 		be those functions exported using a cgo //export comment.
// 		Non-main packages are ignored.
//
// 	-buildmode=default
// 		Listed main packages are built into executables and listed
// 		non-main packages are built into .a files (the default
// 		behavior).
//
// 	-buildmode=shared
// 		Combine all the listed non-main packages into a single shared
// 		library that will be used when building with the -linkshared
// 		option. Packages named main are ignored.
//
// 	-buildmode=exe
// 		Build the listed main packages and everything they import into
// 		executables. Packages not named main are ignored.
//
// 	-buildmode=pie
// 		Build the listed main packages and everything they import into
// 		position independent executables (PIE). Packages not named
// 		main are ignored.
//
// 	-buildmode=plugin
// 		Build the listed main packages, plus all packages that they
// 		import, into a Go plugin. Packages not named main are ignored.
//
//
// File types
//
// The go command examines the contents of a restricted set of files
// in each directory. It identifies which files to examine based on
// the extension of the file name. These extensions are:
//
// 	.go
// 		Go source files.
// 	.c, .h
// 		C source files.
// 		If the package uses cgo or SWIG, these will be compiled with the
// 		OS-native compiler (typically gcc); otherwise they will
// 		trigger an error.
// 	.cc, .cpp, .cxx, .hh, .hpp, .hxx
// 		C++ source files. Only useful with cgo or SWIG, and always
// 		compiled with the OS-native compiler.
// 	.m
// 		Objective-C source files. Only useful with cgo, and always
// 		compiled with the OS-native compiler.
// 	.s, .S
// 		Assembler source files.
// 		If the package uses cgo or SWIG, these will be assembled with the
// 		OS-native assembler (typically gcc (sic)); otherwise they
// 		will be assembled with the Go assembler.
// 	.swig, .swigcxx
// 		SWIG definition files.
// 	.syso
// 		System object files.
//
// Files of each of these types except .syso may contain build
// constraints, but the go command stops scanning for build constraints
// at the first item in the file that is not a blank line or //-style
// line comment. See the go/build package documentation for
// more details.
//
// Non-test Go source files can also include a //go:binary-only-package
// comment, indicating that the package sources are included
// for documentation only and must not be used to build the
// package binary. This enables distribution of Go packages in
// their compiled form alone. See the go/build package documentation
// for more details.
//
//
// GOPATH environment variable
//
// The Go path is used to resolve import statements.
// It is implemented by and documented in the go/build package.
//
// The GOPATH environment variable lists places to look for Go code.
// On Unix, the value is a colon-separated string.
// On Windows, the value is a semicolon-separated string.
// On Plan 9, the value is a list.
//
// If the environment variable is unset, GOPATH defaults
// to a subdirectory named "go" in the user's home directory
// ($HOME/go on Unix, %USERPROFILE%\go on Windows),
// unless that directory holds a Go distribution.
// Run "go env GOPATH" to see the current GOPATH.
//
// See https://golang.org/wiki/SettingGOPATH to set a custom GOPATH.
//
// Each directory listed in GOPATH must have a prescribed structure:
//
// The src directory holds source code.  The path below src
// determines the import path or executable name.
//
// The pkg directory holds installed package objects.
// As in the Go tree, each target operating system and
// architecture pair has its own subdirectory of pkg
// (pkg/GOOS_GOARCH).
//
// If DIR is a directory listed in the GOPATH, a package with
// source in DIR/src/foo/bar can be imported as "foo/bar" and
// has its compiled form installed to "DIR/pkg/GOOS_GOARCH/foo/bar.a".
//
// The bin directory holds compiled commands.
// Each command is named for its source directory, but only
// the final element, not the entire path.  That is, the
// command with source in DIR/src/foo/quux is installed into
// DIR/bin/quux, not DIR/bin/foo/quux.  The "foo/" prefix is stripped
// so that you can add DIR/bin to your PATH to get at the
// installed commands.  If the GOBIN environment variable is
// set, commands are installed to the directory it names instead
// of DIR/bin. GOBIN must be an absolute path.
//
// Here's an example directory layout:
//
//     GOPATH=/home/user/go
//
//     /home/user/go/
//         src/
//             foo/
//                 bar/               (go code in package bar)
//                     x.go
//                 quux/              (go code in package main)
//                     y.go
//         bin/
//             quux                   (installed command)
//         pkg/
//             linux_amd64/
//                 foo/
//                     bar.a          (installed package object)
//
// Go searches each directory listed in GOPATH to find source code,
// but new packages are always downloaded into the first directory
// in the list.
//
// See https://golang.org/doc/code.html for an example.
//
// Internal Directories
//
// Code in or below a directory named "internal" is importable only
// by code in the directory tree rooted at the parent of "internal".
// Here's an extended version of the directory layout above:
//
//     /home/user/go/
//         src/
//             crash/
//                 bang/              (go code in package bang)
//                     b.go
//             foo/                   (go code in package foo)
//                 f.go
//                 bar/               (go code in package bar)
//                     x.go
//                 internal/
//                     baz/           (go code in package baz)
//                         z.go
//                 quux/              (go code in package main)
//                     y.go
//
//
// The code in z.go is imported as "foo/internal/baz", but that
// import statement can only appear in source files in the subtree
// rooted at foo. The source files foo/f.go, foo/bar/x.go, and
// foo/quux/y.go can all import "foo/internal/baz", but the source file
// crash/bang/b.go cannot.
//
// See https://golang.org/s/go14internal for details.
//
// Vendor Directories
//
// Go 1.6 includes support for using local copies of external dependencies
// to satisfy imports of those dependencies, often referred to as vendoring.
//
// Code below a directory named "vendor" is importable only
// by code in the directory tree rooted at the parent of "vendor",
// and only using an import path that omits the prefix up to and
// including the vendor element.
//
// Here's the example from the previous section,
// but with the "internal" directory renamed to "vendor"
// and a new foo/vendor/crash/bang directory added:
//
//     /home/user/go/
//         src/
//             crash/
//                 bang/              (go code in package bang)
//                     b.go
//             foo/                   (go code in package foo)
//                 f.go
//                 bar/               (go code in package bar)
//                     x.go
//                 vendor/
//                     crash/
//                         bang/      (go code in package bang)
//                             b.go
//                     baz/           (go code in package baz)
//                         z.go
//                 quux/              (go code in package main)
//                     y.go
//
// The same visibility rules apply as for internal, but the code
// in z.go is imported as "baz", not as "foo/vendor/baz".
//
// Code in vendor directories deeper in the source tree shadows
// code in higher directories. Within the subtree rooted at foo, an import
// of "crash/bang" resolves to "foo/vendor/crash/bang", not the
// top-level "crash/bang".
//
// Code in vendor directories is not subject to import path
// checking (see 'go help importpath').
//
// When 'go get' checks out or updates a git repository, it now also
// updates submodules.
//
// Vendor directories do not affect the placement of new repositories
// being checked out for the first time by 'go get': those are always
// placed in the main GOPATH, never in a vendor subtree.
//
// See https://golang.org/s/go15vendor for details.
//
//
// Environment variables
//
// The go command, and the tools it invokes, examine a few different
// environment variables. For many of these, you can see the default
// value of on your system by running 'go env NAME', where NAME is the
// name of the variable.
//
// General-purpose environment variables:
//
// 	GCCGO
// 		The gccgo command to run for 'go build -compiler=gccgo'.
// 	GOARCH
// 		The architecture, or processor, for which to compile code.
// 		Examples are amd64, 386, arm, ppc64.
// 	GOBIN
// 		The directory where 'go install' will install a command.
// 	GOOS
// 		The operating system for which to compile code.
// 		Examples are linux, darwin, windows, netbsd.
// 	GOPATH
// 		For more details see: 'go help gopath'.
// 	GORACE
// 		Options for the race detector.
// 		See https://golang.org/doc/articles/race_detector.html.
// 	GOROOT
// 		The root of the go tree.
//
// Environment variables for use with cgo:
//
// 	CC
// 		The command to use to compile C code.
// 	CGO_ENABLED
// 		Whether the cgo command is supported.  Either 0 or 1.
// 	CGO_CFLAGS
// 		Flags that cgo will pass to the compiler when compiling
// 		C code.
// 	CGO_CPPFLAGS
// 		Flags that cgo will pass to the compiler when compiling
// 		C or C++ code.
// 	CGO_CXXFLAGS
// 		Flags that cgo will pass to the compiler when compiling
// 		C++ code.
// 	CGO_FFLAGS
// 		Flags that cgo will pass to the compiler when compiling
// 		Fortran code.
// 	CGO_LDFLAGS
// 		Flags that cgo will pass to the compiler when linking.
// 	CXX
// 		The command to use to compile C++ code.
// 	PKG_CONFIG
// 		Path to pkg-config tool.
//
// Architecture-specific environment variables:
//
// 	GOARM
// 		For GOARCH=arm, the ARM architecture for which to compile.
// 		Valid values are 5, 6, 7.
// 	GO386
// 		For GOARCH=386, the floating point instruction set.
// 		Valid values are 387, sse2.
//
// Special-purpose environment variables:
//
// 	GOROOT_FINAL
// 		The root of the installed Go tree, when it is
// 		installed in a location other than where it is built.
// 		File names in stack traces are rewritten from GOROOT to
// 		GOROOT_FINAL.
// 	GO_EXTLINK_ENABLED
// 		Whether the linker should use external linking mode
// 		when using -linkmode=auto with code that uses cgo.
// 		Set to 0 to disable external linking mode, 1 to enable it.
// 	GIT_ALLOW_PROTOCOL
// 		Defined by Git. A colon-separated list of schemes that are allowed to be used
// 		with git fetch/clone. If set, any scheme not explicitly mentioned will be
// 		considered insecure by 'go get'.
//
//
// Import path syntax
//
// An import path (see 'go help packages') denotes a package stored in the local
// file system.  In general, an import path denotes either a standard package (such
// as "unicode/utf8") or a package found in one of the work spaces (For more
// details see: 'go help gopath').
//
// Relative import paths
//
// An import path beginning with ./ or ../ is called a relative path.
// The toolchain supports relative import paths as a shortcut in two ways.
//
// First, a relative path can be used as a shorthand on the command line.
// If you are working in the directory containing the code imported as
// "unicode" and want to run the tests for "unicode/utf8", you can type
// "go test ./utf8" instead of needing to specify the full path.
// Similarly, in the reverse situation, "go test .." will test "unicode" from
// the "unicode/utf8" directory. Relative patterns are also allowed, like
// "go test ./..." to test all subdirectories. See 'go help packages' for details
// on the pattern syntax.
//
// Second, if you are compiling a Go program not in a work space,
// you can use a relative path in an import statement in that program
// to refer to nearby code also not in a work space.
// This makes it easy to experiment with small multipackage programs
// outside of the usual work spaces, but such programs cannot be
// installed with "go install" (there is no work space in which to install them),
// so they are rebuilt from scratch each time they are built.
// To avoid ambiguity, Go programs cannot use relative import paths
// within a work space.
//
// Remote import paths
//
// Certain import paths also
// describe how to obtain the source code for the package using
// a revision control system.
//
// A few common code hosting sites have special syntax:
//
// 	Bitbucket (Git, Mercurial)
//
// 		import "bitbucket.org/user/project"
// 		import "bitbucket.org/user/project/sub/directory"
//
// 	GitHub (Git)
//
// 		import "github.com/user/project"
// 		import "github.com/user/project/sub/directory"
//
// 	Launchpad (Bazaar)
//
// 		import "launchpad.net/project"
// 		import "launchpad.net/project/series"
// 		import "launchpad.net/project/series/sub/directory"
//
// 		import "launchpad.net/~user/project/branch"
// 		import "launchpad.net/~user/project/branch/sub/directory"
//
// 	IBM DevOps Services (Git)
//
// 		import "hub.jazz.net/git/user/project"
// 		import "hub.jazz.net/git/user/project/sub/directory"
//
// For code hosted on other servers, import paths may either be qualified
// with the version control type, or the go tool can dynamically fetch
// the import path over https/http and discover where the code resides
// from a <meta> tag in the HTML.
//
// To declare the code location, an import path of the form
//
// 	repository.vcs/path
//
// specifies the given repository, with or without the .vcs suffix,
// using the named version control system, and then the path inside
// that repository.  The supported version control systems are:
//
// 	Bazaar      .bzr
// 	Git         .git
// 	Mercurial   .hg
// 	Subversion  .svn
//
// For example,
//
// 	import "example.org/user/foo.hg"
//
// denotes the root directory of the Mercurial repository at
// example.org/user/foo or foo.hg, and
//
// 	import "example.org/repo.git/foo/bar"
//
// denotes the foo/bar directory of the Git repository at
// example.org/repo or repo.git.
//
// When a version control system supports multiple protocols,
// each is tried in turn when downloading.  For example, a Git
// download tries https://, then git+ssh://.
//
// By default, downloads are restricted to known secure protocols
// (e.g. https, ssh). To override this setting for Git downloads, the
// GIT_ALLOW_PROTOCOL environment variable can be set (For more details see:
// 'go help environment').
//
// If the import path is not a known code hosting site and also lacks a
// version control qualifier, the go tool attempts to fetch the import
// over https/http and looks for a <meta> tag in the document's HTML
// <head>.
//
// The meta tag has the form:
//
// 	<meta name="go-import" content="import-prefix vcs repo-root">
//
// The import-prefix is the import path corresponding to the repository
// root. It must be a prefix or an exact match of the package being
// fetched with "go get". If it's not an exact match, another http
// request is made at the prefix to verify the <meta> tags match.
//
// The meta tag should appear as early in the file as possible.
// In particular, it should appear before any raw JavaScript or CSS,
// to avoid confusing the go command's restricted parser.
//
// The vcs is one of "git", "hg", "svn", etc,
//
// The repo-root is the root of the version control system
// containing a scheme and not containing a .vcs qualifier.
//
// For example,
//
// 	import "example.org/pkg/foo"
//
// will result in the following requests:
//
// 	https://example.org/pkg/foo?go-get=1 (preferred)
// 	http://example.org/pkg/foo?go-get=1  (fallback, only with -insecure)
//
// If that page contains the meta tag
//
// 	<meta name="go-import" content="example.org git https://code.org/r/p/exproj">
//
// the go tool will verify that https://example.org/?go-get=1 contains the
// same meta tag and then git clone https://code.org/r/p/exproj into
// GOPATH/src/example.org.
//
// New downloaded packages are written to the first directory listed in the GOPATH
// environment variable (For more details see: 'go help gopath').
//
// The go command attempts to download the version of the
// package appropriate for the Go release being used.
// Run 'go help get' for more.
//
// Import path checking
//
// When the custom import path feature described above redirects to a
// known code hosting site, each of the resulting packages has two possible
// import paths, using the custom domain or the known hosting site.
//
// A package statement is said to have an "import comment" if it is immediately
// followed (before the next newline) by a comment of one of these two forms:
//
// 	package math // import "path"
// 	package math /* import "path" */
//
// The go command will refuse to install a package with an import comment
// unless it is being referred to by that import path. In this way, import comments
// let package authors make sure the custom import path is used and not a
// direct path to the underlying code hosting site.
//
// Import path checking is disabled for code found within vendor trees.
// This makes it possible to copy code into alternate locations in vendor trees
// without needing to update import comments.
//
// See https://golang.org/s/go14customimport for details.
//
//
// Description of package lists
//
// Many commands apply to a set of packages:
//
// 	go action [packages]
//
// Usually, [packages] is a list of import paths.
//
// An import path that is a rooted path or that begins with
// a . or .. element is interpreted as a file system path and
// denotes the package in that directory.
//
// Otherwise, the import path P denotes the package found in
// the directory DIR/src/P for some DIR listed in the GOPATH
// environment variable (For more details see: 'go help gopath').
//
// If no import paths are given, the action applies to the
// package in the current directory.
//
// There are four reserved names for paths that should not be used
// for packages to be built with the go tool:
//
// - "main" denotes the top-level package in a stand-alone executable.
//
// - "all" expands to all package directories found in all the GOPATH
// trees. For example, 'go list all' lists all the packages on the local
// system.
//
// - "std" is like all but expands to just the packages in the standard
// Go library.
//
// - "cmd" expands to the Go repository's commands and their
// internal libraries.
//
// Import paths beginning with "cmd/" only match source code in
// the Go repository.
//
// An import path is a pattern if it includes one or more "..." wildcards,
// each of which can match any string, including the empty string and
// strings containing slashes.  Such a pattern expands to all package
// directories found in the GOPATH trees with names matching the
// patterns.  As a special case, x/... matches x as well as x's subdirectories.
// For example, net/... expands to net and packages in its subdirectories.
//
// An import path can also name a package to be downloaded from
// a remote repository.  Run 'go help importpath' for details.
//
// Every package in a program must have a unique import path.
// By convention, this is arranged by starting each path with a
// unique prefix that belongs to you.  For example, paths used
// internally at Google all begin with 'google', and paths
// denoting remote repositories begin with the path to the code,
// such as 'github.com/user/repo'.
//
// Packages in a program need not have unique package names,
// but there are two reserved package names with special meaning.
// The name main indicates a command, not a library.
// Commands are built into binaries and cannot be imported.
// The name documentation indicates documentation for
// a non-Go program in the directory. Files in package documentation
// are ignored by the go command.
//
// As a special case, if the package list is a list of .go files from a
// single directory, the command is applied to a single synthesized
// package made up of exactly those files, ignoring any build constraints
// in those files and ignoring any other files in the directory.
//
// Directory and file names that begin with "." or "_" are ignored
// by the go tool, as are directories named "testdata".
//
//
// Description of testing flags
//
// The 'go test' command takes both flags that apply to 'go test' itself
// and flags that apply to the resulting test binary.
//
// Several of the flags control profiling and write an execution profile
// suitable for "go tool pprof"; run "go tool pprof -h" for more
// information.  The --alloc_space, --alloc_objects, and --show_bytes
// options of pprof control how the information is presented.
//
// The following flags are recognized by the 'go test' command and
// control the execution of any test:
//
// 	-bench regexp
// 	    Run (sub)benchmarks matching a regular expression.
// 	    The given regular expression is split into smaller ones by
// 	    top-level '/', where each must match the corresponding part of a
// 	    benchmark's identifier.
// 	    By default, no benchmarks run. To run all benchmarks,
// 	    use '-bench .' or '-bench=.'.
//
// 	-benchtime t
// 	    Run enough iterations of each benchmark to take t, specified
// 	    as a time.Duration (for example, -benchtime 1h30s).
// 	    The default is 1 second (1s).
//
// 	-count n
// 	    Run each test and benchmark n times (default 1).
// 	    If -cpu is set, run n times for each GOMAXPROCS value.
// 	    Examples are always run once.
//
// 	-cover
// 	    Enable coverage analysis.
//
// 	-covermode set,count,atomic
// 	    Set the mode for coverage analysis for the package[s]
// 	    being tested. The default is "set" unless -race is enabled,
// 	    in which case it is "atomic".
// 	    The values:
// 		set: bool: does this statement run?
// 		count: int: how many times does this statement run?
// 		atomic: int: count, but correct in multithreaded tests;
// 			significantly more expensive.
// 	    Sets -cover.
//
// 	-coverpkg pkg1,pkg2,pkg3
// 	    Apply coverage analysis in each test to the given list of packages.
// 	    The default is for each test to analyze only the package being tested.
// 	    Packages are specified as import paths.
// 	    Sets -cover.
//
// 	-cpu 1,2,4
// 	    Specify a list of GOMAXPROCS values for which the tests or
// 	    benchmarks should be executed.  The default is the current value
// 	    of GOMAXPROCS.
//
// 	-parallel n
// 	    Allow parallel execution of test functions that call t.Parallel.
// 	    The value of this flag is the maximum number of tests to run
// 	    simultaneously; by default, it is set to the value of GOMAXPROCS.
// 	    Note that -parallel only applies within a single test binary.
// 	    The 'go test' command may run tests for different packages
// 	    in parallel as well, according to the setting of the -p flag
// 	    (see 'go help build').
//
// 	-run regexp
// 	    Run only those tests and examples matching the regular expression.
// 	    For tests the regular expression is split into smaller ones by
// 	    top-level '/', where each must match the corresponding part of a
// 	    test's identifier.
//
// 	-short
// 	    Tell long-running tests to shorten their run time.
// 	    It is off by default but set during all.bash so that installing
// 	    the Go tree can run a sanity check but not spend time running
// 	    exhaustive tests.
//
// 	-timeout t
// 	    If a test runs longer than t, panic.
// 	    The default is 10 minutes (10m).
//
// 	-v
// 	    Verbose output: log all tests as they are run. Also print all
// 	    text from Log and Logf calls even if the test succeeds.
//
// The following flags are also recognized by 'go test' and can be used to
// profile the tests during execution:
//
// 	-benchmem
// 	    Print memory allocation statistics for benchmarks.
//
// 	-blockprofile block.out
// 	    Write a goroutine blocking profile to the specified file
// 	    when all tests are complete.
// 	    Writes test binary as -c would.
//
// 	-blockprofilerate n
// 	    Control the detail provided in goroutine blocking profiles by
// 	    calling runtime.SetBlockProfileRate with n.
// 	    See 'go doc runtime.SetBlockProfileRate'.
// 	    The profiler aims to sample, on average, one blocking event every
// 	    n nanoseconds the program spends blocked.  By default,
// 	    if -test.blockprofile is set without this flag, all blocking events
// 	    are recorded, equivalent to -test.blockprofilerate=1.
//
// 	-coverprofile cover.out
// 	    Write a coverage profile to the file after all tests have passed.
// 	    Sets -cover.
//
// 	-cpuprofile cpu.out
// 	    Write a CPU profile to the specified file before exiting.
// 	    Writes test binary as -c would.
//
// 	-memprofile mem.out
// 	    Write a memory profile to the file after all tests have passed.
// 	    Writes test binary as -c would.
//
// 	-memprofilerate n
// 	    Enable more precise (and expensive) memory profiles by setting
// 	    runtime.MemProfileRate.  See 'go doc runtime.MemProfileRate'.
// 	    To profile all memory allocations, use -test.memprofilerate=1
// 	    and pass --alloc_space flag to the pprof tool.
//
// 	-mutexprofile mutex.out
// 	    Write a mutex contention profile to the specified file
// 	    when all tests are complete.
// 	    Writes test binary as -c would.
//
// 	-mutexprofilefraction n
// 	    Sample 1 in n stack traces of goroutines holding a
// 	    contended mutex.
//
// 	-outputdir directory
// 	    Place output files from profiling in the specified directory,
// 	    by default the directory in which "go test" is running.
//
// 	-trace trace.out
// 	    Write an execution trace to the specified file before exiting.
//
// Each of these flags is also recognized with an optional 'test.' prefix,
// as in -test.v. When invoking the generated test binary (the result of
// 'go test -c') directly, however, the prefix is mandatory.
//
// The 'go test' command rewrites or removes recognized flags,
// as appropriate, both before and after the optional package list,
// before invoking the test binary.
//
// For instance, the command
//
// 	go test -v -myflag testdata -cpuprofile=prof.out -x
//
// will compile the test binary and then run it as
//
// 	pkg.test -test.v -myflag testdata -test.cpuprofile=prof.out
//
// (The -x flag is removed because it applies only to the go command's
// execution, not to the test itself.)
//
// The test flags that generate profiles (other than for coverage) also
// leave the test binary in pkg.test for use when analyzing the profiles.
//
// When 'go test' runs a test binary, it does so from within the
// corresponding package's source code directory. Depending on the test,
// it may be necessary to do the same when invoking a generated test
// binary directly.
//
// The command-line package list, if present, must appear before any
// flag not known to the go test command. Continuing the example above,
// the package list would have to appear before -myflag, but could appear
// on either side of -v.
//
// To keep an argument for a test binary from being interpreted as a
// known flag or a package name, use -args (see 'go help test') which
// passes the remainder of the command line through to the test binary
// uninterpreted and unaltered.
//
// For instance, the command
//
// 	go test -v -args -x -v
//
// will compile the test binary and then run it as
//
// 	pkg.test -test.v -x -v
//
// Similarly,
//
// 	go test -args math
//
// will compile the test binary and then run it as
//
// 	pkg.test math
//
// In the first example, the -x and the second -v are passed through to the
// test binary unchanged and with no effect on the go command itself.
// In the second example, the argument math is passed through to the test
// binary, instead of being interpreted as the package list.
//
//
// Description of testing functions
//
// The 'go test' command expects to find test, benchmark, and example functions
// in the "*_test.go" files corresponding to the package under test.
//
// A test function is one named TestXXX (where XXX is any alphanumeric string
// not starting with a lower case letter) and should have the signature,
//
// 	func TestXXX(t *testing.T) { ... }
//
// A benchmark function is one named BenchmarkXXX and should have the signature,
//
// 	func BenchmarkXXX(b *testing.B) { ... }
//
// An example function is similar to a test function but, instead of using
// *testing.T to report success or failure, prints output to os.Stdout.
// If the last comment in the function starts with "Output:" then the output
// is compared exactly against the comment (see examples below). If the last
// comment begins with "Unordered output:" then the output is compared to the
// comment, however the order of the lines is ignored. An example with no such
// comment is compiled but not executed. An example with no text after
// "Output:" is compiled, executed, and expected to produce no output.
//
// Godoc displays the body of ExampleXXX to demonstrate the use
// of the function, constant, or variable XXX.  An example of a method M with
// receiver type T or *T is named ExampleT_M.  There may be multiple examples
// for a given function, constant, or variable, distinguished by a trailing _xxx,
// where xxx is a suffix not beginning with an upper case letter.
//
// Here is an example of an example:
//
// 	func ExamplePrintln() {
// 		Println("The output of\nthis example.")
// 		// Output: The output of
// 		// this example.
// 	}
//
// Here is another example where the ordering of the output is ignored:
//
// 	func ExamplePerm() {
// 		for _, value := range Perm(4) {
// 			fmt.Println(value)
// 		}
//
// 		// Unordered output: 4
// 		// 2
// 		// 1
// 		// 3
// 		// 0
// 	}
//
// The entire test file is presented as the example when it contains a single
// example function, at least one other function, type, variable, or constant
// declaration, and no test or benchmark functions.
//
// See the documentation of the testing package for more information.
//
//
package main
