
#include <fcntl.h>
#include <sys/ioctl.h>
#include "bsd_audioio.h"

main(argc, argv)
	char          **argv;
{
	char            buf[65536];
	int             len, wlen, fd, fdin;
	audio_info_t    ai;
	int             i, val;
	char           *dev[] = {"aud0", "aud1", "aud2", "aud3", 
				"aud4", "aud5"};

	if (argc > 1) {
		i = atoi(argv[1]);
		if (i < 0 || i >= 6)
			i = 0;
	} else
		i = 0;

	fdin = open("samp.slin", 0);
	if (fdin < 0) {
		perror("open bart.snd");
		return (1);
	}

	printf("using dev %s\n", dev[i]);
	fd = open(dev[i], O_WRONLY);
	if (fd < 0) {
		perror("open");
		return (1);
	}

	len = read(fdin, buf, 65536);

	ai.mode = AUMODE_PLAY;
	ai.play.sample_rate = 8000;
	ai.play.encoding = AUDIO_ENCODING_SIGNED;
	ai.play.gain = AUDIO_MAX_GAIN;
	ioctl(fd, AUDIO_SETINFO, &ai);

	wlen = write(fd, buf, len);
	printf("write len = %x\n", wlen);

	sleep(1);
 	ai.mode = AUMODE_PLAY;
	ai.play.sample_rate = 10000;
	ai.play.encoding = AUDIO_ENCODING_SIGNED;
	ai.play.gain = AUDIO_MAX_GAIN;
	ioctl(fd, AUDIO_SETINFO, &ai);

 	wlen = write(fd, buf, len);
	printf("write len = %x\n", wlen);

	close(fd);
	close(fdin);
}

