/*
 * input 8 bit mu-law
 * output 14 bit linear (signed)
 */
int 
mu_to_linear(in)
	char            in;
{
	int             seg, sign, off, ret;

	in = ~in;
	sign = in & 0x80;
	seg = (in >> 4) & 0x07;
	off = in & 0x0f;

	ret = (((off << 1) + 33) << seg) - 33;
	if (sign)
		ret = -ret;

	return (ret);
}

main()
{
	int             i, x;
	unsigned char   y, z;

	printf("char ulaw_to_lin[] = {\n  ");
	for (i = 0; i < 256; i++) {
		x = mu_to_linear(i);
		y = x >> 6;
		printf("0x%02x, ", y);
		if ((i + 1) % 16 == 0)
			printf("\n  ");
	}
	printf("\n};\n");
}
