#include <xalloca.h>
#include <math.h>

#include <sipp.h>


Object *
sipp_cylinder(radius, length, res, surface, shader)
    double  radius;
    double  length;
    int     res;
    void   *surface;
    Shader *shader;
{
    Object *cylinder;
    double *x_arr;
    double *y_arr;
    int     i;

    x_arr = (double *)alloca(res * sizeof(double));
    y_arr = (double *)alloca(res * sizeof(double));

    for (i = 0; i < res; i++) {
        x_arr[i] = radius * cos(i * 2.0 * M_PI / res);
        y_arr[i] = radius * sin(i * 2.0 * M_PI / res);
    }

    cylinder = object_create();

    /* Create the outer surface */
    for (i = 0; i < res; i++) {
        vertex_tx_push(x_arr[i], y_arr[i], -length / 2.0, 
                       x_arr[i], y_arr[i], -length / 2.0);
        vertex_tx_push(x_arr[(i + 1) % res], y_arr[(i + 1) % res],
                       -length / 2.0, 
                       x_arr[(i + 1) % res], y_arr[(i + 1) % res],
                       -length / 2.0);
        vertex_tx_push(x_arr[(i + 1) % res], y_arr[(i + 1) % res],
                       length / 2.0, 
                       x_arr[(i + 1) % res], y_arr[(i + 1) % res],
                       length / 2.0);
        vertex_tx_push(x_arr[i], y_arr[i], length / 2.0, 
                       x_arr[i], y_arr[i], length / 2.0);
        polygon_push();
    }
    object_add_surface(cylinder, surface_create(surface, shader));

    /* Create the bottom lid */
    for (i = res - 1; i >= 0; i--) {
        vertex_tx_push(x_arr[i], y_arr[i], -length / 2.0, 
                       x_arr[i], y_arr[i], -length / 2.0);
    }
    polygon_push();
    object_add_surface(cylinder, surface_create(surface, shader));

    /* Create the top lid. */
    for (i = 0; i < res; i++) {
        vertex_tx_push(x_arr[i], y_arr[i], length / 2.0, 
                       x_arr[i], y_arr[i], length / 2.0);
    }
    polygon_push();
    object_add_surface(cylinder, surface_create(surface, shader));

    return cylinder;
}
