#!/usr/bin/python
#
# Test the GtkMenuBar, GtkMenu and GtkMenuItem, GtkList and
# GtkListItem, GtkFileSelection objects
#

import sys
import time
from Gtkinter import *

class Application:		
	def __init__(self, argv):
		self.w_window=GtkWindow()
		self.w_window.set_title("Test application")
		self.w_window.border_width(10)		
		self.w_vbox=GtkVBox()
		
		self.init_menu()
		self.init_list()
		self.init_button()
		
		self.w_window.add(self.w_vbox)
		self.w_vbox.show()
		self.w_window.show()		
		
		self.idlecount=0
		idle_add(self.idle)

	def mainloop(self):
		mainloop()

	def quit(self, mi):
		mainquit()
				
	def doit(self, button):
		z=[]
		for x in range(10,20):
			item=GtkListItem(label="line %d" % x)
			item.show()
			z.append(item)
		self.w_listbox.append_items(z)
	

	def init_menu(self):
		self.w_menubar=GtkMenuBar()
		
		# file menu
		self.w_filemenu=GtkMenu()
		filemenu=GtkMenuItem('File')
		filemenu.set_submenu(self.w_filemenu)
		filemenu.show()
		
		item=GtkMenuItem('New'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_new); item.show()
		item=GtkMenuItem('Open...'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_open); item.show()
		item=GtkMenuItem('Save'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_save); item.show()
		item=GtkMenuItem('Save As...'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_save_as); item.show()
		item=GtkMenuItem('Close'); self.w_filemenu.append(item)
		item.connect('activate', self.process_file_close); item.show()
		item=GtkMenuItem('Quit'); self.w_filemenu.append(item)
		item.connect('activate', self.quit); item.show()

		# edit menu
		self.w_editmenu=GtkMenu()
		editmenu=GtkMenuItem('Edit')
		editmenu.set_submenu(self.w_editmenu)
		editmenu.show()
		
		item=GtkMenuItem('Cut'); self.w_editmenu.append(item)
		item.connect('activate', self.process_edit_cut); item.show()
		item=GtkMenuItem('Copy'); self.w_editmenu.append(item)
		item.connect('activate', self.process_edit_copy); item.show()
		item=GtkMenuItem('Paste'); self.w_editmenu.append(item)
		item.connect('activate', self.process_edit_paste); item.show()
		
		self.w_menubar.append(filemenu)
		self.w_menubar.append(editmenu)
		self.w_vbox.pack_start(self.w_menubar, expand=FALSE)
		self.w_menubar.show()
		

	def init_list(self):		
		c=GtkScrolledWindow()	
		c.set_usize(250,200)
		self.w_listbox=GtkList()
		self.w_listbox.set_selection_mode(SELECTION_MULTIPLE)
		c.add(self.w_listbox)
		self.w_vbox.pack_start(c)
		
		for x in range(0,10):
			item=GtkListItem(label="line %d" % x)
			item.show()
			self.w_listbox.add(item)
		self.w_listbox.show()
		c.show()
		
	def init_button(self):
		t = GtkTable(rows=1, cols=2, homogeneous=TRUE)
		b1 = GtkButton('Do it!')
		b1.connect('clicked', self.doit)
		b2 = GtkButton('Quit')
		b2.connect('clicked', self.quit)
		t.attach(b1, 0, 1, 0, 1, yoptions=0, xpadding=2, ypadding=2)
		t.attach(b2, 1, 2, 0, 1, yoptions=0, xpadding=2, ypadding=2)
		
		self.w_vbox.pack_end(t, expand=FALSE)
				
		b1.show()
		b2.show()
		t.show()

	def process_file_new(self, mi):
		print "process_file_new"
		
	def process_file_open(self, mi):
		print "process_file_open"
		# how to transform this in modal dialog is myterious...
		fs=GtkFileSelection()
		fs.ok_button.connect('clicked', fs.destroy)
		fs.show()
		
	def process_file_save(self, mi):
		print "process_file_save"
		
	def process_file_save_as(self, mi):
		print "process_file_save_as"
		# how to transform this in modal dialog is myterious...
		fs=GtkFileSelection()
		fs.show()
		
	def process_file_close(self, mi):
		print "process_file_close"
		
	def process_edit_cut(self, mi):
		print "process_edit_cut"
		
	def process_edit_copy(self, mi):
		print "process_edit_copy"
		
	def process_edit_paste(self, mi):
		print "process_edit_paste"
		
	
	def idle(self):
		self.idlecount=self.idlecount+1
		if(self.idlecount % 1000 == 0):
			print "Idle:", self.idlecount
			# if measuring time
			##self.quit()
		idle_add(self.idle)

			
if(__name__=="__main__"):
	use_defaults=1
	for arg in sys.argv:
		if(arg=="-d"):
			import pdb
			pdb.set_trace()

		if(arg=="-n"):
			use_defaults=0
			
	start_time = time.time()
	
#	if(use_defaults==1):
#		gtk.rc_parse("defaults.rc")
	
	app=Application(sys.argv)
	app.mainloop()
	the_time = time.time() - start_time
	print "Application ran %.2f s." % the_time
	
