static const char *gtk_win32_default_css = 
   "@define-color bg_color -gtk-win32-color(button, 15);\n"
   "\n"
   "/* Buttons */\n"
   "\n"
   ".button {\n"
   "    background-color: none;\n"
   "    background-image: -gtk-win32-theme-part(button, 1 1);\n"
   "    border-width: 0;\n"
   "    -GtkWidget-focus-line-width: 1;\n"
   "    -GtkWidget-focus-padding: 3;\n"
   "    -GtkButton-interior-focuse: true;\n"
   "}\n"
   "\n"
   ".button:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(button, 1 4);\n"
   "}\n"
   "\n"
   ".button:focused {\n"
   "    background-image: -gtk-win32-theme-part(button, 1 5);\n"
   "}\n"
   "\n"
   ".button:prelight, .button:prelight:focused {\n"
   "    background-image: -gtk-win32-theme-part(button, 1 2);\n"
   "    color: #000000;\n"
   "}\n"
   "\n"
   ".button:active, .button:active:focused, .button:active:focused:prelight {\n"
   "    background-image: -gtk-win32-theme-part(button, 1 3);\n"
   "}\n"
   "\n"
   "/* Check buttons */\n"
   "\n"
   ".check {\n"
   "    background-color: none;\n"
   "    background-image: -gtk-win32-theme-part(button, 3 1);\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   ".check:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(button, 3 4);\n"
   "}\n"
   "\n"
   ".check:prelight {\n"
   "    background-image: -gtk-win32-theme-part(button, 3 2);\n"
   "}\n"
   "\n"
   ".check:active {\n"
   "    background-image: -gtk-win32-theme-part(button, 3 5);\n"
   "}\n"
   "\n"
   ".check:active:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(button, 3 8);\n"
   "}\n"
   "\n"
   ".check:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(button, 3 6);\n"
   "}\n"
   "\n"
   ".check:inconsistent {\n"
   "    background-image: -gtk-win32-theme-part(button, 3 9);\n"
   "}\n"
   "\n"
   ".check:inconsistent:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(button, 3 12);\n"
   "}\n"
   "\n"
   ".check:inconsistent:prelight {\n"
   "    background-image: -gtk-win32-theme-part(button, 3 10);\n"
   "}\n"
   "\n"
   "/* Radio buttons */\n"
   "\n"
   ".radio {\n"
   "    background-color: none;\n"
   "    background-image: -gtk-win32-theme-part(button, 2 1);\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   ".radio:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(button, 2 4);\n"
   "}\n"
   "\n"
   ".radio:prelight {\n"
   "    background-image: -gtk-win32-theme-part(button, 2 2);\n"
   "}\n"
   "\n"
   ".radio:active {\n"
   "    background-image: -gtk-win32-theme-part(button, 2 5);\n"
   "}\n"
   "\n"
   ".radio:active:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(button, 2 8);\n"
   "}\n"
   "\n"
   ".radio:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(button, 2 6);\n"
   "}\n"
   "\n"
   ".radio:inconsistent {\n"
   "    background-image: -gtk-win32-theme-part(button, 2 1, over (2 5, 0.3));\n"
   "}\n"
   "\n"
   ".radio:inconsistent:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(button, 2 4, over (2 8, 0.3));\n"
   "}\n"
   "\n"
   ".radio:inconsistent:prelight {\n"
   "    background-image: -gtk-win32-theme-part(button, 2 4, over(2 6, 0.3));\n"
   "}\n"
   "\n"
   "/* Scrollbars */\n"
   "\n"
   "/* TODO: Win32 has different concept for upper and lower trough, we\n"
   "   don't use this atm */\n"
   "\n"
   ".scrollbar {\n"
   "    background-color: none;\n"
   "    -GtkRange-trough-border: 0;\n"
   "    -GtkRange-arrow-scaling: 0.0;\n"
   "    -GtkRange-slider-width: -gtk-win32-size(scrollbar, 3);\n"
   "}\n"
   "\n"
   ".scrollbar.vertical {\n"
   "    -GtkRange-slider-width: -gtk-win32-size(scrollbar, 2);\n"
   "}\n"
   "\n"
   ".scrollbar.button.bottom {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 5);\n"
   "}\n"
   "\n"
   ".scrollbar.button.bottom:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 6);\n"
   "}\n"
   "\n"
   ".scrollbar.button.bottom:active,\n"
   ".scrollbar.button.bottom:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 7);\n"
   "}\n"
   "\n"
   ".scrollbar.button.bottom:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 8);\n"
   "}\n"
   "\n"
   ".scrollbar.button.top {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 1);\n"
   "}\n"
   "\n"
   ".scrollbar.button.top:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 2);\n"
   "}\n"
   "\n"
   ".scrollbar.button.top:active,\n"
   ".scrollbar.button.top:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 3);\n"
   "}\n"
   "\n"
   ".scrollbar.button.top:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 4);\n"
   "}\n"
   "\n"
   ".scrollbar.button.left {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 9);\n"
   "}\n"
   "\n"
   ".scrollbar.button.left:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 10);\n"
   "}\n"
   "\n"
   ".scrollbar.button.left:active,\n"
   ".scrollbar.button.left:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 11);\n"
   "}\n"
   "\n"
   ".scrollbar.button.left:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 12);\n"
   "}\n"
   "\n"
   ".scrollbar.button.right {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 13);\n"
   "}\n"
   "\n"
   ".scrollbar.button.right:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 14);\n"
   "}\n"
   "\n"
   ".scrollbar.button.right:active,\n"
   ".scrollbar.button.right:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 15);\n"
   "}\n"
   "\n"
   ".scrollbar.button.right:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 1 16);\n"
   "}\n"
   "\n"
   ".scrollbar.trough {\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 2 1, over (4 1));\n"
   "}\n"
   "\n"
   ".scrollbar.trough.vertical {\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 2 1, over (6 1));\n"
   "}\n"
   "\n"
   ".scrollbar.slider {\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 2 1, over (8 1));\n"
   "}\n"
   "\n"
   ".scrollbar.slider:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 2 2, over (8 2));\n"
   "}\n"
   "\n"
   ".scrollbar.slider.vertical {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 3 1, over (9 1));\n"
   "}\n"
   "\n"
   ".scrollbar.slider.vertical:prelight {\n"
   "    background-image: -gtk-win32-theme-part(scrollbar, 3 2, over (9 2));\n"
   "}\n"
   "\n"
   "/* Entry */\n"
   "\n"
   "/* TODO: For entries with set_has_frame FALSE we should use 'edit, 3 1', not \n"
   "   sure how to select for this though */\n"
   ".entry {\n"
   "    background-color: black;\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(edit, 1 1);\n"
   "}\n"
   ".entry:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(edit, 1 4);\n"
   "}\n"
   ".entry:prelight {\n"
   "    background-image: -gtk-win32-theme-part(edit, 1 4);\n"
   "}\n"
   "\n"
   "/* Spinbuttons */\n"
   "\n"
   ".spinbutton.button,\n"
   ".spinbutton.button:focused {\n"
   "    background-color: none;\n"
   "    border-width: 1 1 0 0;\n"
   "    border-style: none;\n"
   "    background-image: -gtk-win32-theme-part(spin, 1 1);\n"
   "    color: rgba(0, 0, 0, 0);\n"
   "}\n"
   "\n"
   ".spinbutton.button:prelight,\n"
   ".spinbutton.button:prelight:focused {\n"
   "    background-image: -gtk-win32-theme-part(spin, 1 2);\n"
   "    color: rgba(0, 0, 0, 0);\n"
   "}\n"
   "\n"
   ".spinbutton.button:active,\n"
   ".spinbutton.button:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(spin, 1 3);\n"
   "    color: rgba(0, 0, 0, 0);\n"
   "}\n"
   "\n"
   ".spinbutton.button:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(spin, 1 4);\n"
   "    color: rgba(0, 0, 0, 0);\n"
   "}\n"
   "\n"
   ".spinbutton.button.bottom,\n"
   ".spinbutton.button.bottom:focused {\n"
   "    border-width: 0 1 1 0;\n"
   "    background-image: -gtk-win32-theme-part(spin, 2 1);\n"
   "    color: rgba(0, 0, 0, 0);\n"
   "}\n"
   "\n"
   ".spinbutton.button.bottom:prelight,\n"
   ".spinbutton.button.bottom:prelight:focused {\n"
   "    background-image: -gtk-win32-theme-part(spin, 2 2);\n"
   "    color: rgba(0, 0, 0, 0);\n"
   "}\n"
   "\n"
   ".spinbutton.button.bottom:active,\n"
   ".spinbutton.button.bottom:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(spin, 2 3);\n"
   "    color: rgba(0, 0, 0, 0);\n"
   "}\n"
   "\n"
   ".spinbutton.button.bottom:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(spin, 2 4);\n"
   "    color: rgba(0, 0, 0, 0);\n"
   "}\n"
   "\n"
   "/* Ranges */\n"
   "\n"
   "/* TODO: The trough is not quite right, it covers everything,\n"
   "   but in win32 the slider 'sticks out' on the sides of the\n"
   "   trough */\n"
   "\n"
   ".scale {\n"
   "    background-color: none;\n"
   "    -GtkScale-value-spacing: 0;\n"
   "    -GtkScale-slider-length: 9;\n"
   "    -GtkRange-slider-width: 20;\n"
   "    -GtkRange-trough-border: 0;\n"
   "}\n"
   "\n"
   ".scale.trough {\n"
   "    border-style: none;\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 1 1, margins (2 0 2 0));\n"
   "}\n"
   "\n"
   ".scale.trough.vertical {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 1 1, margins (0 2 0 2));\n"
   "}\n"
   "\n"
   ".scale.slider {\n"
   "    background-color: none;\n"
   "    border-width: 0;\n"
   "    color: rgba(0,0,0,0);\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 3 1);\n"
   "}\n"
   "\n"
   ".scale.slider:prelight {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 3 2);\n"
   "}\n"
   "\n"
   ".scale.slider:active,\n"
   ".scale.slider:prelight:active {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 3 3);\n"
   "}\n"
   "\n"
   ".scale.slider:focus {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 3 4);\n"
   "}\n"
   "\n"
   ".scale.slider:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 3 5);\n"
   "}\n"
   "\n"
   ".scale.slider.vertical {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 6 1);\n"
   "}\n"
   "\n"
   ".scale.slider.vertical:prelight {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 6 2);\n"
   "}\n"
   "\n"
   ".scale.slider.vertical:active,\n"
   ".scale.slider.vertical:prelight:active {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 6 3);\n"
   "}\n"
   "\n"
   ".scale.slider.vertical:focus {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 6 4);\n"
   "}\n"
   "\n"
   ".scale.slider.vertical:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 6 5);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 4 1);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below:prelight {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 4 2);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below:active,\n"
   ".scale.slider.scale-has-marks-below:prelight:active {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 4 3);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below:focus {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 4 4);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 4 5);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below.vertical {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 8 1);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below.vertical:prelight {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 8 2);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below.vertical:active,\n"
   ".scale.slider.scale-has-marks-below.vertical:prelight:active {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 8 3);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below.vertical:focus {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 8 4);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-below.vertical:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 8 5);\n"
   "}\n"
   "\n"
   "\n"
   "\n"
   ".scale.slider.scale-has-marks-above {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 5 1);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-above:prelight {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 5 2);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-above:active,\n"
   ".scale.slider.scale-has-marks-above:prelight:active {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 5 3);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-above:focus {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 5 4);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-above:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 5 5);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-above.vertical {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 7 1);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-above.vertical:prelight {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 7 2);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-above.vertical:active,\n"
   ".scale.slider.scale-has-marks-above.vertical:prelight:active {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 7 3);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-above.vertical:focus {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 7 4);\n"
   "}\n"
   "\n"
   ".scale.slider.scale-has-marks-above.vertical:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(trackbar, 7 5);\n"
   "}\n"
   "\n"
   "/* Progress bars */\n"
   "\n"
   "GtkProgressBar {\n"
   "    background-color: none;\n"
   "    padding: 0;\n"
   "}\n"
   "\n"
   "GtkProgressBar.trough {\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(progress, 1 1);\n"
   "}\n"
   "\n"
   "GtkProgressBar.progressbar,\n"
   "GtkEntry.progressbar {\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(progress, 5 1);\n"
   "}\n"
   "\n"
   "GtkProgressBar.progressbar.pulse,\n"
   "GtkEntry.progressbar.pulse {\n"
   "    background-image: -gtk-win32-theme-part(progress, 8 1);\n"
   "}\n"
   "\n"
   "GtkProgressBar.trough.vertical {\n"
   "    background-image: -gtk-win32-theme-part(progress, 2 1);\n"
   "}\n"
   "\n"
   ".progressbar.vertical {\n"
   "    background-image: -gtk-win32-theme-part(progress, 6 1);\n"
   "}\n"
   "\n"
   ".progressbar.pulse.vertical {\n"
   "    background-image: -gtk-win32-theme-part(progress, 10 1);\n"
   "}\n"
   "\n"
   "/* Menus */\n"
   "\n"
   ".menubar {\n"
   "    background-color: none;\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(menu, 7 1);\n"
   "}\n"
   "\n"
   ".menubar .menuitem {\n"
   "    background-color: none;\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(menu, 8 1);\n"
   "}\n"
   "\n"
   ".menubar .menuitem:prelight {\n"
   "    background-color: none;\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(menu, 8 3);\n"
   "}\n"
   "\n"
   ".menuitem:prelight {\n"
   "    background-color: none;\n"
   "    background-image: -gtk-win32-theme-part(menu, 14 2);\n"
   "\n"
   "}\n"
   "\n"
   ".menuitem.radio,\n"
   ".menuitem.radio:prelight,\n"
   ".menuitem.radio:insensitive {\n"
   "    background-color: none;\n"
   "    background-image: none;\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   ".menuitem.radio:active, \n"
   ".menuitem.radio:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(menu, 11 3);\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   ".menuitem.radio:inconsistent,\n"
   ".menuitem.radio:inconsistent:insensitive,\n"
   ".menuitem.radio:inconsistent:prelight,\n"
   ".menuitem.radio:inconsistent:active,\n"
   ".menuitem.radio:inconsistent:active:prelight {\n"
   "    background-image: none; /* Fall back to default, this state is not in win32 */\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   ".menuitem.radio:insensitive:active,\n"
   ".menuitem.radio:insensitive:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(menu, 11 4);\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   ".menuitem.check,\n"
   ".menuitem.check:prelight,\n"
   ".menuitem.check:insensitive {\n"
   "    background-image: none;\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   ".menuitem.check:active, \n"
   ".menuitem.check:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(menu, 11 1);\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   ".menuitem.check:inconsistent,\n"
   ".menuitem.check:inconsistent:insensitive,\n"
   ".menuitem.check:inconsistent:prelight,\n"
   ".menuitem.check:inconsistent:active,\n"
   ".menuitem.check:inconsistent:active:prelight {\n"
   "    background-image: none; /* Fall back to default, this state is not in win32 */\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   ".menuitem.check:insensitive:active,\n"
   ".menuitem.check:insensitive:active:prelight{\n"
   "    background-image: -gtk-win32-theme-part(menu, 11 2);\n"
   "    border-width: 0;\n"
   "}\n"
   "\n"
   "/* Combobox */\n"
   "\n"
   "\n"
   "GtkComboBox.combobox-entry .button {\n"
   "    background-color: none;\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(combobox, 1 1);\n"
   "    color: rgba(0, 0, 0, 0);\n"
   "}\n"
   "\n"
   "GtkComboBox.combobox-entry .button:prelight,\n"
   "GtkComboBox.combobox-entry .button:focused,\n"
   "GtkComboBox.combobox-entry .button:prelight:focused {\n"
   "    background-image: -gtk-win32-theme-part(combobox, 1 2);\n"
   "}\n"
   "GtkComboBox.combobox-entry .button:active,\n"
   "GtkComboBox.combobox-entry .button:active:focused,\n"
   "GtkComboBox.combobox-entry .button:active:prelight,\n"
   "GtkComboBox.combobox-entry .button:active:focused:prelight {\n"
   "    background-image: -gtk-win32-theme-part(combobox, 1 3);\n"
   "}\n"
   "GtkComboBox.combobox-entry .button:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(combobox, 1 4);\n"
   "}\n"
   "\n"
   "/* Notebook */\n"
   "\n"
   ".notebook {\n"
   "    background-color: none;\n"
   "    border-width: 1 3 2 2;\n"
   "    border-style: solid;\n"
   "    background-origin: padding-box;\n"
   "    background-clip: border-box;\n"
   "    /*background-image: -gtk-win32-theme-part(tab, 9 1, margins(-2)); */\n"
   "    border-image: -gtk-win32-theme-part(tab, 9 1) 1 3 2 2 stretch;\n"
   "    -GtkNotebook-tab-overlap: 1;\n"
   "    -GtkNotebook-tab-curvature: 0;\n"
   "}\n"
   "\n"
   ".notebook tab {\n"
   "    background-color: none;\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(tab, 1 1);\n"
   "}\n"
   "\n"
   ".notebook tab:active {\n"
   "    background-image: -gtk-win32-theme-part(tab, 1 3, margins(0 0 -1 0));\n"
   "    padding: 4;\n"
   "}\n"
   "\n"
   ".notebook tab:last-child {\n"
   "    background-image: -gtk-win32-theme-part(tab, 3 1);\n"
   "}\n"
   "\n"
   ".notebook tab:active:last-child {\n"
   "    background-image: -gtk-win32-theme-part(tab, 3 3, margins(0 0 -1 0));\n"
   "}\n"
   "\n"
   ".notebook {\n"
   "    background-color: #ffffff;\n"
   "}\n"
   "\n"
   "/* Toolbar */\n"
   "\n"
   ".toolbar {\n"
   "    background-color: none;\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(rebar, 6 1);\n"
   "}\n"
   "\n"
   ".toolbar .button,\n"
   ".toolbar .button:focused {\n"
   "    background-color: none;\n"
   "    background-image: -gtk-win32-theme-part(toolbar, 1 1);\n"
   "}\n"
   "\n"
   ".toolbar .button:prelight,\n"
   ".toolbar .button:prelight:focused {\n"
   "    background-image: -gtk-win32-theme-part(toolbar, 1 2);\n"
   "}\n"
   "\n"
   ".toolbar .button:active {\n"
   "    background-image: -gtk-win32-theme-part(toolbar, 1 3);\n"
   "}\n"
   "\n"
   ".toolbar .button:active:prelight {\n"
   "    background-image: -gtk-win32-theme-part(toolbar, 1 6);\n"
   "}\n"
   "\n"
   ".toolbar .button:insensitive {\n"
   "    background-image: -gtk-win32-theme-part(toolbar, 1 4);\n"
   "}\n"
   "\n"
   "/* Column headers */\n"
   "\n"
   "column-header .button,\n"
   "column-header .button:focus {\n"
   "    background-color: none;\n"
   "    border-width: 0;\n"
   "    background-image: -gtk-win32-theme-part(header, 1 1);\n"
   "}\n"
   "\n"
   "column-header .button:prelight,\n"
   "column-header .button:prelight:focus {\n"
   "    background-image: -gtk-win32-theme-part(header, 1 2);\n"
   "}\n"
   "\n"
   "column-header .button:active,\n"
   "column-header .button:active:prelight,\n"
   "column-header .button:active:focus,\n"
   "column-header .button:active:prelight:focus {\n"
   "    background-image: -gtk-win32-theme-part(header, 1 3);\n"
   "}\n"
;
